/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.Expr;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodeFactory;
import apex.jorje.semantic.ast.TypeConversion;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.IdentifierContext;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.IllegalInstanceReferenceVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.common.I18nSupplier;
import apex.jorje.semantic.common.Result;
import apex.jorje.semantic.common.iterator.EqualPairIterator;
import apex.jorje.semantic.common.iterator.Pair;
import apex.jorje.semantic.symbol.member.method.ConstructorCall;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.Signature;
import apex.jorje.semantic.symbol.member.method.SignatureFactory;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class ThisMethodCallExpression
extends Expression {
    private final Loc loc;
    private final List<Expression> parameters;
    private MethodInfo method;

    public ThisMethodCallExpression(AstNode definingNode, Expr.ThisMethodCallExpr expr) {
        super(definingNode);
        this.loc = expr.loc;
        this.parameters = AstNodeFactory.createExpressions(this, expr.inputParameters);
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            for (Expression parameter : this.parameters) {
                parameter.traverse(visitor, scope);
            }
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Expression expression : this.parameters) {
            expression.validate(symbols, scope);
            builder.add(expression.getType());
            expression.traverse(new IllegalInstanceReferenceVisitor(), scope);
        }
        ImmutableCollection parameterTypes = builder.build();
        if (scope.getErrors().isInvalid(this.parameters)) {
            scope.getErrors().markInvalid(this);
            return;
        }
        TypeInfo type = this.getDefiningType();
        Signature signature = SignatureFactory.create("<init>", (TypeInfo)TypeInfos.VOID, (List<TypeInfo>)((Object)parameterTypes));
        Result<MethodInfo> result = symbols.lookupMethodInfo(this.getDefiningType(), IdentifierContext.OBJECT, type, signature);
        if (scope.getErrors().addIfError((AstNode)this, result, I18nSupplier.create("invalid.constructor", signature))) {
            return;
        }
        this.method = result.get();
        this.setConstructorCall(ConstructorCall.THIS);
        if (!(!scope.isOutsideMethod() && scope.getMethod().isConstructor() && scope.isTopLevelBlock() && scope.isFirstStatementInBlock() && this.isTopLevel())) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.this.call"));
            return;
        }
        this.setType(this.method.getReturnType());
    }

    @Override
    public void emit(Emitter emitter) {
        emitter.emitVar(this.loc, 25, 0);
        for (Pair<Expression, TypeInfo> pair : EqualPairIterator.iterable(this.parameters, this.method.getParameterTypes())) {
            ((Expression)pair.left).emit(emitter);
            TypeConversion.emit(this.loc, emitter, ((Expression)pair.left).getType(), (TypeInfo)pair.right);
        }
        emitter.emit(this.loc, this.method.getAsmMethod());
    }

    @Override
    public Loc getLoc() {
        return this.loc;
    }

    public int getNumParameters() {
        return this.parameters.size();
    }
}

