/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.DottedExpr;
import apex.jorje.data.ast.Identifier;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.DottedExpression;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.IdentifierContext;
import apex.jorje.semantic.ast.expression.ReferenceType;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.SystemMethods;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.member.variable.VariableValidateLoadVisitor;
import apex.jorje.semantic.symbol.member.variable.VariableVisitor;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.resolver.VariableResolver;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.UnresolvedTypeInfoFactory;
import apex.jorje.semantic.symbol.visibility.Visibility;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Location;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.PrinterUtil;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import shaded.org.objectweb.asm.Label;

public class ReferenceExpression
extends Expression {
    private final DottedExpression dottedExpression;
    private final Expression expression;
    private final ReferenceType reference;
    private List<Identifier> names;
    private List<Variable> variables;
    private List<VariableVisitor.Context> contexts;
    private IdentifierContext previousContext;
    private TypeInfo firstSObjectTypeInfo;

    public ReferenceExpression(Expression expression, ReferenceType reference, Optional<DottedExpr> dottedExpr, List<Identifier> names) {
        super(expression);
        this.expression = expression;
        this.dottedExpression = new DottedExpression(this, dottedExpr);
        this.names = names;
        this.reference = reference;
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.dottedExpression.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        this.dottedExpression.validate(symbols, scope);
        if (scope.getErrors().isInvalid((AstNode)this.dottedExpression)) {
            scope.getErrors().markInvalid(this);
            return;
        }
        IdentifierContext identifierContext = this.previousContext = this.dottedExpression.isNoop() ? IdentifierContext.NONE : IdentifierContext.OBJECT;
        if (this.names.isEmpty()) {
            this.setType(this.dottedExpression.getType());
            this.variables = Collections.emptyList();
            this.contexts = Collections.emptyList();
            return;
        }
        this.variables = symbols.lookupVariableInfo(this.getDefiningType(), this.previousContext, this.dottedExpression.getType(), this.names);
        TypeInfo type = UnresolvedTypeInfoFactory.get();
        if (this.variables.isEmpty() && this.dottedExpression.isNoop()) {
            VariableResolver.StaticResult staticResult = symbols.lookupStaticVariableInfo(this.getDefiningType(), this.names, this.reference);
            this.variables = staticResult.variables;
            if (!this.variables.isEmpty()) {
                this.previousContext = IdentifierContext.STATIC;
                this.names = this.names.subList(staticResult.position, this.names.size());
            } else {
                type = symbols.lookupTypeInfoIdentifiers(this.getDefiningType(), this.names, this.reference);
                this.previousContext = IdentifierContext.STATIC;
            }
        }
        if (!this.variables.isEmpty()) {
            type = this.variables.get(this.variables.size() - 1).getType();
        }
        if (!type.isResolved()) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("variable.does.not.exist", PrinterUtil.get().getFactory().dottedIdentifier().print(this.names, new PrintContext())));
            return;
        }
        if (this.previousContext == IdentifierContext.STATIC && !Visibility.isTypeVisibleInImplicitReference(symbols.getAccessEvaluator(), this.getDefiningType(), type, scope.isTestMethod())) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("type.not.visible", type));
            return;
        }
        if (!this.variables.isEmpty() && this.variables.size() != this.names.size()) {
            Identifier name = this.names.get(this.variables.size());
            scope.getErrors().markInvalid((AstNode)this, name.loc, I18nSupport.getLabel("variable.does.not.exist", name.value));
            return;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        VariableValidateLoadVisitor visitor = VariableValidateLoadVisitor.create(symbols, scope, this);
        this.setFirstSObjectTypeInfo(this.dottedExpression.getType());
        for (int i = 0; i < this.variables.size(); ++i) {
            VariableVisitor.Context context = new VariableVisitor.Context(this.names.get((int)i).loc);
            builder.add(context);
            Variable variable = this.variables.get(i);
            context.emitLast = this.reference != ReferenceType.STORE;
            context.previous = this.previousContext;
            context.isLast = i + 1 == this.variables.size() && this.reference == ReferenceType.METHOD;
            this.setFirstSObjectTypeInfo(variable.getType());
            context.firstSObjectTypeInfo = this.firstSObjectTypeInfo;
            if (!variable.accept(visitor, context).booleanValue()) break;
            this.previousContext = IdentifierContext.OBJECT;
        }
        this.contexts = builder.build();
        this.setType(type);
    }

    @Override
    public void emit(Emitter emitter) {
        boolean emitThrowNpe;
        this.dottedExpression.emit(emitter);
        int index = 0;
        if (!this.dottedExpression.isNoop() && this.dottedExpression.getType().getBasicType() == BasicType.SOBJECT) {
            emitThrowNpe = true;
        } else if (!this.variables.isEmpty() && this.dottedExpression.isNoop() && this.variables.get(0).getType().getBasicType() == BasicType.SOBJECT) {
            this.emitVariable(emitter, index++);
            emitThrowNpe = true;
        } else {
            emitThrowNpe = false;
        }
        if (this.reference != ReferenceType.STORE && emitThrowNpe && (this.variables.size() > index || this.reference == ReferenceType.LOAD)) {
            this.emitThrowNpe(emitter);
        }
        while (index < this.variables.size()) {
            this.emitVariable(emitter, index);
            ++index;
        }
    }

    @Override
    public Loc getLoc() {
        return Location.from(this.names.get((int)0).loc, this.names.get((int)(this.names.size() - 1)).loc);
    }

    private void emitThrowNpe(Emitter emitter) {
        emitter.emit(this.expression.getLoc(), 89);
        Label branch = new Label();
        emitter.emitJump(this.expression.getLoc(), 199, branch);
        emitter.emit(this.expression.getLoc(), SystemMethods.throwNPE());
        emitter.emit(branch);
    }

    private void emitVariable(Emitter emitter, int index) {
        VariableVisitor.Context context = this.contexts.get(index);
        Variable variable = this.variables.get(index);
        variable.accept(emitter.getVariableVisitor(), context);
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    public List<VariableVisitor.Context> getContexts() {
        return this.contexts;
    }

    public IdentifierContext getContext() {
        return this.previousContext;
    }

    public DottedExpression getDottedExpression() {
        return this.dottedExpression;
    }

    public TypeInfo getFirstSObjectTypeInfo() {
        return this.firstSObjectTypeInfo;
    }

    private void setFirstSObjectTypeInfo(TypeInfo type) {
        if (this.firstSObjectTypeInfo == null && type.getBasicType() == BasicType.SOBJECT) {
            this.firstSObjectTypeInfo = type;
        }
    }

    public ReferenceType getReferenceType() {
        return this.reference;
    }

    public List<Identifier> getJadtIdentifiers() {
        return this.names;
    }
}

