/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.PostfixOp;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodeFactory;
import apex.jorje.semantic.ast.TypeConversion;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.DecimalMethods;
import apex.jorje.semantic.common.util.VersionUtil;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Location;
import apex.jorje.services.Version;

public class PostfixExpression
extends Expression {
    private final PostfixOp op;
    private final Loc loc;
    private final Expression expression;
    private final Expression store;

    public PostfixExpression(AstNode definingNode, Expr.PostfixExpr expr) {
        super(definingNode);
        this.op = expr.op;
        this.loc = Location.from(expr);
        this.expression = AstNodeFactory.create((AstNode)this, expr.expr);
        this.store = AstNodeFactory.createStore(this, expr.expr);
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.expression.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        boolean isSpecialAssignment;
        this.expression.getOptions().isSpecialAssignment = isSpecialAssignment = Version.V192.isLessThanOrEqual(VersionUtil.get(this));
        this.store.getOptions().isSpecialAssignment = isSpecialAssignment;
        this.expression.validate(symbols, scope);
        if (scope.getErrors().isInvalid((AstNode)this.expression)) {
            scope.getErrors().markInvalid(this);
            return;
        }
        this.store.validate(symbols, scope);
        if (scope.getErrors().isInvalid((AstNode)this.store)) {
            scope.getErrors().markInvalid(this);
            return;
        }
        this.setType(this.expression.getType());
        if (!this.getType().getBasicType().isNumber()) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.numeric.postfix.operand", this.getType()));
        }
    }

    @Override
    public void emit(final Emitter emitter) {
        this.expression.emit(emitter);
        this.op._switch(new PostfixOp.SwitchBlock(){

            @Override
            public void _case(PostfixOp.PostfixInc x) {
                switch (PostfixExpression.this.getType().getBasicType()) {
                    case DECIMAL: {
                        PostfixExpression.this.swap(PostfixExpression.this.loc, emitter);
                        emitter.emit(PostfixExpression.this.loc, 4);
                        emitter.box(TypeInfos.INTEGER);
                        TypeConversion.emit(PostfixExpression.this.loc, emitter, TypeInfos.INTEGER, PostfixExpression.this.getType());
                        emitter.emit(PostfixExpression.this.loc, DecimalMethods.add());
                        break;
                    }
                    case DOUBLE: {
                        PostfixExpression.this.swap(PostfixExpression.this.loc, emitter);
                        emitter.unbox(PostfixExpression.this.getType());
                        emitter.emit(PostfixExpression.this.loc, 15);
                        emitter.emit(PostfixExpression.this.loc, 99);
                        emitter.box(PostfixExpression.this.getType());
                        break;
                    }
                    case LONG: {
                        PostfixExpression.this.swap(PostfixExpression.this.loc, emitter);
                        emitter.unbox(PostfixExpression.this.getType());
                        emitter.emit(PostfixExpression.this.loc, 10);
                        emitter.emit(PostfixExpression.this.loc, 97);
                        emitter.box(PostfixExpression.this.getType());
                        break;
                    }
                    case INTEGER: {
                        PostfixExpression.this.swap(PostfixExpression.this.loc, emitter);
                        emitter.unbox(PostfixExpression.this.getType());
                        emitter.emit(PostfixExpression.this.loc, 4);
                        emitter.emit(PostfixExpression.this.loc, 96);
                        emitter.box(PostfixExpression.this.getType());
                        break;
                    }
                    default: {
                        throw new UnexpectedCodePathException();
                    }
                }
            }

            @Override
            public void _case(PostfixOp.PostfixDec x) {
                switch (PostfixExpression.this.getType().getBasicType()) {
                    case DECIMAL: {
                        PostfixExpression.this.swap(PostfixExpression.this.loc, emitter);
                        emitter.emit(PostfixExpression.this.loc, 4);
                        emitter.box(TypeInfos.INTEGER);
                        TypeConversion.emit(PostfixExpression.this.loc, emitter, TypeInfos.INTEGER, PostfixExpression.this.getType());
                        emitter.emit(PostfixExpression.this.loc, DecimalMethods.subtract());
                        break;
                    }
                    case DOUBLE: {
                        PostfixExpression.this.swap(PostfixExpression.this.loc, emitter);
                        emitter.unbox(PostfixExpression.this.getType());
                        emitter.emit(PostfixExpression.this.loc, 15);
                        emitter.emit(PostfixExpression.this.loc, 103);
                        emitter.box(PostfixExpression.this.getType());
                        break;
                    }
                    case LONG: {
                        PostfixExpression.this.swap(PostfixExpression.this.loc, emitter);
                        emitter.unbox(PostfixExpression.this.getType());
                        emitter.emit(PostfixExpression.this.loc, 10);
                        emitter.emit(PostfixExpression.this.loc, 101);
                        emitter.box(PostfixExpression.this.getType());
                        break;
                    }
                    case INTEGER: {
                        PostfixExpression.this.swap(PostfixExpression.this.loc, emitter);
                        emitter.unbox(PostfixExpression.this.getType());
                        emitter.emit(PostfixExpression.this.loc, 4);
                        emitter.emit(PostfixExpression.this.loc, 100);
                        emitter.box(PostfixExpression.this.getType());
                        break;
                    }
                    default: {
                        throw new UnexpectedCodePathException();
                    }
                }
            }
        });
        this.store.emit(emitter);
    }

    @Override
    public Loc getLoc() {
        return this.loc;
    }

    public PostfixOp getOp() {
        return this.op;
    }

    private void swap(Loc loc, Emitter emitter) {
        if (!this.isTopLevel()) {
            emitter.emit(loc, 89);
            emitter.emit(loc, 95);
        }
    }
}

