/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.VersionRef;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.SystemMethods;
import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.compiler.StructuredVersion;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.services.I18nSupport;

public class PackageVersionExpression
extends Expression {
    private final Loc loc;
    private final VersionRef version;
    private Namespace namespace;

    public PackageVersionExpression(AstNode definingNode, Expr.PackageVersionExpr x) {
        super(definingNode);
        this.loc = x.loc;
        this.version = x.version;
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        visitor.visit(this, scope);
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(final SymbolResolver symbols, final ValidationScope scope) {
        this.namespace = this.getDefiningType().getNamespace();
        if (Namespace.isEmptyOrNull(this.namespace)) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("package.version.requires.namespace"));
            return;
        }
        this.version._switch(new VersionRef.SwitchBlock(){

            @Override
            public void _case(VersionRef.StructuredVersion x) {
                if (!symbols.getAccessEvaluator().isValidPackageVersion(PackageVersionExpression.this.getDefiningType().getNamespace(), new StructuredVersion(x.major, x.minor))) {
                    scope.getErrors().markInvalid((AstNode)PackageVersionExpression.this, I18nSupport.getLabel("package.version.invalid", x.major + "." + x.minor));
                }
            }

            @Override
            public void _case(VersionRef.RequestVersion x) {
                if (!"Request".equalsIgnoreCase(x.request.value)) {
                    scope.getErrors().markInvalid((AstNode)PackageVersionExpression.this, I18nSupport.getLabel("unexpected.token", x.request.value));
                }
            }
        });
        TypeInfo type = symbols.lookupTypeInfo(this.getDefiningType(), InternalTypeInfos.PACKAGE_VERSION);
        this.setType(type);
    }

    @Override
    public void emit(final Emitter emitter) {
        this.version._switch(new VersionRef.SwitchBlock(){

            @Override
            public void _case(VersionRef.StructuredVersion x) {
                emitter.push(PackageVersionExpression.this.loc, PackageVersionExpression.this.namespace.toString());
                emitter.push(PackageVersionExpression.this.loc, x.major + "." + x.minor);
                emitter.emit(PackageVersionExpression.this.loc, SystemMethods.getApexVersion());
            }

            @Override
            public void _case(VersionRef.RequestVersion x) {
                emitter.emit(PackageVersionExpression.this.loc, SystemMethods.requestVersionBytecode());
            }
        });
    }

    @Override
    public Loc getLoc() {
        return this.loc;
    }
}

