/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.ObjectCreator;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodeFactory;
import apex.jorje.semantic.ast.TypeConversion;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.CollectionExpressionUtils;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.ObjectMethods;
import apex.jorje.semantic.bcl.SetMethods;
import apex.jorje.semantic.symbol.resolver.Distance;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.GenericTypeInfoFactory;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.Lists;
import java.util.List;

public class NewSetLiteralExpression
extends Expression {
    private final Loc loc;
    private final List<TypeRef> types;
    private final List<Expression> elements;
    private GenericTypeInfo type;

    public NewSetLiteralExpression(AstNode definingNode, Expr.NewExpr expr, ObjectCreator.SetLiteralCreator x) {
        super(definingNode);
        this.loc = expr.loc;
        this.types = x.types;
        this.elements = AstNodeFactory.createExpressions(this, x.values);
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            for (Expression element : this.elements) {
                element.traverse(visitor, scope);
            }
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        if (this.types.size() != 1) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.parameterized.type.count", "Set", 1, this.types.size()));
            return;
        }
        TypeInfo elementType = symbols.lookupTypeInfo(this.getDefiningType(), this.types.get(0));
        if (!CollectionExpressionUtils.validateCollection(this.getDefiningType(), Lists.newArrayList(elementType), scope, this)) {
            return;
        }
        for (Expression element : this.elements) {
            element.validate(symbols, scope);
            if (scope.getErrors().isInvalid((AstNode)element)) {
                scope.getErrors().markInvalid(this);
                continue;
            }
            if (Distance.get().canAssign(this.getDefiningType(), element.getType(), elementType)) continue;
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.set.initial.expression.type", elementType, element.getType()));
        }
        this.type = GenericTypeInfoFactory.createSet(elementType);
        this.setType(this.type);
    }

    @Override
    public void emit(Emitter emitter) {
        emitter.emitType(this.loc, 187, this.type);
        emitter.emit(this.loc, 89);
        emitter.push(this.loc, this.elements.size());
        emitter.box(TypeInfos.INTEGER);
        emitter.emit(this.loc, ObjectMethods.constructor(this.type, TypeInfos.INTEGER));
        for (Expression element : this.elements) {
            emitter.emit(this.loc, 89);
            element.emit(emitter);
            TypeConversion.emit(this.loc, emitter, element.getType(), CollectionTypeInfoUtil.getElementType(this.type));
            emitter.emit(this.loc, SetMethods.add(this.type));
            emitter.emit(this.loc, 87);
        }
    }

    @Override
    public Loc getLoc() {
        return this.loc;
    }
}

