/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.ObjectCreator;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodeFactory;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.CollectionExpressionUtils;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.AsmMethod;
import apex.jorje.semantic.bcl.ObjectMethods;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.GenericTypeInfoFactory;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.Lists;
import java.util.List;

public class NewSetInitExpression
extends Expression {
    private final Loc loc;
    private final List<TypeRef> types;
    private final Expression init;
    private TypeInfo type;

    public NewSetInitExpression(AstNode definingNode, Expr.NewExpr expr, ObjectCreator.SetInitCreator x) {
        super(definingNode);
        this.loc = expr.loc;
        this.types = x.types;
        this.init = x.expr.map(value -> AstNodeFactory.create((AstNode)this, value)).orElse(NOOP);
    }

    static boolean isValidInit(TypeInfo initType, TypeInfo elementType) {
        return TypeInfoEquivalence.isEquivalent(initType, GenericTypeInfoFactory.createList(elementType)) || TypeInfoEquivalence.isEquivalent(initType, GenericTypeInfoFactory.createSet(elementType));
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.init.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        this.init.validate(symbols, scope);
        if (scope.getErrors().isInvalid((AstNode)this.init)) {
            scope.getErrors().markInvalid(this);
            return;
        }
        if (this.types.size() != 1) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.parameterized.type.count", "Set", 1, this.types.size()));
            return;
        }
        TypeInfo elementType = symbols.lookupTypeInfo(this.getDefiningType(), this.types.get(0));
        if (!CollectionExpressionUtils.validateCollection(this.getDefiningType(), Lists.newArrayList(elementType), scope, this)) {
            return;
        }
        if (this.init != Expression.NOOP && !NewSetInitExpression.isValidInit(this.init.getType(), elementType)) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.set.initializer", this.init.getType(), elementType));
            return;
        }
        this.type = GenericTypeInfoFactory.createSet(elementType);
        this.setType(this.type);
    }

    @Override
    public void emit(Emitter emitter) {
        AsmMethod constructor;
        emitter.emitType(this.loc, 187, this.type);
        emitter.emit(this.loc, 89);
        this.init.emit(emitter);
        if (this.init == Expression.NOOP) {
            emitter.push(this.loc, 0);
            emitter.box(TypeInfos.INTEGER);
            constructor = ObjectMethods.constructor(this.type, TypeInfos.INTEGER);
        } else {
            constructor = ObjectMethods.constructor(this.type, TypeInfos.OBJECT);
        }
        emitter.emit(this.loc, constructor);
        if (this.isTopLevel()) {
            emitter.emit(this.loc, 87);
        }
    }

    @Override
    public Loc getLoc() {
        return this.loc;
    }
}

