/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.Identifier;
import apex.jorje.data.ast.ObjectCreator;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodeFactory;
import apex.jorje.semantic.ast.TypeConversion;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.MapMethods;
import apex.jorje.semantic.bcl.ObjectMethods;
import apex.jorje.semantic.bcl.SObjectMethods;
import apex.jorje.semantic.common.iterable.CaseInsensitiveSet;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.member.variable.SObjectFieldInfo;
import apex.jorje.semantic.symbol.member.variable.VariableValidateStoreVisitor;
import apex.jorje.semantic.symbol.member.variable.VariableVisitor;
import apex.jorje.semantic.symbol.resolver.Distance;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.ReifiedTypeInfos;
import apex.jorje.semantic.symbol.type.SObjectTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.UnresolvedErrorCalculator;
import apex.jorje.semantic.symbol.type.VfComponentTypeInfo;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.SObjectTypeInfoUtil;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class NewNameValueObjectExpression
extends Expression {
    private final Loc loc;
    private final TypeRef typeRef;
    private final List<NameValueParameter> parameters;

    public NewNameValueObjectExpression(AstNode definingNode, Expr.NewExpr expr, ObjectCreator.NameValueCreator x) {
        super(definingNode);
        this.loc = expr.loc;
        this.typeRef = x.type;
        ImmutableList.Builder builder = ImmutableList.builder();
        for (apex.jorje.data.ast.NameValueParameter parameter : x.keyValues.values) {
            Expression expression = AstNodeFactory.create((AstNode)this, parameter.value);
            builder.add(new NameValueParameter(parameter.name, expression));
        }
        this.parameters = builder.build();
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            for (NameValueParameter parameter : this.parameters) {
                parameter.expression.traverse(visitor, scope);
            }
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        TypeInfo type = symbols.lookupTypeInfo(this.getDefiningType(), this.typeRef);
        if (!type.isResolved()) {
            scope.getErrors().markInvalid((AstNode)this, UnresolvedErrorCalculator.getErrors(type));
            return;
        }
        type.accept(new Validator(symbols, scope, this));
        this.setType(type);
    }

    @Override
    public void emit(final Emitter emitter) {
        this.getType().accept(new TypeInfoVisitor.Default<Void>(){

            @Override
            protected Void _default(TypeInfo type) {
                emitter.emitType(NewNameValueObjectExpression.this.loc, 187, type);
                emitter.emit(NewNameValueObjectExpression.this.loc, 89);
                emitter.emitType(NewNameValueObjectExpression.this.loc, 187, ReifiedTypeInfos.STRING_TO_OBJECT_MAP);
                emitter.emit(NewNameValueObjectExpression.this.loc, 89);
                emitter.emit(NewNameValueObjectExpression.this.loc, ObjectMethods.constructor(ReifiedTypeInfos.STRING_TO_OBJECT_MAP, new TypeInfo[0]));
                for (NameValueParameter parameter : NewNameValueObjectExpression.this.parameters) {
                    emitter.emit(NewNameValueObjectExpression.this.loc, 89);
                    emitter.push(NewNameValueObjectExpression.this.loc, parameter.name.value);
                    parameter.expression.emit(emitter);
                    emitter.emit(NewNameValueObjectExpression.this.loc, MapMethods.put(ReifiedTypeInfos.STRING_TO_OBJECT_MAP));
                    emitter.emit(NewNameValueObjectExpression.this.loc, 87);
                }
                emitter.emit(NewNameValueObjectExpression.this.loc, ObjectMethods.constructor(type, ReifiedTypeInfos.STRING_TO_OBJECT_MAP));
                return null;
            }

            @Override
            public Void visit(SObjectTypeInfo type) {
                emitter.emitType(NewNameValueObjectExpression.this.loc, 187, type);
                emitter.emit(NewNameValueObjectExpression.this.loc, 89);
                emitter.emit(NewNameValueObjectExpression.this.loc, ObjectMethods.constructor(type, new TypeInfo[0]));
                for (NameValueParameter parameter : NewNameValueObjectExpression.this.parameters) {
                    emitter.emit(NewNameValueObjectExpression.this.loc, 89);
                    parameter.expression.emit(emitter);
                    TypeConversion.emit(NewNameValueObjectExpression.this.loc, emitter, parameter.expression.getType(), parameter.fieldInfo.getType());
                    emitter.push(NewNameValueObjectExpression.this.loc, parameter.fieldInfo.getBytecodeName());
                    emitter.emit(NewNameValueObjectExpression.this.loc, SObjectTypeInfoUtil.getMethodsForEmit(type).setValueMethod());
                }
                emitter.emit(NewNameValueObjectExpression.this.loc, 89);
                emitter.emit(NewNameValueObjectExpression.this.loc, SObjectMethods.initializationCompleted(type));
                return null;
            }
        });
        if (this.isTopLevel()) {
            emitter.emit(this.loc, 87);
        }
    }

    @Override
    public Loc getLoc() {
        return this.loc;
    }

    public List<NameValueParameter> getParameters() {
        return this.parameters;
    }

    private class Validator
    extends TypeInfoVisitor.Default<Void> {
        private final SymbolResolver symbols;
        private final ValidationScope scope;
        private final AstNode node;

        private Validator(SymbolResolver symbols, ValidationScope scope, AstNode node) {
            this.symbols = symbols;
            this.scope = scope;
            this.node = node;
        }

        @Override
        protected Void _default(TypeInfo type) {
            this.scope.getErrors().markInvalid(this.node, I18nSupport.getLabel("invalid.name.value.pair.constructor", type));
            return null;
        }

        @Override
        public Void visit(VfComponentTypeInfo type) {
            CaseInsensitiveSet duplicateParameters = new CaseInsensitiveSet();
            for (NameValueParameter parameter : NewNameValueObjectExpression.this.parameters) {
                FieldInfo field = type.fields().get(this.symbols, NewNameValueObjectExpression.this.getDefiningType(), parameter.name.value, false);
                if (field == null) {
                    this.scope.getErrors().markInvalid(this.node, I18nSupport.getLabel("field.does.not.exist", parameter.name.value, type));
                    continue;
                }
                if (!duplicateParameters.add(field.getName())) {
                    this.scope.getErrors().markInvalid(this.node, I18nSupport.getLabel("duplicate.field.init", field.getName()));
                }
                parameter.expression.validate(this.symbols, this.scope);
                if (!this.scope.getErrors().isInvalid((AstNode)parameter.expression)) continue;
                this.scope.getErrors().markInvalid(this.node);
            }
            return null;
        }

        @Override
        public Void visit(SObjectTypeInfo type) {
            VariableValidateStoreVisitor visitor = VariableValidateStoreVisitor.create(this.symbols, this.scope, this.node);
            VariableVisitor.Context context = new VariableVisitor.Context(NewNameValueObjectExpression.this.loc);
            context.isSObjectConstruction = true;
            for (NameValueParameter parameter : NewNameValueObjectExpression.this.parameters) {
                parameter.fieldInfo = (SObjectFieldInfo)type.fields().get(this.symbols, NewNameValueObjectExpression.this.getDefiningType(), parameter.name.value, false);
                if (parameter.fieldInfo == null) {
                    this.scope.getErrors().markInvalid(this.node, I18nSupport.getLabel("field.does.not.exist", parameter.name.value, type));
                    continue;
                }
                context.hasSObjectPrimaryKeyInit |= parameter.fieldInfo.isPrimaryKey();
            }
            HashSet<String> duplicateParameters = new HashSet<String>();
            for (NameValueParameter parameter : NewNameValueObjectExpression.this.parameters.stream().filter(p -> p.fieldInfo != null).collect(Collectors.toList())) {
                TypeInfo expressionType;
                if (!duplicateParameters.add(parameter.fieldInfo.getName())) {
                    this.scope.getErrors().markInvalid(this.node, I18nSupport.getLabel("duplicate.field.init", parameter.fieldInfo.getName()));
                    continue;
                }
                parameter.context = context;
                if (!parameter.fieldInfo.accept(visitor, parameter.context).booleanValue()) continue;
                parameter.expression.validate(this.symbols, this.scope);
                if (this.scope.getErrors().isInvalid((AstNode)parameter.expression)) {
                    this.scope.getErrors().markInvalid(this.node);
                    continue;
                }
                TypeInfo typeInfo = expressionType = parameter.fieldInfo.getCategory() == SObjectFieldInfo.Category.FOREIGN_KEY && SObjectTypeInfoUtil.isConcreteSObjectList(parameter.expression.getType()) ? CollectionTypeInfoUtil.getElementType(parameter.expression.getType()) : parameter.expression.getType();
                assert (parameter.fieldInfo.getCategory() != SObjectFieldInfo.Category.AGGREGATE) : "cannot use aggregate path for new sobject";
                if (Distance.get().canAssign(NewNameValueObjectExpression.this.getDefiningType(), expressionType, parameter.fieldInfo.getType())) continue;
                this.scope.getErrors().markInvalid(this.node, I18nSupport.getLabel("illegal.assignment", expressionType, parameter.fieldInfo.getType()));
            }
            return null;
        }
    }

    public static class NameValueParameter {
        final Identifier name;
        final Expression expression;
        SObjectFieldInfo fieldInfo;
        VariableVisitor.Context context;

        NameValueParameter(Identifier name, Expression expression) {
            this.name = name;
            this.expression = expression;
        }

        public SObjectFieldInfo getFieldInfo() {
            return this.fieldInfo;
        }
    }
}

