/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.semantic.ast.TypeConversion;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.MethodCallExpression;
import apex.jorje.semantic.ast.expression.MethodCallInterceptor;
import apex.jorje.semantic.ast.expression.ReferenceExpression;
import apex.jorje.semantic.ast.expression.SoqlExpression;
import apex.jorje.semantic.ast.member.Parameter;
import apex.jorje.semantic.ast.modifier.AnnotationParameter;
import apex.jorje.semantic.bcl.DatabaseMethods;
import apex.jorje.semantic.bcl.ExceptionMethods;
import apex.jorje.semantic.bcl.ListMethods;
import apex.jorje.semantic.bcl.ObjectMethods;
import apex.jorje.semantic.bcl.SObjectMethods;
import apex.jorje.semantic.bcl.SystemMethods;
import apex.jorje.semantic.common.iterator.EqualPairIterator;
import apex.jorje.semantic.common.iterator.Pair;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.variable.VariableVisitor;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.ReifiedTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.common.ExceptionTypeInfoUtil;
import java.util.List;

interface MethodCallInterceptors {

    public static class IsFuture
    implements MethodCallInterceptor {
        private void emitParameterValues(MethodCallExpression methodCall, Emitter emitter) {
            MethodInfo method = methodCall.getMethod();
            emitter.emitType(methodCall.getLoc(), 187, ReifiedTypeInfos.OBJECT_LIST);
            emitter.emit(methodCall.getLoc(), 89);
            emitter.emit(methodCall.getLoc(), ObjectMethods.constructor(ReifiedTypeInfos.OBJECT_LIST, new TypeInfo[0]));
            for (Pair<Expression, TypeInfo> pair : EqualPairIterator.iterable(methodCall.getInputParameters(), method.getEmitSignature().getParameterTypes())) {
                emitter.emit(methodCall.getLoc(), 89);
                ((Expression)pair.left).emit(emitter);
                TypeConversion.emit(methodCall.getLoc(), emitter, ((Expression)pair.left).getType(), (TypeInfo)pair.right);
                emitter.emit(methodCall.getLoc(), ListMethods.addNoReturn(ReifiedTypeInfos.OBJECT_LIST));
            }
        }

        private void emitParameterTypes(MethodCallExpression methodCall, Emitter emitter) {
            MethodInfo method = methodCall.getMethod();
            emitter.emitType(methodCall.getLoc(), 187, ReifiedTypeInfos.OBJECT_LIST);
            emitter.emit(methodCall.getLoc(), 89);
            emitter.emit(methodCall.getLoc(), ObjectMethods.constructor(ReifiedTypeInfos.OBJECT_LIST, new TypeInfo[0]));
            for (Parameter parameter : method.getParameters()) {
                emitter.emit(methodCall.getLoc(), 89);
                emitter.push(methodCall.getLoc(), parameter.getType().getApexName());
                emitter.emit(methodCall.getLoc(), ListMethods.addNoReturn(ReifiedTypeInfos.OBJECT_LIST));
            }
        }

        @Override
        public boolean shouldIntercept(MethodCallExpression methodCall) {
            MethodInfo method = methodCall.getMethod();
            return method.getModifiers().has(AnnotationTypeInfos.FUTURE);
        }

        @Override
        public void intercept(MethodCallExpression methodCall, Emitter emitter) {
            MethodInfo method = methodCall.getMethod();
            emitter.push(methodCall.getLoc(), method.getDefiningType().getBytecodeName());
            emitter.push(methodCall.getLoc(), method.getName());
            AnnotationParameter limit = method.getModifiers().get(AnnotationTypeInfos.FUTURE).getParameter("limits");
            emitter.push(methodCall.getLoc(), limit == null ? null : limit.getStringValue());
            AnnotationParameter delay = method.getModifiers().get(AnnotationTypeInfos.FUTURE).getParameter("delay");
            emitter.push(methodCall.getLoc(), delay == null ? 0 : delay.getIntegerValue());
            emitter.box(TypeInfos.INTEGER);
            this.emitParameterValues(methodCall, emitter);
            this.emitParameterTypes(methodCall, emitter);
            emitter.emit(methodCall.getLoc(), SystemMethods.scheduleFuture());
        }
    }

    public static class GetQueryLocator
    implements MethodCallInterceptor {
        @Override
        public boolean shouldIntercept(MethodCallExpression methodCall) {
            MethodInfo method = methodCall.getMethod();
            return method.getName().equals("getQueryLocator") && method.getParameters().size() == 1 && TypeInfoEquivalence.isEquivalent(method.getDefiningType(), InternalTypeInfos.DATABASE) && methodCall.getInputParameters().get(0) instanceof SoqlExpression;
        }

        @Override
        public void intercept(MethodCallExpression methodCall, Emitter emitter) {
            List<Expression> inputParameters = methodCall.getInputParameters();
            MethodInfo method = methodCall.getMethod();
            SoqlExpression soqlExpression = (SoqlExpression)inputParameters.get(0);
            methodCall.emitReferenceExpression(emitter);
            soqlExpression.getBindExpression().emit(emitter);
            method.getProfilingType().emit(emitter, methodCall);
            emitter.emit(methodCall.getLoc(), DatabaseMethods.getQueryLocatorWithStringMap());
            methodCall.finishCall(emitter);
        }
    }

    public static class AddError
    implements MethodCallInterceptor {
        @Override
        public boolean shouldIntercept(MethodCallExpression methodCall) {
            MethodInfo method = methodCall.getMethod();
            return method.getGenerated() == Generated.BUILT_IN && method.getName().equals("addError");
        }

        @Override
        public void intercept(MethodCallExpression methodCall, Emitter emitter) {
            ReferenceExpression reference = methodCall.getReferenceExpression();
            for (VariableVisitor.Context context : reference.getContexts()) {
                context.emitLast = false;
            }
            methodCall.emitReferenceExpression(emitter);
            if (reference.getVariables().isEmpty() || reference.getDottedExpression().isNoop() && reference.getVariables().size() == 1) {
                emitter.emit(methodCall.getLoc(), 1);
            }
            List<Expression> inputParameters = methodCall.getInputParameters();
            inputParameters.get(0).emit(emitter);
            if (ExceptionTypeInfoUtil.isException(emitter.getVersion(), inputParameters.get(0).getType())) {
                emitter.emit(methodCall.getLoc(), ExceptionMethods.getMessage());
            }
            if (inputParameters.size() == 2) {
                inputParameters.get(1).emit(emitter);
                emitter.emit(methodCall.getLoc(), SObjectMethods.addErrorTwo());
            } else {
                emitter.emit(methodCall.getLoc(), SObjectMethods.addErrorOne());
            }
            methodCall.finishCall(emitter);
        }
    }
}

