/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.JadtTester;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.Literal;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodeFactory;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.LiteralExpression;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.tester.TestNode;
import apex.jorje.semantic.tester.matchers.IsType;
import java.math.BigDecimal;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.Test;

public class LiteralExpressionTest {
    private static final SymbolResolver SYMBOLS = null;
    private static final AstNode NODE = TestNode.create(null);
    private static final Expr.LiteralExpr DECIMAL = new Expr.LiteralExpr(Literal._DecimalLiteral(JadtTester.NO_LOC, new BigDecimal("17.29")));
    private static final Expr.LiteralExpr DOUBLE = new Expr.LiteralExpr(Literal._DoubleLiteral(JadtTester.NO_LOC, 1.729));
    private static final Expr.LiteralExpr INTEGER = new Expr.LiteralExpr(Literal._IntegerLiteral(JadtTester.NO_LOC, 1729));
    private static final Expr.LiteralExpr LONG = new Expr.LiteralExpr(Literal._LongLiteral(JadtTester.NO_LOC, 1729L));
    private static final Expr.LiteralExpr TRUE = new Expr.LiteralExpr(Literal._TrueLiteral(JadtTester.NO_LOC));
    private static final Expr.LiteralExpr FALSE = new Expr.LiteralExpr(Literal._FalseLiteral(JadtTester.NO_LOC));
    private static final Expr.LiteralExpr STRING = new Expr.LiteralExpr(Literal._StringLiteral(JadtTester.NO_LOC, "1729"));
    private static final Expr.LiteralExpr NULL = new Expr.LiteralExpr(Literal._NullLiteral(JadtTester.NO_LOC));

    private static Expression createAndValidate(Expr expr) {
        Expression node = AstNodeFactory.create(NODE, expr);
        node.validate(SYMBOLS, null);
        return node;
    }

    private static Object getLiteral(Expr.LiteralExpr expr) {
        return LiteralExpression.getLiteral(expr.literal);
    }

    @Test
    public void testType() {
        MatcherAssert.assertThat((Object)LiteralExpressionTest.createAndValidate(DECIMAL).getType(), IsType.isType(TypeInfos.DECIMAL));
        MatcherAssert.assertThat((Object)LiteralExpressionTest.createAndValidate(DOUBLE).getType(), IsType.isType(TypeInfos.DOUBLE));
        MatcherAssert.assertThat((Object)LiteralExpressionTest.createAndValidate(INTEGER).getType(), IsType.isType(TypeInfos.INTEGER));
        MatcherAssert.assertThat((Object)LiteralExpressionTest.createAndValidate(LONG).getType(), IsType.isType(TypeInfos.LONG));
        MatcherAssert.assertThat((Object)LiteralExpressionTest.createAndValidate(TRUE).getType(), IsType.isType(TypeInfos.BOOLEAN));
        MatcherAssert.assertThat((Object)LiteralExpressionTest.createAndValidate(FALSE).getType(), IsType.isType(TypeInfos.BOOLEAN));
        MatcherAssert.assertThat((Object)LiteralExpressionTest.createAndValidate(STRING).getType(), IsType.isType(TypeInfos.STRING));
        MatcherAssert.assertThat((Object)LiteralExpressionTest.createAndValidate(NULL).getType(), IsType.isType(InternalTypeInfos.NULL));
    }

    @Test
    public void testNullable() {
        MatcherAssert.assertThat((Object)AstNodeFactory.create(NODE, DECIMAL).isNullable(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)AstNodeFactory.create(NODE, DOUBLE).isNullable(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)AstNodeFactory.create(NODE, INTEGER).isNullable(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)AstNodeFactory.create(NODE, LONG).isNullable(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)AstNodeFactory.create(NODE, TRUE).isNullable(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)AstNodeFactory.create(NODE, FALSE).isNullable(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)AstNodeFactory.create(NODE, STRING).isNullable(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)AstNodeFactory.create(NODE, NULL).isNullable(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testLiteral() {
        MatcherAssert.assertThat((Object)LiteralExpressionTest.getLiteral(DECIMAL), (Matcher)Matchers.is((Object)new BigDecimal("17.29")));
        MatcherAssert.assertThat((Object)LiteralExpressionTest.getLiteral(DOUBLE), (Matcher)Matchers.is((Object)1.729));
        MatcherAssert.assertThat((Object)LiteralExpressionTest.getLiteral(INTEGER), (Matcher)Matchers.is((Object)1729));
        MatcherAssert.assertThat((Object)LiteralExpressionTest.getLiteral(LONG), (Matcher)Matchers.is((Object)1729L));
        MatcherAssert.assertThat((Object)LiteralExpressionTest.getLiteral(TRUE), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)LiteralExpressionTest.getLiteral(FALSE), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)LiteralExpressionTest.getLiteral(STRING), (Matcher)Matchers.is((Object)"1729"));
        MatcherAssert.assertThat((Object)LiteralExpressionTest.getLiteral(NULL), (Matcher)Matchers.is(null));
    }
}

