/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.semantic.ast.expression.ArrayStoreExpression;
import apex.jorje.semantic.ast.expression.BinaryExpression;
import apex.jorje.semantic.ast.expression.BooleanExpression;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.LiteralExpression;
import apex.jorje.semantic.ast.expression.MethodCallExpression;
import apex.jorje.semantic.ast.expression.ReferenceType;
import apex.jorje.semantic.ast.expression.SoqlExpression;
import apex.jorje.semantic.ast.expression.SuperVariableExpression;
import apex.jorje.semantic.ast.expression.VariableExpression;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.ValueScope;
import apex.jorje.semantic.exception.UnexpectedCodePathException;

public class ExpressionUtil {
    private ExpressionUtil() {
    }

    static BooleanExpression getBooleanExpression(Expression expression) {
        BooleanExpression concreteExpression = ValueScope.evaluate(expression, new AstVisitor<ValueScope<BooleanExpression>>(){

            @Override
            public void visitEnd(BooleanExpression node, ValueScope<BooleanExpression> scope) {
                scope.setValue(node);
            }
        }, null);
        if (concreteExpression == null) {
            throw new UnexpectedCodePathException();
        }
        return concreteExpression;
    }

    static BinaryExpression getBinaryExpression(Expression expression) {
        BinaryExpression concreteExpression = ValueScope.evaluate(expression, new AstVisitor<ValueScope<BinaryExpression>>(){

            @Override
            public void visitEnd(BinaryExpression node, ValueScope<BinaryExpression> scope) {
                scope.setValue(node);
            }
        }, null);
        if (concreteExpression == null) {
            throw new UnexpectedCodePathException();
        }
        return concreteExpression;
    }

    static LiteralExpression getLiteralExpression(Expression expression) {
        LiteralExpression concreteExpression = ValueScope.evaluate(expression, new AstVisitor<ValueScope<LiteralExpression>>(){

            @Override
            public void visitEnd(LiteralExpression node, ValueScope<LiteralExpression> scope) {
                scope.setValue(node);
            }
        }, null);
        if (concreteExpression == null) {
            throw new UnexpectedCodePathException();
        }
        return concreteExpression;
    }

    public static MethodCallExpression getMethodCallExpression(Expression expression) {
        MethodCallExpression concreteExpression = ValueScope.evaluate(expression, new AstVisitor<ValueScope<MethodCallExpression>>(){

            @Override
            public void visitEnd(MethodCallExpression node, ValueScope<MethodCallExpression> scope) {
                scope.setValue(node);
            }
        }, null);
        if (concreteExpression == null) {
            throw new UnexpectedCodePathException();
        }
        return concreteExpression;
    }

    public static SoqlExpression getSoqlExpression(Expression expression) {
        SoqlExpression concreteExpression = ValueScope.evaluate(expression, new AstVisitor<ValueScope<SoqlExpression>>(){

            @Override
            public void visitEnd(SoqlExpression node, ValueScope<SoqlExpression> scope) {
                scope.setValue(node);
            }
        }, null);
        if (concreteExpression == null) {
            throw new UnexpectedCodePathException();
        }
        return concreteExpression;
    }

    public static boolean isSuperVariableExpression(Expression expression) {
        return ValueScope.evaluate(expression, new AstVisitor<ValueScope<Boolean>>(){

            @Override
            public void visitEnd(SuperVariableExpression node, ValueScope<Boolean> scope) {
                scope.setValue(true);
            }
        }, false);
    }

    public static boolean isSoqlExpression(Expression expression) {
        return ValueScope.evaluate(expression, new AstVisitor<ValueScope<Boolean>>(){

            @Override
            public void visitEnd(SoqlExpression node, ValueScope<Boolean> scope) {
                scope.setValue(true);
            }
        }, false);
    }

    public static boolean isSoqlDottedExpression(Expression expression) {
        return ValueScope.evaluate(expression, new AstVisitor<ValueScope<Boolean>>(){

            @Override
            public void visitEnd(VariableExpression node, ValueScope<Boolean> scope) {
                if (node.getReferenceType() == ReferenceType.LOAD) {
                    scope.setValue(ExpressionUtil.isSoqlExpression(node.getReferenceExpression().getDottedExpression().getExpression()));
                }
            }
        }, false);
    }

    public static boolean isArrayStoreExpression(Expression expression) {
        return ValueScope.evaluate(expression, new AstVisitor<ValueScope<Boolean>>(){

            @Override
            public void visitEnd(ArrayStoreExpression node, ValueScope<Boolean> scope) {
                scope.setValue(true);
            }
        }, false);
    }

    public static boolean isLiteralExpression(Expression expression) {
        return ValueScope.evaluate(expression, new AstVisitor<ValueScope<Boolean>>(){

            @Override
            public void visitEnd(LiteralExpression node, ValueScope<Boolean> scope) {
                scope.setValue(true);
            }
        }, false);
    }
}

