/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.ast.BooleanOp;
import apex.jorje.semantic.ast.expression.BooleanOps;
import apex.jorje.semantic.ast.expression.Comparison;
import apex.jorje.semantic.bcl.DateMethods;
import apex.jorje.semantic.bcl.DateTimeMethods;
import apex.jorje.semantic.bcl.DecimalMethods;
import apex.jorje.semantic.bcl.SystemMethods;
import apex.jorje.semantic.bcl.TimeMethods;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.type.TypeInfo;

class ComparisonFactory {
    private ComparisonFactory() {
    }

    public static Comparison get(TypeInfo type, BooleanOp op) {
        BooleanOp negateOp = BooleanOps.get().negate(op);
        int unaryOpcode = BooleanOps.get().getUnaryOpcode(negateOp);
        switch (type.getBasicType()) {
            case BOOLEAN: 
            case INTEGER: {
                return BooleanOps.get().getIntegerComparison(negateOp);
            }
            case LONG: {
                return new Comparison.BinaryComparison(unaryOpcode, 148);
            }
            case DOUBLE: {
                return ComparisonFactory.getDoubleComparison(negateOp, unaryOpcode);
            }
            case DECIMAL: {
                return new Comparison.StaticComparison(unaryOpcode, DecimalMethods.compareTo());
            }
            case STRING: {
                return new Comparison.StaticComparison(unaryOpcode, SystemMethods.compareStrings());
            }
            case DATE: {
                return new Comparison.StaticComparison(unaryOpcode, DateMethods.compareTo());
            }
            case DATE_TIME: {
                return new Comparison.StaticComparison(unaryOpcode, DateTimeMethods.compareTo());
            }
            case TIME: {
                return new Comparison.StaticComparison(unaryOpcode, TimeMethods.compareTo());
            }
            case ID: {
                return new Comparison.IdComparison(op, unaryOpcode);
            }
        }
        return ComparisonFactory.getObjectComparison(op, BooleanOps.get().getUnaryOpcode(op));
    }

    private static Comparison getObjectComparison(BooleanOp op, final int unaryOpcode) {
        return op.match(new BooleanOp.MatchBlockWithDefault<Comparison>(){

            @Override
            public Comparison _case(BooleanOp.DoubleEqual x) {
                return new Comparison.StaticComparison(unaryOpcode, SystemMethods.compareObjects());
            }

            @Override
            public Comparison _case(BooleanOp.TripleEqual x) {
                return new Comparison.ReferenceComparison(166);
            }

            @Override
            public Comparison _case(BooleanOp.NotTripleEqual x) {
                return new Comparison.ReferenceComparison(165);
            }

            @Override
            public Comparison _case(BooleanOp.NotEqual x) {
                return new Comparison.StaticComparison(unaryOpcode, SystemMethods.compareObjects());
            }

            @Override
            public Comparison _case(BooleanOp.AltNotEqual x) {
                return new Comparison.StaticComparison(unaryOpcode, SystemMethods.compareObjects());
            }

            @Override
            protected Comparison _default(BooleanOp x) {
                throw new UnexpectedCodePathException();
            }
        });
    }

    private static Comparison getDoubleComparison(BooleanOp op, final int unaryOpcode) {
        return op.match(new BooleanOp.MatchBlockWithDefault<Comparison>(){

            @Override
            public Comparison _case(BooleanOp.DoubleEqual x) {
                return new Comparison.StaticComparison(154, SystemMethods.compareObjects());
            }

            @Override
            public Comparison _case(BooleanOp.NotEqual x) {
                return new Comparison.StaticComparison(153, SystemMethods.compareObjects());
            }

            @Override
            public Comparison _case(BooleanOp.LessThan x) {
                return new Comparison.BinaryComparison(unaryOpcode, 151);
            }

            @Override
            public Comparison _case(BooleanOp.GreaterThan x) {
                return new Comparison.BinaryComparison(unaryOpcode, 152);
            }

            @Override
            public Comparison _case(BooleanOp.LessThanEqual x) {
                return new Comparison.BinaryComparison(unaryOpcode, 151);
            }

            @Override
            public Comparison _case(BooleanOp.GreaterThanEqual x) {
                return new Comparison.BinaryComparison(unaryOpcode, 152);
            }

            @Override
            protected Comparison _default(BooleanOp x) {
                throw new UnexpectedCodePathException();
            }
        });
    }
}

