/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.UnresolvedErrorCalculator;
import apex.jorje.semantic.symbol.visibility.Visibility;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import com.google.common.collect.Lists;
import java.util.List;

class CollectionExpressionUtils {
    CollectionExpressionUtils() {
    }

    public static boolean validateCollection(TypeInfo referencingType, List<TypeInfo> typesToCheck, ValidationScope validationScope, AstNode nodeToAddErrorsTo) {
        List<String> unresolvedErrors = UnresolvedErrorCalculator.getErrors(typesToCheck);
        validationScope.getErrors().markInvalid(nodeToAddErrorsTo, unresolvedErrors);
        List<String> visibilityErrors = Visibility.calculateTypeVisibilityErrors(validationScope.getSymbols().getAccessEvaluator(), referencingType, typesToCheck, validationScope.isTestMethod());
        if (!visibilityErrors.isEmpty()) {
            validationScope.getErrors().markInvalid(nodeToAddErrorsTo, visibilityErrors);
            return false;
        }
        return true;
    }

    public static boolean validateMap(TypeInfo referencingType, TypeInfo keyType, TypeInfo valueType, ValidationScope validationScope, AstNode nodeToAddErrorsTo) {
        if (!CollectionExpressionUtils.validateCollection(referencingType, Lists.newArrayList(keyType, valueType), validationScope, nodeToAddErrorsTo)) {
            return false;
        }
        return CollectionExpressionUtils.validateTypeIsNotSObjectBeforeV164(valueType, referencingType, validationScope, nodeToAddErrorsTo, I18nSupport.getLabel("invalid.sobject.map"));
    }

    public static boolean validateList(TypeInfo referencingType, TypeInfo elementType, ValidationScope validationScope, AstNode nodeToAddErrorsTo) {
        if (!CollectionExpressionUtils.validateCollection(referencingType, Lists.newArrayList(elementType), validationScope, nodeToAddErrorsTo)) {
            return false;
        }
        return CollectionExpressionUtils.validateTypeIsNotSObjectBeforeV164(elementType, referencingType, validationScope, nodeToAddErrorsTo, I18nSupport.getLabel("invalid.sobject.list"));
    }

    private static boolean validateTypeIsNotSObjectBeforeV164(TypeInfo type, TypeInfo referencingType, ValidationScope errorsScope, AstNode nodeToAddErrorsTo, String errorMessage) {
        if (TypeInfoEquivalence.isEquivalent(type, TypeInfos.SOBJECT) && Version.V164.isGreaterThan(referencingType.getCodeUnitDetails().getVersion())) {
            errorsScope.getErrors().markInvalid(nodeToAddErrorsTo, errorMessage);
            return false;
        }
        return true;
    }
}

