/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.SystemMethods;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.UnresolvedErrorCalculator;
import apex.jorje.semantic.symbol.visibility.Visibility;
import apex.jorje.services.I18nSupport;

public class ClassRefExpression
extends Expression {
    private final Loc loc;
    private final TypeRef typeRef;
    private TypeInfo type;

    public ClassRefExpression(AstNode definingNode, Expr.ClassRefExpr x) {
        super(definingNode);
        this.loc = x.loc;
        this.typeRef = x.type;
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        visitor.visit(this, scope);
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        this.type = symbols.lookupTypeInfo(this.getDefiningType(), this.typeRef);
        if (!this.type.isResolved()) {
            scope.getErrors().markInvalid((AstNode)this, UnresolvedErrorCalculator.getErrors(this.type));
            return;
        }
        if (!Visibility.isTypeVisible(symbols.getAccessEvaluator(), this.getDefiningType(), this.type, scope.isTestMethod())) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("type.not.visible", this.type));
            return;
        }
        TypeInfo type = symbols.lookupTypeInfo(this.getDefiningType(), InternalTypeInfos.SYSTEM_TYPE);
        this.setType(type);
    }

    @Override
    public void emit(Emitter emitter) {
        emitter.push(this.loc, this.type.getBytecodeName());
        emitter.emit(Loc._SyntheticLoc(), SystemMethods.getTypeToken());
    }

    @Override
    public Loc getLoc() {
        return this.loc;
    }
}

