/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.ast.BooleanOp;
import apex.jorje.semantic.ast.expression.Comparison;
import apex.jorje.semantic.exception.UnexpectedCodePathException;

public class BooleanOps {
    private static final BooleanOps INSTANCE = new BooleanOps();
    private static final BooleanOp.MatchBlock<Boolean> IS_COMPARISON_BLOCK = new BooleanOp.MatchBlockWithDefault<Boolean>(){

        @Override
        public Boolean _case(BooleanOp.And x) {
            return false;
        }

        @Override
        public Boolean _case(BooleanOp.Or x) {
            return false;
        }

        @Override
        protected Boolean _default(BooleanOp x) {
            return true;
        }
    };
    private static final BooleanOp.MatchBlock<Integer> GET_UNARY_OPCODE = new BooleanOp.MatchBlockWithDefault<Integer>(){

        @Override
        public Integer _case(BooleanOp.DoubleEqual x) {
            return 153;
        }

        @Override
        public Integer _case(BooleanOp.TripleEqual x) {
            return 153;
        }

        @Override
        public Integer _case(BooleanOp.NotTripleEqual x) {
            return 154;
        }

        @Override
        public Integer _case(BooleanOp.NotEqual x) {
            return 154;
        }

        @Override
        public Integer _case(BooleanOp.AltNotEqual x) {
            return 154;
        }

        @Override
        public Integer _case(BooleanOp.LessThan x) {
            return 155;
        }

        @Override
        public Integer _case(BooleanOp.GreaterThan x) {
            return 157;
        }

        @Override
        public Integer _case(BooleanOp.LessThanEqual x) {
            return 158;
        }

        @Override
        public Integer _case(BooleanOp.GreaterThanEqual x) {
            return 156;
        }

        @Override
        protected Integer _default(BooleanOp x) {
            throw new UnexpectedCodePathException();
        }
    };
    private static final BooleanOp.MatchBlock<BooleanOp> GET_NEGATE = new BooleanOp.MatchBlockWithDefault<BooleanOp>(){

        @Override
        public BooleanOp _case(BooleanOp.DoubleEqual x) {
            return BooleanOp._NotEqual(x.loc);
        }

        @Override
        public BooleanOp _case(BooleanOp.TripleEqual x) {
            return BooleanOp._NotTripleEqual(x.loc);
        }

        @Override
        public BooleanOp _case(BooleanOp.NotTripleEqual x) {
            return BooleanOp._TripleEqual(x.loc);
        }

        @Override
        public BooleanOp _case(BooleanOp.NotEqual x) {
            return BooleanOp._DoubleEqual(x.loc);
        }

        @Override
        public BooleanOp _case(BooleanOp.AltNotEqual x) {
            return BooleanOp._DoubleEqual(x.loc);
        }

        @Override
        public BooleanOp _case(BooleanOp.LessThan x) {
            return BooleanOp._GreaterThanEqual(x.loc);
        }

        @Override
        public BooleanOp _case(BooleanOp.GreaterThan x) {
            return BooleanOp._LessThanEqual(x.loc);
        }

        @Override
        public BooleanOp _case(BooleanOp.LessThanEqual x) {
            return BooleanOp._GreaterThan(x.loc);
        }

        @Override
        public BooleanOp _case(BooleanOp.GreaterThanEqual x) {
            return BooleanOp._LessThan(x.loc);
        }

        @Override
        protected BooleanOp _default(BooleanOp x) {
            throw new UnexpectedCodePathException();
        }
    };
    private static final BooleanOp.MatchBlock<Comparison> GET_INTEGER_COMPARISON = new BooleanOp.MatchBlockWithDefault<Comparison>(){
        private final Comparison.UnaryComparison EQUAL = new Comparison.UnaryComparison(159);
        private final Comparison.UnaryComparison NOT_EQUAL = new Comparison.UnaryComparison(160);
        private final Comparison.UnaryComparison LESS_THAN = new Comparison.UnaryComparison(161);
        private final Comparison.UnaryComparison GREATER_THAN = new Comparison.UnaryComparison(163);
        private final Comparison.UnaryComparison LESS_THAN_EQUAL = new Comparison.UnaryComparison(164);
        private final Comparison.UnaryComparison GREATER_THAN_EQUAL = new Comparison.UnaryComparison(162);

        @Override
        public Comparison _case(BooleanOp.DoubleEqual x) {
            return this.EQUAL;
        }

        @Override
        public Comparison _case(BooleanOp.NotEqual x) {
            return this.NOT_EQUAL;
        }

        @Override
        public Comparison _case(BooleanOp.AltNotEqual x) {
            return this.NOT_EQUAL;
        }

        @Override
        public Comparison _case(BooleanOp.LessThan x) {
            return this.LESS_THAN;
        }

        @Override
        public Comparison _case(BooleanOp.GreaterThan x) {
            return this.GREATER_THAN;
        }

        @Override
        public Comparison _case(BooleanOp.LessThanEqual x) {
            return this.LESS_THAN_EQUAL;
        }

        @Override
        public Comparison _case(BooleanOp.GreaterThanEqual x) {
            return this.GREATER_THAN_EQUAL;
        }

        @Override
        protected Comparison _default(BooleanOp x) {
            throw new UnexpectedCodePathException();
        }
    };

    private BooleanOps() {
    }

    public static BooleanOps get() {
        return INSTANCE;
    }

    public boolean isComparisonOperator(BooleanOp op) {
        return op.match(IS_COMPARISON_BLOCK);
    }

    public boolean isEquality(BooleanOp op) {
        return op.match(new BooleanOp.MatchBlockWithDefault<Boolean>(){

            @Override
            public Boolean _case(BooleanOp.DoubleEqual x) {
                return true;
            }

            @Override
            public Boolean _case(BooleanOp.NotEqual x) {
                return true;
            }

            @Override
            public Boolean _case(BooleanOp.AltNotEqual x) {
                return true;
            }

            @Override
            public Boolean _default(BooleanOp x) {
                return false;
            }
        });
    }

    public Comparison getIntegerComparison(BooleanOp op) {
        return op.match(GET_INTEGER_COMPARISON);
    }

    public Integer getUnaryOpcode(BooleanOp op) {
        return op.match(GET_UNARY_OPCODE);
    }

    public BooleanOp negate(BooleanOp op) {
        return op.match(GET_NEGATE);
    }
}

