/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.BooleanOp;
import apex.jorje.data.ast.Expr;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodeFactory;
import apex.jorje.semantic.ast.TypeConversion;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.BooleanExpressionType;
import apex.jorje.semantic.ast.expression.BooleanOps;
import apex.jorje.semantic.ast.expression.Comparison;
import apex.jorje.semantic.ast.expression.ComparisonFactory;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.ExpressionUtil;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.resolver.Distance;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Queues;
import java.util.ArrayDeque;
import java.util.List;
import shaded.org.objectweb.asm.Label;

public class BooleanExpression
extends Expression {
    private final Loc loc;
    private final Expression left;
    private final Expression right;
    private final BooleanExpressionType expressionType;
    private final BooleanOp op;
    private Label exit;
    private Label trueLabel;
    private Label falseLabel;
    private TypeInfo commonType;

    public BooleanExpression(AstNode definingNode, Expr.BooleanExpr expr) {
        super(definingNode);
        this.op = expr.op;
        this.loc = Location.from(expr);
        this.left = AstNodeFactory.create((AstNode)this, expr.left);
        this.right = AstNodeFactory.create((AstNode)this, expr.right);
        this.expressionType = BooleanExpressionType.get(expr.op);
        this.exit = new Label();
        this.trueLabel = new Label();
        this.falseLabel = new Label();
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.left.traverse(visitor, scope);
            this.right.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        this.left.validate(symbols, scope);
        this.right.validate(symbols, scope);
        if (scope.getErrors().isInvalid(this.left, this.right)) {
            scope.getErrors().markInvalid(this);
            return;
        }
        this.commonType = Distance.get().getCommonType(this.getDefiningType(), this.left.getType(), this.right.getType());
        if (this.commonType == null && BooleanOps.get().isComparisonOperator(this.op) || this.isAnyTypeNull() && !BooleanOps.get().isEquality(this.op)) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.comparison.types", this.left.getType(), this.right.getType()));
            return;
        }
        this.operatorValidate(scope);
        this.setType(TypeInfos.BOOLEAN);
    }

    @Override
    public void emit(final Emitter emitter) {
        this.op._switch(new BooleanOp.SwitchBlockWithDefault(){

            @Override
            public void _case(BooleanOp.And x) {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (Expression expression : BooleanExpression.this.foldExpressions(BooleanExpressionType.AND)) {
                    if (BooleanExpressionType.COMPARISON.isSameType(expression)) {
                        BooleanExpression booleanExpression = ExpressionUtil.getBooleanExpression(expression);
                        booleanExpression.emitComparison(emitter);
                        builder.add(booleanExpression.falseLabel);
                        continue;
                    }
                    expression.emit(emitter);
                    emitter.unbox(TypeInfos.BOOLEAN);
                    emitter.emitJump(BooleanExpression.this.loc, 153, BooleanExpression.this.falseLabel);
                }
                emitter.push(BooleanExpression.this.loc, true);
                emitter.box(TypeInfos.BOOLEAN);
                emitter.emitJump(BooleanExpression.this.loc, 167, BooleanExpression.this.exit);
                builder.build().forEach(emitter::emit);
                emitter.emit(BooleanExpression.this.falseLabel);
                emitter.push(BooleanExpression.this.loc, false);
                emitter.box(TypeInfos.BOOLEAN);
                emitter.emit(BooleanExpression.this.exit);
            }

            @Override
            public void _case(BooleanOp.Or x) {
                for (Expression expression : BooleanExpression.this.foldExpressions(BooleanExpressionType.OR)) {
                    if (BooleanExpressionType.COMPARISON.isSameType(expression)) {
                        BooleanExpression booleanExpression = ExpressionUtil.getBooleanExpression(expression);
                        booleanExpression.emitComparison(emitter);
                        emitter.emitJump(BooleanExpression.this.loc, 167, BooleanExpression.this.trueLabel);
                        emitter.emit(booleanExpression.falseLabel);
                        continue;
                    }
                    expression.emit(emitter);
                    emitter.unbox(TypeInfos.BOOLEAN);
                    emitter.emitJump(BooleanExpression.this.loc, 154, BooleanExpression.this.trueLabel);
                }
                emitter.push(BooleanExpression.this.loc, false);
                emitter.box(TypeInfos.BOOLEAN);
                emitter.emitJump(BooleanExpression.this.loc, 167, BooleanExpression.this.exit);
                emitter.emit(BooleanExpression.this.trueLabel);
                emitter.push(BooleanExpression.this.loc, true);
                emitter.box(TypeInfos.BOOLEAN);
                emitter.emit(BooleanExpression.this.exit);
            }

            @Override
            protected void _default(BooleanOp x) {
                BooleanExpression.this.emitComparison(emitter);
                emitter.push(BooleanExpression.this.loc, true);
                emitter.box(TypeInfos.BOOLEAN);
                emitter.emitJump(BooleanExpression.this.loc, 167, BooleanExpression.this.exit);
                emitter.emit(BooleanExpression.this.falseLabel);
                emitter.push(BooleanExpression.this.loc, false);
                emitter.box(TypeInfos.BOOLEAN);
                emitter.emit(BooleanExpression.this.exit);
            }
        });
        this.resetLabels();
    }

    @Override
    public Loc getLoc() {
        return this.loc;
    }

    private void operatorValidate(final ValidationScope scope) {
        this.op._switch(new BooleanOp.SwitchBlock(){

            @Override
            public void _case(BooleanOp.DoubleEqual x) {
            }

            @Override
            public void _case(BooleanOp.TripleEqual x) {
                this.exactEqualityValidate();
            }

            @Override
            public void _case(BooleanOp.NotTripleEqual x) {
                this.exactEqualityValidate();
            }

            @Override
            public void _case(BooleanOp.NotEqual x) {
            }

            @Override
            public void _case(BooleanOp.AltNotEqual x) {
            }

            @Override
            public void _case(BooleanOp.LessThan x) {
                this.inequalityValidate();
            }

            @Override
            public void _case(BooleanOp.GreaterThan x) {
                this.inequalityValidate();
            }

            @Override
            public void _case(BooleanOp.LessThanEqual x) {
                this.inequalityValidate();
            }

            @Override
            public void _case(BooleanOp.GreaterThanEqual x) {
                this.inequalityValidate();
            }

            @Override
            public void _case(BooleanOp.And x) {
                this.logicalValidate();
            }

            @Override
            public void _case(BooleanOp.Or x) {
                this.logicalValidate();
            }

            private void exactEqualityValidate() {
                if (!BooleanExpression.this.commonType.getBasicType().isReference()) {
                    scope.getErrors().markInvalid((AstNode)BooleanExpression.this, I18nSupport.getLabel("invalid.exact.equality.type", BooleanExpression.this.commonType));
                }
            }

            private void inequalityValidate() {
                if (!BooleanExpression.this.commonType.getBasicType().allowsInequality()) {
                    scope.getErrors().markInvalid((AstNode)BooleanExpression.this, I18nSupport.getLabel("invalid.inequality.type", BooleanExpression.this.commonType));
                }
            }

            private void logicalValidate() {
                if (BooleanExpression.this.commonType == null || !TypeInfoEquivalence.isEquivalent(TypeInfos.BOOLEAN, BooleanExpression.this.commonType)) {
                    scope.getErrors().markInvalid((AstNode)BooleanExpression.this, I18nSupport.getLabel("invalid.logical.type", TypeInfos.BOOLEAN));
                }
            }
        });
    }

    private boolean isAnyTypeNull() {
        return this.left.getType().getBasicType() == BasicType.NULL || this.right.getType().getBasicType() == BasicType.NULL;
    }

    private List<Expression> foldExpressions(BooleanExpressionType expressionType) {
        BooleanExpression current;
        ImmutableList.Builder builder = ImmutableList.builder();
        if (!expressionType.isSameType(this.left)) {
            builder.add(this.left);
            builder.add(this.right);
            return builder.build();
        }
        ArrayDeque<Expression> expressions = Queues.newArrayDeque();
        expressions.push(this.left);
        while (expressionType.isSameType((Expression)expressions.peek())) {
            current = ExpressionUtil.getBooleanExpression((Expression)expressions.peek());
            expressions.push(current.left);
        }
        builder.add(expressions.pop());
        while (!expressions.isEmpty()) {
            current = ExpressionUtil.getBooleanExpression((Expression)expressions.pop());
            builder.add(current.right);
        }
        builder.add(this.right);
        return builder.build();
    }

    public void emitComparison(Emitter emitter) {
        Comparison comparison = ComparisonFactory.get(this.commonType, this.op);
        if (TypeInfoEquivalence.isEquivalent(InternalTypeInfos.NULL, this.left.getType())) {
            this.emitNull(emitter, this.right);
        } else if (TypeInfoEquivalence.isEquivalent(InternalTypeInfos.NULL, this.right.getType())) {
            this.emitNull(emitter, this.left);
        } else if (this.left.isNullable()) {
            this.left.emit(emitter);
            TypeConversion.emit(this.loc, emitter, this.left.getType(), this.commonType);
            emitter.emit(this.loc, 89);
            Label leftNotNull = new Label();
            emitter.emitJump(this.loc, 199, leftNotNull);
            emitter.emit(this.loc, 87);
            if (this.right.isNullable()) {
                this.emitLeftNullRightNullable(emitter);
            } else {
                this.emitLeftNullRightNonNull(emitter);
            }
            emitter.emit(leftNotNull);
            if (this.right.isNullable()) {
                this.emitLeftNonNullRightNullable(emitter, comparison);
            } else {
                comparison.emitUnbox(emitter, this.commonType);
                this.right.emit(emitter);
                TypeConversion.emit(this.loc, emitter, this.right.getType(), this.commonType);
                comparison.emitUnbox(emitter, this.commonType);
                comparison.emitComparison(this.loc, emitter, this.falseLabel);
            }
        } else if (this.right.isNullable()) {
            this.left.emit(emitter);
            TypeConversion.emit(this.loc, emitter, this.left.getType(), this.commonType);
            this.emitLeftNonNullRightNullable(emitter, comparison);
        } else {
            this.left.emit(emitter);
            TypeConversion.emit(this.loc, emitter, this.left.getType(), this.commonType);
            comparison.emitUnbox(emitter, this.commonType);
            this.right.emit(emitter);
            TypeConversion.emit(this.loc, emitter, this.right.getType(), this.commonType);
            comparison.emitUnbox(emitter, this.commonType);
            comparison.emitComparison(this.loc, emitter, this.falseLabel);
        }
        emitter.emit(this.trueLabel);
    }

    private void emitNull(final Emitter emitter, final Expression expression) {
        this.op._switch(new BooleanOp.SwitchBlockWithDefault(){

            private void emitNullEquals() {
                expression.emit(emitter);
                TypeConversion.emit(BooleanExpression.this.loc, emitter, expression.getType(), BooleanExpression.this.commonType);
                emitter.emitJump(BooleanExpression.this.loc, 199, BooleanExpression.this.falseLabel);
            }

            private void emitNullNotEquals() {
                expression.emit(emitter);
                TypeConversion.emit(BooleanExpression.this.loc, emitter, expression.getType(), BooleanExpression.this.commonType);
                emitter.emitJump(BooleanExpression.this.loc, 198, BooleanExpression.this.falseLabel);
            }

            @Override
            public void _case(BooleanOp.DoubleEqual x) {
                this.emitNullEquals();
            }

            @Override
            public void _case(BooleanOp.TripleEqual x) {
                this.emitNullEquals();
            }

            @Override
            public void _case(BooleanOp.NotTripleEqual x) {
                this.emitNullNotEquals();
            }

            @Override
            public void _case(BooleanOp.NotEqual x) {
                this.emitNullNotEquals();
            }

            @Override
            public void _case(BooleanOp.AltNotEqual x) {
                this.emitNullNotEquals();
            }

            @Override
            protected void _default(BooleanOp x) {
                throw new UnexpectedCodePathException();
            }
        });
    }

    private void emitLeftNullRightNullable(final Emitter emitter) {
        this.op._switch(new BooleanOp.SwitchBlockWithDefault(){

            private void emitNullEquals() {
                BooleanExpression.this.right.emit(emitter);
                TypeConversion.emit(BooleanExpression.this.loc, emitter, BooleanExpression.this.right.getType(), BooleanExpression.this.commonType);
                emitter.emitJump(BooleanExpression.this.loc, 199, BooleanExpression.this.falseLabel);
                emitter.emitJump(BooleanExpression.this.loc, 167, BooleanExpression.this.trueLabel);
            }

            private void emitNullNotEquals() {
                BooleanExpression.this.right.emit(emitter);
                TypeConversion.emit(BooleanExpression.this.loc, emitter, BooleanExpression.this.right.getType(), BooleanExpression.this.commonType);
                emitter.emitJump(BooleanExpression.this.loc, 198, BooleanExpression.this.falseLabel);
                emitter.emitJump(BooleanExpression.this.loc, 167, BooleanExpression.this.trueLabel);
            }

            @Override
            public void _case(BooleanOp.DoubleEqual x) {
                this.emitNullEquals();
            }

            @Override
            public void _case(BooleanOp.TripleEqual x) {
                this.emitNullEquals();
            }

            @Override
            public void _case(BooleanOp.NotTripleEqual x) {
                this.emitNullNotEquals();
            }

            @Override
            public void _case(BooleanOp.NotEqual x) {
                this.emitNullNotEquals();
            }

            @Override
            public void _case(BooleanOp.AltNotEqual x) {
                this.emitNullNotEquals();
            }

            @Override
            public void _case(BooleanOp.LessThan x) {
                if (BooleanExpression.this.commonType.equals(TypeInfos.STRING) || BooleanExpression.this.commonType.equals(TypeInfos.ID)) {
                    this.emitNullNotEquals();
                } else {
                    this._default(x);
                }
            }

            @Override
            public void _case(BooleanOp.LessThanEqual x) {
                if (BooleanExpression.this.commonType.equals(TypeInfos.STRING) || BooleanExpression.this.commonType.equals(TypeInfos.ID)) {
                    BooleanExpression.this.right.emit(emitter);
                    emitter.emit(BooleanExpression.this.loc, 87);
                    emitter.emitJump(BooleanExpression.this.loc, 167, BooleanExpression.this.trueLabel);
                } else {
                    this._default(x);
                }
            }

            @Override
            public void _case(BooleanOp.GreaterThanEqual x) {
                if (BooleanExpression.this.commonType.equals(TypeInfos.STRING) || BooleanExpression.this.commonType.equals(TypeInfos.ID)) {
                    BooleanExpression.this.right.emit(emitter);
                    TypeConversion.emit(BooleanExpression.this.loc, emitter, BooleanExpression.this.right.getType(), BooleanExpression.this.commonType);
                    emitter.emitJump(BooleanExpression.this.loc, 198, BooleanExpression.this.trueLabel);
                    emitter.emitJump(BooleanExpression.this.loc, 167, BooleanExpression.this.falseLabel);
                } else {
                    this._default(x);
                }
            }

            @Override
            protected void _default(BooleanOp x) {
                BooleanExpression.this.right.emit(emitter);
                emitter.emit(BooleanExpression.this.loc, 87);
                emitter.emitJump(BooleanExpression.this.loc, 167, BooleanExpression.this.falseLabel);
            }
        });
    }

    private void emitLeftNullRightNonNull(final Emitter emitter) {
        this.op._switch(new BooleanOp.SwitchBlockWithDefault(){

            @Override
            public void _case(BooleanOp.NotTripleEqual x) {
                emitter.emitJump(BooleanExpression.this.loc, 167, BooleanExpression.this.trueLabel);
            }

            @Override
            public void _case(BooleanOp.NotEqual x) {
                emitter.emitJump(BooleanExpression.this.loc, 167, BooleanExpression.this.trueLabel);
            }

            @Override
            public void _case(BooleanOp.AltNotEqual x) {
                emitter.emitJump(BooleanExpression.this.loc, 167, BooleanExpression.this.trueLabel);
            }

            @Override
            public void _case(BooleanOp.LessThan x) {
                if (TypeInfoEquivalence.isEquivalent(BooleanExpression.this.commonType, TypeInfos.STRING) || TypeInfoEquivalence.isEquivalent(BooleanExpression.this.commonType, TypeInfos.ID)) {
                    emitter.emitJump(BooleanExpression.this.loc, 167, BooleanExpression.this.trueLabel);
                } else {
                    this._default(x);
                }
            }

            @Override
            public void _case(BooleanOp.LessThanEqual x) {
                if (TypeInfoEquivalence.isEquivalent(BooleanExpression.this.commonType, TypeInfos.STRING) || TypeInfoEquivalence.isEquivalent(BooleanExpression.this.commonType, TypeInfos.ID)) {
                    emitter.emitJump(BooleanExpression.this.loc, 167, BooleanExpression.this.trueLabel);
                } else {
                    this._default(x);
                }
            }

            @Override
            protected void _default(BooleanOp x) {
                emitter.emitJump(BooleanExpression.this.loc, 167, BooleanExpression.this.falseLabel);
            }
        });
    }

    private void emitLeftNonNullRightNullable(Emitter emitter, Comparison comparison) {
        if (this.isDoubleOrLong(this.left.getType()) || this.isDoubleOrLong(this.commonType)) {
            this.emitWide(emitter, comparison);
        } else {
            this.emitNarrow(emitter, comparison);
        }
        TypeConversion.emit(this.loc, emitter, this.right.getType(), this.commonType);
        comparison.emitUnbox(emitter, this.commonType);
        comparison.emitComparison(this.loc, emitter, this.falseLabel);
    }

    private boolean isDoubleOrLong(TypeInfo type) {
        return TypeInfoEquivalence.isEquivalent(type, TypeInfos.DOUBLE) || TypeInfoEquivalence.isEquivalent(type, TypeInfos.LONG);
    }

    private void emitNarrow(Emitter emitter, Comparison comparison) {
        comparison.emitUnbox(emitter, this.commonType);
        this.right.emit(emitter);
        emitter.emit(this.loc, 89);
        this.emitRightNullCheck(emitter, 88);
    }

    private void emitWide(Emitter emitter, Comparison comparison) {
        this.right.emit(emitter);
        emitter.emit(this.loc, 89);
        int rightVariablePos = emitter.getMethodStack().peek().getLocalVariables().add();
        emitter.emitVar(this.loc, 58, rightVariablePos);
        this.emitRightNullCheck(emitter, 87);
        comparison.emitUnbox(emitter, this.commonType);
        emitter.emitVar(this.loc, 25, rightVariablePos);
        emitter.emit(this.loc, 1);
        emitter.emitVar(this.loc, 58, rightVariablePos);
        emitter.getMethodStack().peek().getLocalVariables().clear(rightVariablePos);
    }

    private void emitRightNullCheck(final Emitter emitter, final int opcode) {
        assert (opcode == 87 || opcode == 88);
        Label rightNotNull = new Label();
        emitter.emitJump(this.loc, 199, rightNotNull);
        this.op._switch(new BooleanOp.SwitchBlockWithDefault(){

            @Override
            public void _case(BooleanOp.NotTripleEqual x) {
                emitter.emit(BooleanExpression.this.loc, opcode);
                emitter.emitJump(BooleanExpression.this.loc, 167, BooleanExpression.this.trueLabel);
            }

            @Override
            public void _case(BooleanOp.NotEqual x) {
                emitter.emit(BooleanExpression.this.loc, opcode);
                emitter.emitJump(BooleanExpression.this.loc, 167, BooleanExpression.this.trueLabel);
            }

            @Override
            public void _case(BooleanOp.AltNotEqual x) {
                emitter.emit(BooleanExpression.this.loc, opcode);
                emitter.emitJump(BooleanExpression.this.loc, 167, BooleanExpression.this.trueLabel);
            }

            @Override
            public void _case(BooleanOp.GreaterThan x) {
                if (BooleanExpression.this.commonType.equals(TypeInfos.STRING) || BooleanExpression.this.commonType.equals(TypeInfos.ID)) {
                    emitter.emit(BooleanExpression.this.loc, opcode);
                    emitter.emitJump(BooleanExpression.this.loc, 167, BooleanExpression.this.trueLabel);
                } else {
                    this._default(x);
                }
            }

            @Override
            public void _case(BooleanOp.GreaterThanEqual x) {
                if (BooleanExpression.this.commonType.equals(TypeInfos.STRING) || BooleanExpression.this.commonType.equals(TypeInfos.ID)) {
                    emitter.emit(BooleanExpression.this.loc, opcode);
                    emitter.emitJump(BooleanExpression.this.loc, 167, BooleanExpression.this.trueLabel);
                } else {
                    this._default(x);
                }
            }

            @Override
            protected void _default(BooleanOp x) {
                emitter.emit(BooleanExpression.this.loc, opcode);
                emitter.emitJump(BooleanExpression.this.loc, 167, BooleanExpression.this.falseLabel);
            }
        });
        emitter.emit(rightNotNull);
    }

    public BooleanExpressionType getBooleanExpressionType() {
        return this.expressionType;
    }

    public Label getFalseLabel() {
        return this.falseLabel;
    }

    public void resetLabels() {
        this.exit = new Label();
        this.trueLabel = new Label();
        this.falseLabel = new Label();
    }
}

