/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.Expr;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodeFactory;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.ListMethods;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.services.I18nSupport;

public class ArrayStoreExpression
extends Expression {
    private final Loc loc;
    private final Expression expression;
    private final Expression index;

    public ArrayStoreExpression(AstNode definingNode, Expr.ArrayExpr expr) {
        super(definingNode);
        this.loc = expr.loc;
        this.expression = AstNodeFactory.create((AstNode)this, expr.expr);
        this.index = AstNodeFactory.create((AstNode)this, expr.index);
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.expression.traverse(visitor, scope);
            this.index.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        this.expression.validate(symbols, scope);
        this.index.validate(symbols, scope);
        if (scope.getErrors().isInvalid(this.expression, this.index)) {
            scope.getErrors().markInvalid(this);
            return;
        }
        if (!CollectionTypeInfoUtil.isList(this.expression.getType())) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.list.type", this.expression.getType()));
        } else {
            this.setType(CollectionTypeInfoUtil.getElementType((GenericTypeInfo)this.expression.getType()));
        }
        if (!this.index.getType().equals(TypeInfos.INTEGER)) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.list.index.type", TypeInfos.INTEGER, this.index.getType()));
        }
    }

    @Override
    public void emit(Emitter emitter) {
        if (this.getOptions().isSpecialAssignment) {
            emitter.emit(this.loc, 95);
        } else {
            this.expression.emit(emitter);
            emitter.emit(Loc._SyntheticLoc(), 95);
            this.index.emit(emitter);
        }
        emitter.emit(Loc._SyntheticLoc(), 95);
        emitter.emit(this.loc, ListMethods.setBytecode());
    }

    @Override
    public Loc getLoc() {
        return this.loc;
    }
}

