/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.context;

import apex.jorje.data.Loc;
import apex.jorje.semantic.ast.Emit;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.context.MethodStack;
import apex.jorje.semantic.common.iterable.MoreIterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import java.util.Deque;
import java.util.List;
import shaded.org.objectweb.asm.Label;

public class TryCatchFinallyStack {
    private final Emitter emitter;
    private final Deque<TryCatchFinallyContext> quack;

    public TryCatchFinallyStack(Emitter emitter) {
        this.emitter = emitter;
        this.quack = Queues.newArrayDeque();
    }

    public void emitFinallyJumps() {
        this.quack.stream().filter(tryCatchFinally -> ((TryCatchFinallyContext)tryCatchFinally).hasFinally).forEach(tryCatchFinally -> this.emitter.emitJump(Loc._SyntheticLoc(), 168, ((TryCatchFinallyContext)tryCatchFinally).finallyBlock.start));
    }

    public TryCatchFinallyContext push(Emit finallyEmit) {
        TryCatchFinallyContext tryCatchFinally = new TryCatchFinallyContext(finallyEmit);
        this.quack.push(tryCatchFinally);
        return tryCatchFinally;
    }

    public void emitFinallyJumps(int tryStackSize) {
        int i = this.quack.size();
        for (TryCatchFinallyContext tryCatchFinally : this.quack) {
            if (i <= tryStackSize) break;
            if (tryCatchFinally.hasFinally) {
                this.emitter.emitJump(Loc._SyntheticLoc(), 168, ((TryCatchFinallyContext)tryCatchFinally).finallyBlock.start);
            }
            --i;
        }
    }

    public void startTryBlock() {
        TryCatchFinallyContext context = this.quack.peek();
        this.startBlock(context.tryBlock);
    }

    public void startCatchBlock() {
        this.startBlock(new Block());
    }

    private void startBlock(Block block) {
        TryCatchFinallyContext tryCatchFinally = this.quack.peek();
        assert (tryCatchFinally.currentBlocks.isEmpty());
        tryCatchFinally.currentBlocks.push(block);
        this.emitter.emit(block.start);
    }

    public Block endBlock() {
        TryCatchFinallyContext context = this.quack.peek();
        Block block = (Block)context.currentBlocks.pop();
        assert (context.currentBlocks.isEmpty());
        this.emitter.emit(block.end);
        if (context.hasFinally) {
            context.finallyBlocks.add(block);
            this.emitter.emitJump(Loc._SyntheticLoc(), 168, ((TryCatchFinallyContext)context).finallyBlock.start);
        }
        return block;
    }

    public void pop(Emit exceptionEmit) {
        TryCatchFinallyContext context = this.quack.pop();
        MethodStack.MethodContext method = this.emitter.getMethodStack().peek();
        if (!context.hasFinally) {
            return;
        }
        this.emitter.emitJump(Loc._SyntheticLoc(), 167, ((TryCatchFinallyContext)context).finallyBlock.end);
        this.emitter.emit(((TryCatchFinallyContext)context).finallyBlock.start);
        method.getLocalVariables().clean();
        int returnIndex = method.getLocalVariables().add();
        int exceptionIndex = method.getLocalVariables().add();
        this.emitter.emitVar(Loc._SyntheticLoc(), 58, returnIndex);
        context.finallyEmit.emit(this.emitter);
        this.emitter.emitVar(Loc._SyntheticLoc(), 169, returnIndex);
        Label handlerStart = new Label();
        this.emitter.emit(handlerStart);
        exceptionEmit.emit(this.emitter);
        this.emitter.emitVar(Loc._SyntheticLoc(), 58, exceptionIndex);
        this.emitter.emitJump(Loc._SyntheticLoc(), 168, ((TryCatchFinallyContext)context).finallyBlock.start);
        this.emitter.emitVar(Loc._SyntheticLoc(), 25, exceptionIndex);
        this.emitter.emit(Loc._SyntheticLoc(), 191);
        for (Block block : context.finallyBlocks) {
            this.emitter.emitFinallyBlock(block.start, block.end, handlerStart);
        }
        this.emitter.emit(((TryCatchFinallyContext)context).finallyBlock.end);
        this.emitter.emit(Loc._SyntheticLoc(), 0);
        method.getLocalVariables().clear(returnIndex);
        method.getLocalVariables().clear(exceptionIndex);
    }

    public int size() {
        return this.quack.size();
    }

    public boolean isEmpty() {
        return this.quack.isEmpty();
    }

    public TryCatchFinallyContext peek() {
        return this.quack.peek();
    }

    public boolean hasFinally() {
        return MoreIterables.ensureAny(this.quack, input -> ((TryCatchFinallyContext)input).hasFinally);
    }

    public static class Block {
        public final Label start = new Label();
        public final Label end = new Label();
    }

    public static class TryCatchFinallyContext {
        public final Label exit;
        public final Label tryStartForCatch;
        public final Block tryBlock;
        private final boolean hasFinally;
        private final List<Block> finallyBlocks;
        private final Deque<Block> currentBlocks;
        private final Block finallyBlock;
        private final Emit finallyEmit;

        public TryCatchFinallyContext(Emit finallyEmit) {
            this.finallyEmit = finallyEmit;
            this.hasFinally = finallyEmit != Emit.NOOP;
            this.finallyBlocks = Lists.newArrayList();
            this.currentBlocks = Queues.newArrayDeque();
            this.exit = new Label();
            this.tryStartForCatch = new Label();
            this.tryBlock = new Block();
            this.finallyBlock = new Block();
        }
    }
}

