/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.context;

import apex.jorje.semantic.ast.context.LocalVariables;
import apex.jorje.semantic.common.iterable.EnclosingTypeIterable;
import apex.jorje.semantic.common.iterable.MoreIterables;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.UnitType;
import com.google.common.collect.Queues;
import java.util.Deque;
import shaded.org.objectweb.asm.commons.GeneratorAdapter;

public class MethodStack {
    private final Deque<MethodContext> quack = Queues.newArrayDeque();

    public void push(MethodContext method) {
        this.quack.push(method);
    }

    public MethodContext pop() {
        return this.quack.pop();
    }

    public MethodContext peek() {
        return this.quack.peek();
    }

    public boolean isEmpty() {
        return this.quack.isEmpty();
    }

    public static class SuppressCodeLocationsCalculator {
        private final MethodInfo methodInfo;

        public SuppressCodeLocationsCalculator(MethodInfo methodInfo) {
            this.methodInfo = methodInfo;
        }

        public boolean shouldSuppressCodeLocations() {
            return this.methodInfo.getModifiers().some(ModifierTypeInfos.TEST_METHOD, AnnotationTypeInfos.IS_TEST) || MoreIterables.ensureAny(new EnclosingTypeIterable(this.methodInfo.getDefiningType()), type -> type.getModifiers().has(AnnotationTypeInfos.TEST_SETUP)) || this.methodInfo.getDefiningType().getUnitType() == UnitType.ANONYMOUS && (this.methodInfo.getName().startsWith("__sfdc__proxy_") || this.methodInfo.getName().equalsIgnoreCase("execute"));
        }
    }

    public static class MethodContext {
        private final MethodInfo methodInfo;
        private final LocalVariables localVariables;
        private final GeneratorAdapter generatorAdapter;
        private final boolean suppressCodeLocations;
        private TypeInfo pendingBox;
        private TypeInfo pendingUnbox;

        public MethodContext(MethodInfo methodInfo, GeneratorAdapter generatorAdapter) {
            this.methodInfo = methodInfo;
            this.generatorAdapter = generatorAdapter;
            this.localVariables = new LocalVariables();
            this.pendingBox = null;
            this.pendingUnbox = null;
            this.suppressCodeLocations = new SuppressCodeLocationsCalculator(methodInfo).shouldSuppressCodeLocations();
        }

        public LocalVariables getLocalVariables() {
            return this.localVariables;
        }

        public MethodInfo getMethodInfo() {
            return this.methodInfo;
        }

        public boolean shouldSuppressCodeLocations() {
            return this.suppressCodeLocations;
        }

        public GeneratorAdapter getGeneratorAdapter() {
            return this.generatorAdapter;
        }

        public TypeInfo getPendingBox() {
            return this.pendingBox;
        }

        public void setPendingBox(TypeInfo pendingBox) {
            this.pendingBox = pendingBox;
        }

        public TypeInfo getPendingUnbox() {
            return this.pendingUnbox;
        }

        public void setPendingUnbox(TypeInfo pendingUnbox) {
            this.pendingUnbox = pendingUnbox;
        }
    }
}

