/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.condition;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.Expr;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodeFactory;
import apex.jorje.semantic.ast.condition.Condition;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.BooleanExpression;
import apex.jorje.semantic.ast.expression.BooleanExpressionType;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.NoopScope;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Location;
import shaded.org.objectweb.asm.Label;

public class StandardCondition
implements Condition {
    private final TypeInfo definingType;
    private final Loc loc;
    private final Expression condition;
    private Label falseLabel;

    public StandardCondition(AstNode definingNode, Expr expr) {
        this.definingType = definingNode.getDefiningType();
        this.loc = Location.from(expr);
        this.condition = AstNodeFactory.create((AstNode)this, expr);
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.condition.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        this.condition.validate(symbols, scope);
        if (scope.getErrors().isInvalid((AstNode)this.condition)) {
            scope.getErrors().markInvalid(this);
            return;
        }
        if (!this.condition.getType().equals(TypeInfos.BOOLEAN)) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.condition.type", this.condition.getType()));
        }
    }

    @Override
    public void emit(final Emitter emitter) {
        this.condition.traverse(new AstVisitor<NoopScope>(){

            @Override
            protected boolean defaultVisit() {
                Label falseLabel = new Label();
                StandardCondition.this.condition.emit(emitter);
                emitter.unbox(StandardCondition.this.condition.getType());
                emitter.emitJump(StandardCondition.this.loc, 153, falseLabel);
                StandardCondition.this.falseLabel = falseLabel;
                return false;
            }

            @Override
            public boolean visit(BooleanExpression node, NoopScope scope) {
                if (node.getBooleanExpressionType() == BooleanExpressionType.COMPARISON) {
                    node.emitComparison(emitter);
                    StandardCondition.this.falseLabel = node.getFalseLabel();
                    node.resetLabels();
                    return false;
                }
                return this.defaultVisit();
            }
        }, NoopScope.get());
    }

    @Override
    public TypeInfo getDefiningType() {
        return this.definingType;
    }

    @Override
    public Loc getLoc() {
        return this.condition.getLoc();
    }

    @Override
    public Label getFalseLabel(Emitter emitter) {
        this.emit(emitter);
        return this.falseLabel;
    }
}

