/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.compilation;

import apex.jorje.data.Loc;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.Emit;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.member.MethodFactory;
import apex.jorje.semantic.ast.member.Parameter;
import apex.jorje.semantic.ast.member.SystemModeEmit;
import apex.jorje.semantic.ast.modifier.Annotations;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.ModifierGroupBuilder;
import apex.jorje.semantic.ast.statement.ConstructorPreambleStatement;
import apex.jorje.semantic.ast.statement.SimpleStatement;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.SymbolScope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.ObjectMethods;
import apex.jorje.semantic.bcl.SystemMethods;
import apex.jorje.semantic.bcl.ThrowableMethods;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.Signature;
import apex.jorje.semantic.symbol.member.method.SignatureFactory;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfo;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.naming.TypeNameUtil;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.ImmutableList;
import java.util.List;
import shaded.org.objectweb.asm.Label;

public class UserExceptionMethods
implements AstNode {
    public static final String DEFAULT_MESSAGE = "Script-thrown exception";
    private static final Signature NONE = SignatureFactory.create("<init>", TypeInfos.VOID);
    private static final Signature MESSAGE = SignatureFactory.create("<init>", (TypeInfo)TypeInfos.VOID, TypeInfos.STRING);
    private static final Signature CAUSE = SignatureFactory.create("<init>", (TypeInfo)TypeInfos.VOID, TypeInfos.EXCEPTION);
    private static final Signature MESSAGE_CAUSE = SignatureFactory.create("<init>", (TypeInfo)TypeInfos.VOID, TypeInfos.STRING, TypeInfos.EXCEPTION);
    private static final String EXCEPTION_DETAIL_MESSAGE_FIELD_NAME = "sfdc_detailMessage";
    public static final Emit PUT_DEFAULT_MESSAGE = UserExceptionMethods.createPutMessage(false);
    private static final Emit PUT_MESSAGE = UserExceptionMethods.createPutMessage(true);
    private final ModifierGroup constructorModifiers;
    private final ModifierGroup methodModifiers;
    private final TypeInfo parentCauseType;
    private final boolean isApexBaseException;
    private final Loc loc;
    private final TypeInfo definingType;
    private List<Method> methods;

    public UserExceptionMethods(AstNode node, Loc loc) {
        this.definingType = node.getDefiningType();
        this.loc = loc;
        this.isApexBaseException = TypeNameUtil.isApexBaseException(this.definingType.getApexName());
        this.parentCauseType = this.isApexBaseException ? InternalTypeInfos.THROWABLE : TypeInfos.EXCEPTION;
        this.constructorModifiers = ModifierGroup.builder().addModifiers(ModifierTypeInfos.EXPLICIT_STATEMENT_EXECUTED, ModifierTypeInfos.GLOBAL).setLoc(this.definingType.getModifiers().getLoc()).build();
        this.methodModifiers = this.createMethodModifiers();
    }

    private static Emit createPutMessage(boolean hasMessage) {
        return emitter -> {
            TypeInfo type = emitter.getType();
            emitter.emitVar(Loc._SyntheticLoc(), 25, 0);
            if (hasMessage) {
                emitter.emitVar(Loc._SyntheticLoc(), 25, 1);
            } else {
                emitter.push(Loc._SyntheticLoc(), DEFAULT_MESSAGE);
            }
            emitter.emitField(Loc._SyntheticLoc(), 181, type.getBytecodeName(), EXCEPTION_DETAIL_MESSAGE_FIELD_NAME, TypeInfos.STRING.getTypeSignature());
        };
    }

    private Statement createStatement(final Emit body, final boolean hasMessage) {
        return new ConstructorPreambleStatement(this, this.loc, Statement.NOOP){

            @Override
            public void emit(Emitter emitter) {
                if (!UserExceptionMethods.this.isApexBaseException) {
                    SystemModeEmit.builder().setType(UserExceptionMethods.this.definingType).setBody(body).build().emit(emitter);
                } else {
                    body.emit(emitter);
                }
                super.emit(emitter);
                if (UserExceptionMethods.this.isApexBaseException) {
                    if (hasMessage) {
                        PUT_MESSAGE.emit(emitter);
                    } else {
                        PUT_DEFAULT_MESSAGE.emit(emitter);
                    }
                }
                emitter.emit(Loc._SyntheticLoc(), 177);
            }
        };
    }

    private Method noneConstructor() {
        Statement root = this.createStatement(emitter -> {
            emitter.emitVar(Loc._SyntheticLoc(), 25, 0);
            emitter.push(Loc._SyntheticLoc(), DEFAULT_MESSAGE);
            emitter.emit(Loc._SyntheticLoc(), ObjectMethods.constructor(this.definingType.parents().superType(), TypeInfos.STRING));
        }, false);
        return MethodFactory.create(this, StandardMethodInfo.builder().setDefiningType(this.definingType).setConstructor().setName("<init>").setModifiers(this.constructorModifiers).setGenerated(Generated.ANONYMOUS_PROXIED), root);
    }

    private Method messageConstructor() {
        Statement root = this.createStatement(emitter -> {
            emitter.emitVar(Loc._SyntheticLoc(), 25, 0);
            emitter.emitVar(Loc._SyntheticLoc(), 25, 1);
            emitter.emit(Loc._SyntheticLoc(), ObjectMethods.constructor(this.definingType.parents().superType(), TypeInfos.STRING));
        }, true);
        return MethodFactory.create(this, StandardMethodInfo.builder().setDefiningType(this.definingType).setConstructor().setHiddenParameterTypes(TypeInfos.STRING).setName("<init>").setModifiers(this.constructorModifiers).setGenerated(Generated.ANONYMOUS_PROXIED), root);
    }

    private Method causeConstructor() {
        Statement root = this.createStatement(emitter -> {
            emitter.emitVar(Loc._SyntheticLoc(), 25, 0);
            emitter.push(Loc._SyntheticLoc(), DEFAULT_MESSAGE);
            emitter.emitVar(Loc._SyntheticLoc(), 25, 1);
            emitter.emit(Loc._SyntheticLoc(), ObjectMethods.constructor(this.definingType.parents().superType(), TypeInfos.STRING, this.parentCauseType));
        }, false);
        return MethodFactory.create(this, StandardMethodInfo.builder().setDefiningType(this.definingType).setConstructor().setHiddenParameterTypes(TypeInfos.EXCEPTION).setName("<init>").setModifiers(this.constructorModifiers).setGenerated(Generated.ANONYMOUS_PROXIED), root);
    }

    private Method messageCauseConstructor() {
        Statement root = this.createStatement(emitter -> {
            emitter.emitVar(Loc._SyntheticLoc(), 25, 0);
            emitter.emitVar(Loc._SyntheticLoc(), 25, 1);
            emitter.emitVar(Loc._SyntheticLoc(), 25, 2);
            emitter.emit(Loc._SyntheticLoc(), ObjectMethods.constructor(this.definingType.parents().superType(), TypeInfos.STRING, this.parentCauseType));
        }, true);
        return MethodFactory.create(this, StandardMethodInfo.builder().setDefiningType(this.definingType).setConstructor().setHiddenParameterTypes(TypeInfos.STRING, TypeInfos.EXCEPTION).setName("<init>").setModifiers(this.constructorModifiers).setGenerated(Generated.ANONYMOUS_PROXIED), root);
    }

    private Method initCause(ModifierGroup methodModifiers) {
        SimpleStatement root = new SimpleStatement(this, SimpleStatement.Returnable.YES){

            @Override
            public void emit(Emitter emitter) {
                Label branch = new Label();
                emitter.emitVar(Loc._SyntheticLoc(), 25, 0);
                emitter.emit(Loc._SyntheticLoc(), ThrowableMethods.getCause());
                emitter.emitJump(Loc._SyntheticLoc(), 198, branch);
                emitter.emit(Loc._SyntheticLoc(), SystemMethods.throwCauseAlreadySet());
                emitter.emit(branch);
                emitter.emitVar(Loc._SyntheticLoc(), 25, 0);
                emitter.emitVar(Loc._SyntheticLoc(), 25, 1);
                emitter.emit(Loc._SyntheticLoc(), ThrowableMethods.initCause());
                emitter.emit(Loc._SyntheticLoc(), 87);
                emitter.emit(Loc._SyntheticLoc(), 177);
            }
        };
        return MethodFactory.create(this, StandardMethodInfo.builder().setDefiningType(this.definingType).setReturnType(TypeInfos.VOID).setParameters(Parameter.builder().setName("cause").setType(TypeInfos.EXCEPTION).setDefiningType(this.definingType).build()).setName("initCause").setModifiers(methodModifiers).setGenerated(Generated.ANONYMOUS), root);
    }

    private Method getCause(ModifierGroup methodModifiers) {
        SimpleStatement root = new SimpleStatement(this){

            @Override
            public void emit(Emitter emitter) {
                emitter.emitVar(Loc._SyntheticLoc(), 25, 0);
                emitter.emit(Loc._SyntheticLoc(), ThrowableMethods.getCause());
                emitter.emit(Loc._SyntheticLoc(), 176);
            }
        };
        return MethodFactory.create(this, StandardMethodInfo.builder().setDefiningType(this.definingType).setReturnType(TypeInfos.EXCEPTION).setName("getCause").setModifiers(methodModifiers).setGenerated(Generated.ANONYMOUS), root);
    }

    private Method getTypeName(ModifierGroup methodModifiers) {
        SimpleStatement root = new SimpleStatement(this){

            @Override
            public void emit(Emitter emitter) {
                emitter.push(Loc._SyntheticLoc(), UserExceptionMethods.this.definingType.getApexName());
                emitter.emit(Loc._SyntheticLoc(), 176);
            }
        };
        return MethodFactory.create(this, StandardMethodInfo.builder().setDefiningType(this.definingType).setReturnType(TypeInfos.STRING).setName("getTypeName").setModifiers(methodModifiers).setGenerated(Generated.ANONYMOUS), root);
    }

    public void createMethods(SymbolScope scope) {
        ImmutableList.Builder builder = ImmutableList.builder();
        boolean isFileBased = this.definingType.getCodeUnitDetails().isFileBased();
        MethodInfo method = this.definingType.methods().get(NONE);
        if (method == null) {
            builder.add(this.noneConstructor());
        } else if (!isFileBased) {
            scope.getErrors().markInvalid((AstNode)this, method.getLoc(), I18nSupport.getLabel("invalid.exception.constructor.already.defined", NONE));
        }
        method = this.definingType.methods().get(MESSAGE);
        if (method == null) {
            builder.add(this.messageConstructor());
        } else if (!isFileBased) {
            scope.getErrors().markInvalid((AstNode)this, method.getLoc(), I18nSupport.getLabel("invalid.exception.constructor.already.defined", MESSAGE));
        }
        method = this.definingType.methods().get(CAUSE);
        if (method == null) {
            builder.add(this.causeConstructor());
        } else if (!isFileBased) {
            scope.getErrors().markInvalid((AstNode)this, method.getLoc(), I18nSupport.getLabel("invalid.exception.constructor.already.defined", CAUSE));
        }
        method = this.definingType.methods().get(MESSAGE_CAUSE);
        if (method == null) {
            builder.add(this.messageCauseConstructor());
        } else if (!isFileBased) {
            scope.getErrors().markInvalid((AstNode)this, method.getLoc(), I18nSupport.getLabel("invalid.exception.constructor.already.defined", MESSAGE_CAUSE));
        }
        if (this.isApexBaseException) {
            builder.add(new Method[]{this.initCause(this.methodModifiers), this.getCause(this.methodModifiers)});
        }
        builder.add(this.getTypeName(this.methodModifiers));
        this.methods = builder.build();
    }

    private ModifierGroup createMethodModifiers() {
        ModifierGroupBuilder builder = ModifierGroup.builder().addModifiers(this.definingType.getModifiers().has(ModifierTypeInfos.GLOBAL) ? ModifierTypeInfos.GLOBAL : ModifierTypeInfos.PUBLIC, ModifierTypeInfos.EXPLICIT_STATEMENT_EXECUTED, ModifierTypeInfos.OVERRIDE, ModifierTypeInfos.VIRTUAL).setLoc(this.definingType.getModifiers().getLoc());
        if (this.isApexBaseException) {
            builder.addAnnotation(Annotations.APEX_SFDC_ONLY_FALSE);
        }
        return builder.build().resolve();
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope) && this.methods != null) {
            for (Method method : this.methods) {
                method.traverse(visitor, scope);
            }
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        if (scope.getErrors().isInvalid((AstNode)this)) {
            return;
        }
        for (Method method : this.methods) {
            method.validate(symbols, scope);
        }
    }

    @Override
    public Loc getLoc() {
        throw new UnexpectedCodePathException();
    }

    @Override
    public void emit(Emitter emitter) {
        for (Method method : this.methods) {
            method.emit(emitter);
        }
    }

    @Override
    public TypeInfo getDefiningType() {
        return this.definingType;
    }
}

