/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.compilation;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.CompilationUnit;
import apex.jorje.data.ast.EnumDecl;
import apex.jorje.data.ast.Identifier;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodeFactory;
import apex.jorje.semantic.ast.AstNodeUtil;
import apex.jorje.semantic.ast.compilation.AdditionalInfo;
import apex.jorje.semantic.ast.compilation.Compilation;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.context.TypeStack;
import apex.jorje.semantic.ast.member.Field;
import apex.jorje.semantic.ast.member.FieldFactory;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.member.MethodFactory;
import apex.jorje.semantic.ast.member.Parameter;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.ModifierNode;
import apex.jorje.semantic.ast.modifier.rule.AnnotationRuleUtil;
import apex.jorje.semantic.ast.statement.SimpleStatement;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.ClassMethods;
import apex.jorje.semantic.bcl.EnumMethods;
import apex.jorje.semantic.bcl.ListMethods;
import apex.jorje.semantic.bcl.ObjectMethods;
import apex.jorje.semantic.compiler.CompilationOutput;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.symbol.member.IdentifierValidator;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfo;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.GenericTypeInfoFactory;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.StandardTypeInfoImpl;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class UserEnum
extends Compilation {
    private final Identifier name;
    private final TypeInfo enumType;
    private final ModifierGroup enumModifiers;
    private final List<Identifier> enums;
    private final List<Field> fields;
    private final List<Method> methods;
    private final AdditionalInfo additionalInfo;
    private final ModifierNode modifiers;

    public UserEnum(SourceFile source, AstNode definingNode, CompilationUnit.EnumDeclUnit compilationUnit) {
        EnumDecl body = compilationUnit.body;
        this.name = body.name;
        this.enumType = ((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setFileBase(source, AstNodeUtil.getDefiningType(definingNode), compilationUnit)).build();
        this.enumModifiers = this.enumType.getModifiers().copy().addModifiers(ModifierTypeInfos.FINAL, ModifierTypeInfos.STATIC).build();
        this.enums = ImmutableList.copyOf(AstNodeFactory.filterNotNull(body.members.values));
        this.fields = FieldFactory.createEnumFields(this, this.enumModifiers, this.enums);
        this.methods = ImmutableList.of(this.createClinit(), this.createInit(), this.createValues(), this.createValueOf(), this.createOrdinal(), this.createEquals(), this.createHashCode());
        this.additionalInfo = AdditionalInfo.builder().setDefiningType(this.enumType).build();
        this.modifiers = new ModifierNode(this, this.enumType.getModifiers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        scope.push(this);
        try {
            if (visitor.visit(this, scope)) {
                this.modifiers.traverse(visitor, scope);
                for (Field field : this.fields) {
                    field.traverse(visitor, scope);
                }
                for (Method method : this.methods) {
                    method.traverse(visitor, scope);
                }
                this.additionalInfo.traverse(visitor, scope);
            }
            visitor.visitEnd(this, scope);
        }
        finally {
            scope.pop(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        scope.push(this);
        try {
            scope.getErrors().addIfError(this, AnnotationRuleUtil.validateHasTopLevelModifiers(this));
            scope.getErrors().addIfError((AstNode)this, this.name.loc, IdentifierValidator.get().validate(this.enumType, this.name, IdentifierValidator.Type.ENUM, TypeInfoUtil.isTopLevel(this.enumType)));
            if (scope.getErrors().isInvalid((AstNode)this)) {
                return;
            }
            for (Field field : this.fields) {
                field.validate(symbols, scope);
            }
            for (Method method : this.methods) {
                method.validate(symbols, scope);
            }
            this.additionalInfo.validate(symbols, scope);
            this.modifiers.validate(symbols, scope);
        }
        finally {
            scope.pop(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void emit(Emitter emitter) {
        TypeStack.TypeContext clazz = TypeStack.TypeContext.builder().setType(this.enumType).build();
        emitter.getTypeStack().push(clazz);
        try {
            emitter.getAnnotationVisitor().set(clazz.getClassWriter());
            this.modifiers.emit(emitter);
            emitter.getAnnotationVisitor().unset();
            for (Field field : this.fields) {
                field.emit(emitter);
            }
            for (Method method : this.methods) {
                method.emit(emitter);
            }
            this.additionalInfo.emit(emitter);
        }
        finally {
            emitter.getTypeStack().pop();
            this.setOutput(CompilationOutput.builder(this.enumType).setBytes(clazz.getClassWriter().toByteArray()).setLines(clazz.getKnownCodeLocations()).build());
        }
    }

    private Method createClinit() {
        SimpleStatement root = new SimpleStatement(this, SimpleStatement.Returnable.NO){

            @Override
            public void emit(Emitter emitter) {
                int i = 0;
                for (Identifier name : UserEnum.this.enums) {
                    emitter.emitType(Loc._SyntheticLoc(), 187, UserEnum.this.enumType.getBytecodeName());
                    emitter.emit(Loc._SyntheticLoc(), 89);
                    emitter.push(Loc._SyntheticLoc(), name.value);
                    emitter.push(Loc._SyntheticLoc(), i++);
                    emitter.emit(Loc._SyntheticLoc(), EnumMethods.constructor(UserEnum.this.enumType));
                    emitter.emitField(Loc._SyntheticLoc(), 179, UserEnum.this.enumType.getBytecodeName(), name.value, UserEnum.this.enumType.getTypeSignature());
                }
            }
        };
        ModifierGroup modifiers = ModifierGroup.builder().addModifiers(ModifierTypeInfos.EXPLICIT_STATEMENT_EXECUTED, ModifierTypeInfos.STATIC).build();
        return MethodFactory.create(this, StandardMethodInfo.builder().setDefiningType(this.enumType).setReturnType(TypeInfos.VOID).setName("<clinit>").setModifiers(modifiers).setGenerated(Generated.ANONYMOUS), root);
    }

    private Method createInit() {
        SimpleStatement root = new SimpleStatement(this, SimpleStatement.Returnable.NO){

            @Override
            public void emit(Emitter emitter) {
                emitter.emitVar(Loc._SyntheticLoc(), 25, 0);
                emitter.emitVar(Loc._SyntheticLoc(), 25, 1);
                emitter.emitVar(Loc._SyntheticLoc(), 21, 2);
                emitter.emit(Loc._SyntheticLoc(), EnumMethods.constructor());
            }
        };
        ModifierGroup modifiers = ModifierGroup.builder().addModifiers(ModifierTypeInfos.EXPLICIT_STATEMENT_EXECUTED, ModifierTypeInfos.PRIVATE).build();
        return MethodFactory.create(this, StandardMethodInfo.builder().setDefiningType(this.enumType).setReturnType(TypeInfos.VOID).setName("<init>").setModifiers(modifiers).setGenerated(Generated.ANONYMOUS).setParameters(Parameter.builder().setName("str").setType(TypeInfos.STRING).setDefiningType(this.enumType).build(), Parameter.builder().setName("val").setType(InternalTypeInfos.PRIMITIVE_INTEGER).setDefiningType(this.enumType).build()), root);
    }

    private Method createValues() {
        final GenericTypeInfo list = GenericTypeInfoFactory.createList(this.enumType);
        SimpleStatement root = new SimpleStatement(this){

            @Override
            public void emit(Emitter emitter) {
                emitter.emitType(Loc._SyntheticLoc(), 187, list);
                emitter.emit(Loc._SyntheticLoc(), 89);
                emitter.emit(Loc._SyntheticLoc(), ObjectMethods.constructor(list, new TypeInfo[0]));
                for (Identifier name : UserEnum.this.enums) {
                    emitter.emit(Loc._SyntheticLoc(), 89);
                    emitter.emitField(Loc._SyntheticLoc(), 178, UserEnum.this.enumType.getBytecodeName(), name.value, UserEnum.this.enumType.getTypeSignature());
                    emitter.emit(Loc._SyntheticLoc(), ListMethods.addNoReturn(list));
                }
                emitter.emit(Loc._SyntheticLoc(), 89);
                emitter.emit(Loc._SyntheticLoc(), ListMethods.readonly(list));
                emitter.emit(Loc._SyntheticLoc(), 176);
            }
        };
        return MethodFactory.create(this, StandardMethodInfo.builder().setDefiningType(this.enumType).setReturnType(list).setName("values").setModifiers(this.enumModifiers).setGenerated(Generated.ANONYMOUS), root);
    }

    private Method createValueOf() {
        SimpleStatement root = new SimpleStatement(this){

            @Override
            public void emit(Emitter emitter) {
                emitter.push(Loc._SyntheticLoc(), UserEnum.this.enumType.getBytecodeName());
                emitter.emit(Loc._SyntheticLoc(), ClassMethods.forName());
                emitter.emitVar(Loc._SyntheticLoc(), 25, 0);
                emitter.emit(Loc._SyntheticLoc(), EnumMethods.valueOf(UserEnum.this.enumType));
                emitter.emitType(Loc._SyntheticLoc(), 192, UserEnum.this.enumType);
                emitter.emit(Loc._SyntheticLoc(), 176);
            }
        };
        ModifierGroup modifiers = ModifierGroup.builder().addModifiers(ModifierTypeInfos.EXPLICIT_STATEMENT_EXECUTED, ModifierTypeInfos.PUBLIC, ModifierTypeInfos.STATIC).build();
        return MethodFactory.create(this, StandardMethodInfo.builder().setDefiningType(this.enumType).setReturnType(this.enumType).setName("valueOf").setModifiers(modifiers).setGenerated(Generated.ANONYMOUS).setParameters(Parameter.builder().setName("str").setType(TypeInfos.STRING).setDefiningType(this.enumType).build()), root);
    }

    private Method createOrdinal() {
        SimpleStatement root = new SimpleStatement(this){

            @Override
            public void emit(Emitter emitter) {
                emitter.emitVar(Loc._SyntheticLoc(), 25, 0);
                emitter.emit(Loc._SyntheticLoc(), EnumMethods.ordinal());
                emitter.box(TypeInfos.INTEGER);
                emitter.emit(Loc._SyntheticLoc(), 176);
            }
        };
        ModifierGroup modifiers = ModifierGroup.builder().addModifiers(ModifierTypeInfos.EXPLICIT_STATEMENT_EXECUTED, ModifierTypeInfos.PUBLIC, ModifierTypeInfos.OVERRIDE).build();
        return MethodFactory.create(this, StandardMethodInfo.builder().setDefiningType(this.enumType).setReturnType(TypeInfos.INTEGER).setName("ordinal").setModifiers(modifiers).setGenerated(Generated.ANONYMOUS), root);
    }

    private Method createEquals() {
        SimpleStatement root = new SimpleStatement(this){

            @Override
            public void emit(Emitter emitter) {
                emitter.emitVar(Loc._SyntheticLoc(), 25, 0);
                emitter.emitVar(Loc._SyntheticLoc(), 25, 1);
                emitter.emit(Loc._SyntheticLoc(), ObjectMethods.javaEquals());
                emitter.box(TypeInfos.BOOLEAN);
                emitter.emit(Loc._SyntheticLoc(), 176);
            }
        };
        ModifierGroup modifiers = ModifierGroup.builder().addModifiers(ModifierTypeInfos.EXPLICIT_STATEMENT_EXECUTED).addModifiers(ModifierTypeInfos.GLOBAL).build();
        return MethodFactory.create(this, StandardMethodInfo.builder().setDefiningType(this.enumType).setReturnType(TypeInfos.BOOLEAN).setName("equals").setModifiers(modifiers).setGenerated(Generated.ANONYMOUS).setParameters(Parameter.builder().setName("obj").setType(TypeInfos.OBJECT).setDefiningType(this.enumType).build()), root);
    }

    private Method createHashCode() {
        SimpleStatement root = new SimpleStatement(this){

            @Override
            public void emit(Emitter emitter) {
                emitter.emitVar(Loc._SyntheticLoc(), 25, 0);
                emitter.emit(Loc._SyntheticLoc(), ObjectMethods.javaHashCode());
                emitter.box(TypeInfos.INTEGER);
                emitter.emit(Loc._SyntheticLoc(), 176);
            }
        };
        ModifierGroup modifiers = ModifierGroup.builder().addModifiers(ModifierTypeInfos.EXPLICIT_STATEMENT_EXECUTED).addModifiers(ModifierTypeInfos.GLOBAL).build();
        return MethodFactory.create(this, StandardMethodInfo.builder().setDefiningType(this.enumType).setReturnType(TypeInfos.INTEGER).setName("hashCode").setModifiers(modifiers).setGenerated(Generated.ANONYMOUS), root);
    }

    @Override
    public Loc getLoc() {
        return this.name.loc;
    }

    public ModifierNode getModifiers() {
        return this.modifiers;
    }

    @Override
    public TypeInfo getDefiningType() {
        return this.enumType;
    }

    public List<Field> getFields() {
        return this.fields;
    }
}

