/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.compilation;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.ClassDecl;
import apex.jorje.data.ast.CompilationUnit;
import apex.jorje.data.ast.Identifier;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodeUtil;
import apex.jorje.semantic.ast.compilation.AdditionalInfo;
import apex.jorje.semantic.ast.compilation.ArgumentTypeCalculator;
import apex.jorje.semantic.ast.compilation.Compilation;
import apex.jorje.semantic.ast.compilation.ConstructorPreamble;
import apex.jorje.semantic.ast.compilation.UserClassMembers;
import apex.jorje.semantic.ast.compilation.UserClassMethods;
import apex.jorje.semantic.ast.compilation.UserExceptionMethods;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.context.TypeStack;
import apex.jorje.semantic.ast.member.Field;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.member.Property;
import apex.jorje.semantic.ast.member.bridge.BridgeMethodCreator;
import apex.jorje.semantic.ast.modifier.ModifierNode;
import apex.jorje.semantic.ast.modifier.rule.AnnotationRuleUtil;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.compiler.CompilationOutput;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.member.IdentifierValidator;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.AbstractTypeInfo;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.StandardTypeInfoImpl;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import apex.jorje.semantic.symbol.type.naming.TypeNameUtil;
import apex.jorje.services.I18nSupport;
import java.util.List;
import java.util.Optional;

public class UserClass
extends Compilation {
    private final TypeInfo classType;
    private final UserClassMembers members;
    private final AstNode additionalMethods;
    private final AstNode bridgeMethods;
    private final AstNode preamble;
    private final AdditionalInfo additionalInfo;
    private final ModifierNode modifiers;
    private final Identifier name;
    private final Optional<TypeRef> parentTypeRef;

    public UserClass(Errors errors, SourceFile source, AstNode definingNode, CompilationUnit.ClassDeclUnit compilationUnit) {
        ClassDecl body = compilationUnit.body;
        this.name = compilationUnit.body.name;
        this.parentTypeRef = compilationUnit.body.superClass;
        List<TypeInfo> argumentTypeInfos = ArgumentTypeCalculator.get().toArgumentTypes(errors, this, compilationUnit.body.formalTypeArguments);
        StandardTypeInfoImpl.Builder builder = argumentTypeInfos.isEmpty() ? StandardTypeInfoImpl.builder() : GenericTypeInfo.builder().setTypeArguments(argumentTypeInfos);
        this.classType = ((AbstractTypeInfo.Builder)builder.setFileBase(source, AstNodeUtil.getDefiningType(definingNode), compilationUnit)).build();
        this.members = UserClassMembers.create(this, errors, source, definingNode, this.classType, compilationUnit.body);
        this.preamble = new ConstructorPreamble(this, this.members.getStatements());
        this.additionalMethods = TypeNameUtil.isException(this.classType.getApexName()) ? new UserExceptionMethods(this, body.loc) : new UserClassMethods(this, this.name.loc);
        this.bridgeMethods = new BridgeMethodCreator(this, this.members.getMethods());
        this.additionalInfo = AdditionalInfo.builder().setDefiningType(this.classType).setInnerTypes(this.members.getInnerTypes()).setProperties(this.members.getProperties()).build();
        this.modifiers = new ModifierNode(this, this.classType.getModifiers());
    }

    public Optional<TypeRef> getParentTypeRef() {
        return this.parentTypeRef;
    }

    public List<Statement> getStatements() {
        return this.members.getStatements();
    }

    public ModifierNode getModifiers() {
        return this.modifiers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        scope.push(this);
        try {
            if (visitor.visit(this, scope)) {
                this.modifiers.traverse(visitor, scope);
                for (Compilation innerType : this.members.getInnerTypes()) {
                    innerType.traverse(visitor, scope);
                }
                for (Field field : this.members.getFields()) {
                    field.traverse(visitor, scope);
                }
                for (Property property : this.members.getProperties()) {
                    property.traverse(visitor, scope);
                }
                this.preamble.traverse(visitor, scope);
                for (Method method : this.members.getMethods()) {
                    method.traverse(visitor, scope);
                }
                this.additionalMethods.traverse(visitor, scope);
                this.bridgeMethods.traverse(visitor, scope);
                this.additionalInfo.traverse(visitor, scope);
            }
            visitor.visitEnd(this, scope);
        }
        finally {
            scope.pop(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        scope.push(this);
        try {
            scope.getErrors().addIfError(this, AnnotationRuleUtil.validateHasTopLevelModifiers(this));
            scope.getErrors().addIfError((AstNode)this, this.name.loc, IdentifierValidator.get().validate(this.classType, this.name, IdentifierValidator.Type.CLASS, TypeInfoUtil.isTopLevel(this.classType)));
            if (scope.getErrors().isInvalid((AstNode)this)) {
                return;
            }
            for (Compilation innerType : this.members.getInnerTypes()) {
                innerType.validate(symbols, scope);
            }
            for (Property property : this.members.getProperties()) {
                property.validate(symbols, scope);
            }
            for (Field field : this.members.getFields()) {
                field.validate(symbols, scope);
            }
            this.preamble.validate(symbols, scope);
            for (Method method : this.members.getMethods()) {
                method.validate(symbols, scope);
            }
            this.additionalMethods.validate(symbols, scope);
            this.bridgeMethods.validate(symbols, scope);
            this.additionalInfo.validate(symbols, scope);
            this.modifiers.validate(symbols, scope);
        }
        finally {
            scope.pop(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void emit(Emitter emitter) {
        CompilationOutput.Builder output = CompilationOutput.builder(this.classType);
        TypeStack.TypeContext clazz = TypeStack.TypeContext.builder().setType(this.classType).build();
        emitter.getTypeStack().push(clazz);
        try {
            emitter.getAnnotationVisitor().set(clazz.getClassWriter());
            this.modifiers.emit(emitter);
            emitter.getAnnotationVisitor().unset();
            for (Compilation innerType : this.members.getInnerTypes()) {
                innerType.emit(emitter);
                output.addInnerType(innerType);
            }
            for (Field field : this.members.getFields()) {
                field.emit(emitter);
            }
            for (Property property : this.members.getProperties()) {
                property.emit(emitter);
            }
            this.additionalMethods.emit(emitter);
            for (Method method : this.members.getMethods()) {
                method.emit(emitter);
            }
            this.bridgeMethods.emit(emitter);
            this.additionalInfo.emit(emitter);
        }
        finally {
            byte[] bytes;
            try {
                bytes = clazz.getClassWriter().toByteArray();
            }
            catch (RuntimeException x) {
                emitter.getCodeUnit().getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.metadata.too.large"));
                bytes = new byte[]{};
            }
            emitter.getTypeStack().pop();
            this.setOutput(output.setBytes(bytes).setLines(clazz.getKnownCodeLocations()).build());
        }
    }

    @Override
    public TypeInfo getDefiningType() {
        return this.classType;
    }

    @Override
    public Loc getLoc() {
        return this.name.loc;
    }

    public UserClassMembers getMembers() {
        return this.members;
    }
}

