/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.compilation;

import apex.jorje.data.ast.GroupedList;
import apex.jorje.data.ast.TriggerAction;
import apex.jorje.data.ast.TriggerUsage;
import apex.jorje.data.ast.TriggerWhen;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodeFactory;
import apex.jorje.semantic.ast.compilation.UserTrigger;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;

class TriggerUsageCalculator {
    private static final TriggerUsageCalculator INSTANCE = new TriggerUsageCalculator();

    private TriggerUsageCalculator() {
    }

    public static TriggerUsageCalculator get() {
        return INSTANCE;
    }

    public List<apex.jorje.semantic.compiler.TriggerUsage> resolve(final Errors errors, final UserTrigger trigger, GroupedList<TriggerUsage> astUsages) {
        ImmutableList.Builder builder = ImmutableList.builder();
        HashSet<apex.jorje.semantic.compiler.TriggerUsage> duplicate = Sets.newHashSet();
        for (final TriggerUsage astUsage : AstNodeFactory.filterNotNull(astUsages.values)) {
            if (astUsage.when == null || astUsage.action == null) continue;
            apex.jorje.semantic.compiler.TriggerUsage usage = astUsage.when.match(new TriggerWhen.MatchBlock<apex.jorje.semantic.compiler.TriggerUsage>(){

                @Override
                public apex.jorje.semantic.compiler.TriggerUsage _case(TriggerWhen.TriggerBefore x) {
                    return astUsage.action.match(new TriggerAction.MatchBlock<apex.jorje.semantic.compiler.TriggerUsage>(){

                        @Override
                        public apex.jorje.semantic.compiler.TriggerUsage _case(TriggerAction.TriggerInsert x) {
                            return apex.jorje.semantic.compiler.TriggerUsage.BEFORE_INSERT;
                        }

                        @Override
                        public apex.jorje.semantic.compiler.TriggerUsage _case(TriggerAction.TriggerUpdate x) {
                            return apex.jorje.semantic.compiler.TriggerUsage.BEFORE_UPDATE;
                        }

                        @Override
                        public apex.jorje.semantic.compiler.TriggerUsage _case(TriggerAction.TriggerDelete x) {
                            return apex.jorje.semantic.compiler.TriggerUsage.BEFORE_DELETE;
                        }

                        @Override
                        public apex.jorje.semantic.compiler.TriggerUsage _case(TriggerAction.TriggerUndelete x) {
                            errors.markInvalid((AstNode)trigger, Location.from(astUsage), I18nSupport.getLabel("invalid.trigger.before.undelete"));
                            return null;
                        }
                    });
                }

                @Override
                public apex.jorje.semantic.compiler.TriggerUsage _case(TriggerWhen.TriggerAfter x) {
                    return astUsage.action.match(new TriggerAction.MatchBlock<apex.jorje.semantic.compiler.TriggerUsage>(){

                        @Override
                        public apex.jorje.semantic.compiler.TriggerUsage _case(TriggerAction.TriggerInsert x) {
                            return apex.jorje.semantic.compiler.TriggerUsage.AFTER_INSERT;
                        }

                        @Override
                        public apex.jorje.semantic.compiler.TriggerUsage _case(TriggerAction.TriggerUpdate x) {
                            return apex.jorje.semantic.compiler.TriggerUsage.AFTER_UPDATE;
                        }

                        @Override
                        public apex.jorje.semantic.compiler.TriggerUsage _case(TriggerAction.TriggerDelete x) {
                            return apex.jorje.semantic.compiler.TriggerUsage.AFTER_DELETE;
                        }

                        @Override
                        public apex.jorje.semantic.compiler.TriggerUsage _case(TriggerAction.TriggerUndelete x) {
                            return apex.jorje.semantic.compiler.TriggerUsage.AFTER_UNDELETE;
                        }
                    });
                }
            });
            if (duplicate.contains((Object)usage)) {
                errors.markInvalid((AstNode)trigger, Location.from(astUsage), I18nSupport.getLabel("invalid.duplicate.trigger.usage", new Object[]{usage}));
                continue;
            }
            if (usage == null) continue;
            duplicate.add(usage);
            builder.add((Object)usage);
        }
        return builder.build();
    }
}

