/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.compilation;

import apex.jorje.data.JadtFactory;
import apex.jorje.data.JadtTester;
import apex.jorje.data.ast.GroupedList;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.compilation.ArgumentTypeCalculator;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.type.ArgumentTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.tester.matchers.IsType;
import java.util.List;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ArgumentTypeCalculatorTest {
    private Errors errors;
    @Mock
    private AstNode node;

    @BeforeMethod
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.errors = new Errors();
    }

    @Test
    public void testArgumentTypes() {
        List<TypeInfo> actual = ArgumentTypeCalculator.get().toArgumentTypes(this.errors, this.node, Optional.of(GroupedList._GroupedList(JadtTester.NO_LOC, JadtFactory.identifiers("T", "U"))));
        MatcherAssert.assertThat(actual, IsType.containsTypes(ArgumentTypeInfos.T, ArgumentTypeInfos.U));
        MatcherAssert.assertThat(this.errors.get(), (Matcher)Matchers.empty());
    }

    @Test
    public void testArgumentTypeWithErrors() {
        List<TypeInfo> actual = ArgumentTypeCalculator.get().toArgumentTypes(this.errors, this.node, Optional.of(GroupedList._GroupedList(JadtTester.NO_LOC, JadtFactory.identifiers("T", "T", "U"))));
        MatcherAssert.assertThat(actual, IsType.containsTypes(ArgumentTypeInfos.T, ArgumentTypeInfos.U));
        MatcherAssert.assertThat(this.errors.get(), (Matcher)Matchers.hasSize((int)1));
    }
}

