/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.compilation;

import apex.jorje.data.ast.GroupedList;
import apex.jorje.data.ast.Identifier;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.common.iterable.CaseInsensitiveList;
import apex.jorje.semantic.common.iterable.MoreIterables;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.type.ArgumentTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import java.util.List;
import java.util.Optional;

public class ArgumentTypeCalculator {
    private static final ArgumentTypeCalculator INSTANCE = new ArgumentTypeCalculator();

    private ArgumentTypeCalculator() {
    }

    public static ArgumentTypeCalculator get() {
        return INSTANCE;
    }

    public List<TypeInfo> toArgumentTypes(Errors errors, AstNode node, Optional<GroupedList<Identifier>> formalTypeArguments) {
        CaseInsensitiveList names = new CaseInsensitiveList();
        formalTypeArguments.ifPresent(value -> value.values.forEach(identifier -> {
            if (names.contains(identifier.value)) {
                errors.markInvalid(node, identifier.loc, "Duplicate type parameter: " + identifier.value);
            } else {
                names.add(identifier.value);
            }
        }));
        return names.stream().map(ArgumentTypeInfo::create).collect(MoreIterables.toUnmodifiableList(names.size()));
    }
}

