/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.compilation;

import apex.jorje.data.Loc;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.Emit;
import apex.jorje.semantic.ast.compilation.Compilation;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.context.TypeStack;
import apex.jorje.semantic.ast.member.Property;
import apex.jorje.semantic.ast.member.PropertyInfo;
import apex.jorje.semantic.ast.modifier.SharingType;
import apex.jorje.semantic.ast.modifier.SharingTypeCalculator;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.common.iterable.MoreIterables;
import apex.jorje.semantic.common.iterator.BitSetIterator;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.common.GenericTypeInfoUtil;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import apex.jorje.semantic.symbol.visibility.Visibility;
import apex.jorje.services.I18nSupport;
import com.google.common.base.Strings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import org.apache.axis.encoding.Base64;
import shaded.org.objectweb.asm.AnnotationVisitor;

class AdditionalInfo
implements AstNode {
    static final String INNER_TYPES = "__sfdcInnerTypes";
    static final String PROPERTIES = "__sfdcProperties";
    static final String PARAMETERIZED_TYPES = "__sfdcParameterizedTypes";
    static final String ADDITIONAL_CODE_LOCATIONS = "_sfdcAdditionalCodeLocations";
    static final String SUPPRESSED_CODE_LOCATIONS = "_sfdcSuppressedCodeLocations";
    static final int MODIFIERS = 26;
    static final String ALL_PACKAGE_ID = "pacAllPackageId";
    static final String WITH_SHARING_TYPE = "withSharingType";
    private final TypeInfo type;
    private final List<Compilation> innerTypes;
    private final List<Property> properties;

    private AdditionalInfo(Builder builder) {
        this.type = builder.definingType;
        this.properties = builder.properties;
        this.innerTypes = builder.innerTypes;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        if (GenericTypeInfoUtil.isGenericType(this.type) && !GenericTypeInfoUtil.typeParametersAllowed(symbols.getAccessEvaluator().hasApexParameterizedTypes(), this.type.getCodeUnitDetails())) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("type.parameters.not.supported"));
        }
        Iterable<TypeInfo> thingsToCheckVisibilityFor = this.type.parents().checkSuperVisibility() ? MoreIterables.parentTypes(this.type) : this.type.parents().immediateInterfaces();
        for (TypeInfo parentInterface : thingsToCheckVisibilityFor) {
            if (Visibility.isTypeVisible(symbols.getAccessEvaluator(), this.type, parentInterface, scope.isTestMethod())) continue;
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("type.not.visible", parentInterface));
        }
    }

    @Override
    public void emit(Emitter emitter) {
        String propertiesEncoding = this.encode(emitter, this.createPropertiesString());
        new AdditionalInfoEmit(this, propertiesEncoding, emitter).emit(emitter);
    }

    @Override
    public TypeInfo getDefiningType() {
        return this.type;
    }

    @Override
    public Loc getLoc() {
        return Loc._SyntheticLoc();
    }

    private String encode(Emitter emitter, String value) {
        try {
            if (Strings.isNullOrEmpty(value)) {
                return null;
            }
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            GZIPOutputStream gzipStream = new GZIPOutputStream(stream);
            ObjectOutputStream objectInputStream = new ObjectOutputStream(gzipStream);
            objectInputStream.writeObject(value);
            objectInputStream.close();
            String base64Str = Base64.encode((byte[])stream.toByteArray());
            if (base64Str.length() >= 65536) {
                emitter.getCodeUnit().getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.metadata.too.large"));
                return null;
            }
            return Base64.encode((byte[])stream.toByteArray());
        }
        catch (IOException x) {
            emitter.getCodeUnit().getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("unexpected.error", x.getMessage()));
            return null;
        }
    }

    private String createPropertiesString() {
        if (this.properties.isEmpty()) {
            return null;
        }
        return this.properties.stream().map(Property::getInfo).sorted(PropertyInfo.NAME_COMPARATOR).map(PropertyInfo::encode).collect(Collectors.joining(","));
    }

    private static class AdditionalInfoEmit
    implements Emit {
        private final String propertiesEncoding;
        private final TypeInfo type;
        private final List<Compilation> innerTypes;
        private final String allPackageId;
        private final SharingType sharingType;
        private final TypeStack.TypeContext context;

        public AdditionalInfoEmit(AdditionalInfo info, String propertiesEncoding, Emitter emitter) {
            this.propertiesEncoding = propertiesEncoding;
            this.context = emitter.getTypeStack().peek();
            this.type = info.type;
            this.innerTypes = info.innerTypes;
            this.allPackageId = this.type.getCodeUnitDetails().getSource().getAllPackageId();
            this.sharingType = SharingTypeCalculator.get().resolve(this.type);
        }

        @Override
        public void emit(Emitter emitter) {
            this.write(AdditionalInfo.PROPERTIES, this.propertiesEncoding);
            if (this.type.getUnitType() == UnitType.CLASS) {
                this.emitGenericTypes();
            }
            this.emitInnerTypes();
            this.emitBitSet(AdditionalInfo.ADDITIONAL_CODE_LOCATIONS, this.context.getAdditionalCodeLocations());
            this.emitBitSet(AdditionalInfo.SUPPRESSED_CODE_LOCATIONS, this.context.getSuppressedCodeLocations());
            this.emitAdditionalAnnotation();
        }

        private void emitGenericTypes() {
            boolean hasGenericType = this.type.parents().immediateInterfaces().stream().anyMatch(GenericTypeInfoUtil::isGenericType);
            if (!hasGenericType) {
                return;
            }
            List interfaces = this.type.parents().immediateInterfaces().stream().sorted((t1, t2) -> t1.getBytecodeName().compareTo(t2.getBytecodeName())).collect(MoreIterables.toUnmodifiableList(this.type.parents().immediateInterfaces().size()));
            String value = interfaces.stream().map(interfaceType -> interfaceType.accept(new TypeInfoVisitor.Default<String>(){

                @Override
                protected String _default(TypeInfo type) {
                    return type.getBytecodeName() + "@";
                }

                @Override
                public String visit(GenericTypeInfo type) {
                    String arguments = type.getTypeArguments().stream().map(TypeInfo.TO_BYTECODE_NAME).collect(Collectors.joining(":"));
                    return type.getUnreifiedType().getBytecodeName() + "@" + arguments;
                }
            })).collect(Collectors.joining(","));
            this.write(AdditionalInfo.PARAMETERIZED_TYPES, value);
        }

        private void emitInnerTypes() {
            if (this.innerTypes.isEmpty()) {
                return;
            }
            int enclosingTypeNameLength = this.type.getApexName().length();
            String value = this.innerTypes.stream().map(input -> {
                assert (input.getOutput().getType().getApexName().startsWith(this.type.getApexName() + "."));
                return input.getOutput().getType().getApexName().substring(enclosingTypeNameLength + 1);
            }).sorted().collect(Collectors.joining(","));
            this.write(AdditionalInfo.INNER_TYPES, value);
        }

        private void emitAdditionalAnnotation() {
            HashMap<String, String> params = new HashMap<String, String>();
            if (this.allPackageId != null) {
                params.put(AdditionalInfo.ALL_PACKAGE_ID, this.allPackageId);
            }
            if (this.sharingType != null && this.sharingType != SharingType.INHERIT) {
                params.put(AdditionalInfo.WITH_SHARING_TYPE, this.sharingType.name());
            }
            if (!params.isEmpty()) {
                AnnotationVisitor av = this.context.getClassWriter().visitAnnotation(InternalTypeInfos.SFDC_ADDITIONAL_TYPE.getTypeSignature(), true);
                for (Map.Entry param : params.entrySet()) {
                    av.visit((String)param.getKey(), param.getValue());
                }
                av.visitEnd();
            }
        }

        private void emitBitSet(String name, BitSet bitSet) {
            if (bitSet.isEmpty()) {
                return;
            }
            String value = MoreIterables.toString(new BitSetIterator(bitSet), Collectors.joining(","));
            this.write(name, value);
        }

        private void write(String field, String value) {
            if (value == null) {
                return;
            }
            this.context.getClassWriter().visitField(26, field, TypeInfos.STRING.getTypeSignature(), null, value).visitEnd();
        }
    }

    public static class Builder {
        private List<Compilation> innerTypes = Collections.emptyList();
        private List<Property> properties = Collections.emptyList();
        private TypeInfo definingType;

        private Builder() {
        }

        public AdditionalInfo build() {
            assert (this.definingType != null) : "defining type was not set for additional info";
            return new AdditionalInfo(this);
        }

        public Builder setDefiningType(TypeInfo definingType) {
            this.definingType = definingType;
            return this;
        }

        public Builder setInnerTypes(List<Compilation> innerTypes) {
            this.innerTypes = innerTypes;
            return this;
        }

        public Builder setProperties(List<Property> properties) {
            this.properties = properties;
            return this;
        }
    }
}

