/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast;

import apex.jorje.data.Loc;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.bcl.DateTimeMethods;
import apex.jorje.semantic.bcl.DecimalMethods;
import apex.jorje.semantic.bcl.DoubleMethods;
import apex.jorje.semantic.bcl.IdMethods;
import apex.jorje.semantic.bcl.ListMethods;
import apex.jorje.semantic.bcl.LongMethods;
import apex.jorje.semantic.bcl.StringMethods;
import apex.jorje.semantic.bcl.SystemMethods;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.GenericTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.SObjectTypeInfoUtil;
import apex.jorje.services.Version;
import shaded.org.objectweb.asm.Label;

public class TypeConversion {
    public static void emitOrCheckCast(Loc loc, Emitter emitter, TypeInfo oldType, TypeInfo newType) {
        if (TypeConversion.emit(loc, emitter, oldType, newType).emitCheckCast()) {
            emitter.emitType(loc, 192, TypeConversion.checkCastType(newType));
        }
    }

    public static TypeInfo checkCastType(TypeInfo type) {
        switch (type.getBasicType()) {
            case LIST: 
            case SET: 
            case MAP: {
                return type;
            }
        }
        return GenericTypeInfoUtil.getRootType(type);
    }

    public static Conversion emit(Loc loc, Emitter emitter, TypeInfo oldType, TypeInfo newType) {
        Label branch = new Label();
        if (TypeInfoEquivalence.isEquivalent(newType, TypeInfos.OBJECT)) {
            return emitter.getVersion().isGreaterThanOrEqual(Version.V164) ? Conversion.YES : Conversion.YES_CAST;
        }
        if (TypeInfoEquivalence.isEquivalent(oldType, newType)) {
            return Conversion.NO;
        }
        if (SObjectTypeInfoUtil.isSObjectList(oldType) && newType.getBasicType() == BasicType.SOBJECT) {
            emitter.emit(Loc._SyntheticLoc(), 89);
            emitter.emitJump(Loc._SyntheticLoc(), 198, branch);
            emitter.push(loc, newType.getBytecodeName());
            emitter.emit(loc, ListMethods.getFirstSObjectBytecode());
            emitter.emit(branch);
            return Conversion.YES;
        }
        if (TypeConversion.isCollectionStringToId(oldType, newType) || TypeConversion.isMapStringToId(oldType, newType)) {
            emitter.emit(Loc._SyntheticLoc(), 89);
            emitter.push(Loc._SyntheticLoc(), newType.getBytecodeName());
            emitter.emit(Loc._SyntheticLoc(), SystemMethods.instanceOf());
            emitter.emit(Loc._SyntheticLoc(), 87);
            return Conversion.YES;
        }
        switch (oldType.getBasicType()) {
            case DECIMAL: {
                switch (newType.getBasicType()) {
                    case DOUBLE: {
                        emitter.emit(loc, 89);
                        emitter.emitJump(loc, 198, branch);
                        emitter.emit(loc, DecimalMethods.doubleValue());
                        emitter.emit(branch);
                        return Conversion.YES;
                    }
                    case LONG: {
                        emitter.emit(loc, 89);
                        emitter.emitJump(loc, 198, branch);
                        emitter.emit(loc, DecimalMethods.longValue());
                        emitter.emit(branch);
                        return Conversion.YES;
                    }
                    case INTEGER: {
                        emitter.emit(loc, 89);
                        emitter.emitJump(loc, 198, branch);
                        emitter.emit(loc, DecimalMethods.intValue());
                        emitter.emit(branch);
                        return Conversion.YES;
                    }
                }
                break;
            }
            case DOUBLE: {
                switch (newType.getBasicType()) {
                    case DECIMAL: {
                        emitter.emit(loc, DecimalMethods.valueOfNullOkDouble());
                        return Conversion.YES;
                    }
                    case LONG: {
                        emitter.emit(loc, 89);
                        emitter.emitJump(loc, 198, branch);
                        emitter.unbox(oldType);
                        emitter.emit(loc, 143);
                        emitter.box(newType);
                        emitter.emit(branch);
                        return Conversion.YES;
                    }
                    case INTEGER: {
                        emitter.emit(loc, 89);
                        emitter.emitJump(loc, 198, branch);
                        emitter.emit(loc, DoubleMethods.intValue());
                        emitter.emit(branch);
                        return Conversion.YES;
                    }
                }
                break;
            }
            case LONG: {
                switch (newType.getBasicType()) {
                    case DECIMAL: {
                        emitter.emit(loc, DecimalMethods.valueOfLong());
                        return Conversion.YES;
                    }
                    case DOUBLE: {
                        emitter.emit(loc, 89);
                        emitter.emitJump(loc, 198, branch);
                        emitter.unbox(oldType);
                        emitter.emit(loc, 138);
                        emitter.box(newType);
                        emitter.emit(branch);
                        return Conversion.YES;
                    }
                    case INTEGER: {
                        emitter.emit(loc, 89);
                        emitter.emitJump(loc, 198, branch);
                        emitter.emit(loc, LongMethods.intValue());
                        emitter.emit(branch);
                        return Conversion.YES;
                    }
                }
                break;
            }
            case INTEGER: {
                switch (newType.getBasicType()) {
                    case DECIMAL: {
                        emitter.emit(loc, DecimalMethods.valueOfNullOk());
                        return Conversion.YES;
                    }
                    case DOUBLE: {
                        emitter.emit(loc, 89);
                        emitter.emitJump(loc, 198, branch);
                        emitter.unbox(oldType);
                        emitter.emit(loc, 135);
                        emitter.box(newType);
                        emitter.emit(branch);
                        return Conversion.YES;
                    }
                    case LONG: {
                        emitter.emit(loc, 89);
                        emitter.emitJump(loc, 198, branch);
                        emitter.unbox(oldType);
                        emitter.emit(loc, 133);
                        emitter.box(newType);
                        emitter.emit(branch);
                        return Conversion.YES;
                    }
                }
                break;
            }
            case OBJECT: {
                switch (newType.getBasicType()) {
                    case DOUBLE: 
                    case LONG: 
                    case INTEGER: 
                    case DECIMAL: 
                    case DATE: 
                    case DATE_TIME: 
                    case STRING: {
                        emitter.push(loc, newType.getBytecodeName());
                        emitter.emit(loc, SystemMethods.convert());
                        return Conversion.YES;
                    }
                    case ID: {
                        emitter.emit(loc, IdMethods.valueOfNullOk());
                        return Conversion.YES;
                    }
                }
                break;
            }
            case DATE: {
                switch (newType.getBasicType()) {
                    case DATE_TIME: {
                        emitter.emit(loc, DateTimeMethods.newInstance());
                        return Conversion.YES;
                    }
                }
                break;
            }
            case STRING: {
                switch (newType.getBasicType()) {
                    case ID: {
                        emitter.emit(loc, IdMethods.valueOfNullOk());
                        return Conversion.YES;
                    }
                }
                break;
            }
            case ID: {
                switch (newType.getBasicType()) {
                    case STRING: {
                        emitter.emit(loc, StringMethods.valueOfId());
                        return Conversion.YES;
                    }
                }
                break;
            }
            case NULL: {
                switch (newType.getBasicType()) {
                    case ID: {
                        emitter.emit(loc, IdMethods.valueOfNullOk());
                        return Conversion.YES;
                    }
                }
                return Conversion.NO;
            }
        }
        return Conversion.CAST;
    }

    private static boolean isCollectionStringToId(TypeInfo oldType, TypeInfo newType) {
        return (CollectionTypeInfoUtil.isList(oldType) && CollectionTypeInfoUtil.isList(newType) || CollectionTypeInfoUtil.isSet(newType)) && CollectionTypeInfoUtil.isCollection(oldType) && TypeInfoEquivalence.isEquivalent(CollectionTypeInfoUtil.getElementType(oldType), TypeInfos.STRING) && TypeInfoEquivalence.isEquivalent(CollectionTypeInfoUtil.getElementType(newType), TypeInfos.ID);
    }

    private static boolean isMapStringToId(TypeInfo oldType, TypeInfo newType) {
        return oldType.getBasicType() == BasicType.MAP && newType.getBasicType() == BasicType.MAP && TypeInfoEquivalence.isEquivalent(CollectionTypeInfoUtil.getValueType(oldType), TypeInfos.STRING) && TypeInfoEquivalence.isEquivalent(CollectionTypeInfoUtil.getValueType(newType), TypeInfos.ID);
    }

    public static enum Conversion {
        YES(true, false),
        NO(false, false),
        CAST(false, true),
        YES_CAST(true, true);

        private final boolean emittedConversion;
        private final boolean emitCheckCast;

        private Conversion(boolean emittedConversion, boolean emitCheckCast) {
            this.emittedConversion = emittedConversion;
            this.emitCheckCast = emitCheckCast;
        }

        public boolean isEmittedConversion() {
            return this.emittedConversion;
        }

        public boolean emitCheckCast() {
            return this.emitCheckCast;
        }
    }
}

