/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast;

import apex.jorje.data.Loc;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.MethodCallExpression;
import apex.jorje.semantic.bcl.SystemMethods;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import java.util.stream.Collectors;

public enum ProfilingType {
    METHOD,
    SOQL,
    SOSL,
    DML,
    NONE;


    public void emit(Emitter emitter, MethodCallExpression methodCall) {
        this.emit(emitter, methodCall.getLoc(), this.getProfilingName(methodCall));
    }

    public void emit(Emitter emitter, Loc loc, String descriptor) {
        if (this == NONE) {
            return;
        }
        emitter.push(loc, descriptor);
        emitter.push(loc, this.name());
        emitter.emit(loc, SystemMethods.setProfilingInfo());
    }

    private String getProfilingName(MethodCallExpression methodCall) {
        MethodInfo method = methodCall.getMethod();
        return method.getDefiningType().getBytecodeName().replace('/', '.') + "." + method.getName() + methodCall.getInputParameters().stream().map(input -> input.getType().getApexName()).collect(Collectors.joining(", ", "(", ")"));
    }
}

