/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast;

import apex.jorje.data.ast.BlockMember;
import apex.jorje.data.ast.CompilationUnit;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.ForControl;
import apex.jorje.data.ast.GroupedList;
import apex.jorje.data.ast.Modifier;
import apex.jorje.data.ast.ObjectCreator;
import apex.jorje.data.ast.PropertyDecl;
import apex.jorje.data.ast.Stmnt;
import apex.jorje.data.ast.VariableDecl;
import apex.jorje.data.ast.VariableDecls;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.compilation.AnonymousClass;
import apex.jorje.semantic.ast.compilation.Compilation;
import apex.jorje.semantic.ast.compilation.UserClass;
import apex.jorje.semantic.ast.compilation.UserEnum;
import apex.jorje.semantic.ast.compilation.UserInterface;
import apex.jorje.semantic.ast.compilation.UserTrigger;
import apex.jorje.semantic.ast.expression.ArrayLoadExpression;
import apex.jorje.semantic.ast.expression.ArrayStoreExpression;
import apex.jorje.semantic.ast.expression.AssignmentExpression;
import apex.jorje.semantic.ast.expression.BinaryExpression;
import apex.jorje.semantic.ast.expression.BooleanExpression;
import apex.jorje.semantic.ast.expression.ClassRefExpression;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.IllegalStoreExpression;
import apex.jorje.semantic.ast.expression.InstanceOfExpression;
import apex.jorje.semantic.ast.expression.JavaMethodCallExpression;
import apex.jorje.semantic.ast.expression.JavaVariableExpression;
import apex.jorje.semantic.ast.expression.LiteralExpression;
import apex.jorje.semantic.ast.expression.MethodCallExpression;
import apex.jorje.semantic.ast.expression.NestedExpression;
import apex.jorje.semantic.ast.expression.NestedStoreExpression;
import apex.jorje.semantic.ast.expression.NewListInitExpression;
import apex.jorje.semantic.ast.expression.NewListLiteralExpression;
import apex.jorje.semantic.ast.expression.NewMapInitExpression;
import apex.jorje.semantic.ast.expression.NewMapLiteralExpression;
import apex.jorje.semantic.ast.expression.NewNameValueObjectExpression;
import apex.jorje.semantic.ast.expression.NewObjectExpression;
import apex.jorje.semantic.ast.expression.NewSetInitExpression;
import apex.jorje.semantic.ast.expression.NewSetLiteralExpression;
import apex.jorje.semantic.ast.expression.PackageVersionExpression;
import apex.jorje.semantic.ast.expression.PostfixExpression;
import apex.jorje.semantic.ast.expression.PrefixExpression;
import apex.jorje.semantic.ast.expression.SoqlExpression;
import apex.jorje.semantic.ast.expression.SoslExpression;
import apex.jorje.semantic.ast.expression.SuperMethodCallExpression;
import apex.jorje.semantic.ast.expression.SuperVariableExpression;
import apex.jorje.semantic.ast.expression.TernaryExpression;
import apex.jorje.semantic.ast.expression.ThisMethodCallExpression;
import apex.jorje.semantic.ast.expression.ThisVariableExpression;
import apex.jorje.semantic.ast.expression.TriggerVariableExpression;
import apex.jorje.semantic.ast.expression.VariableExpression;
import apex.jorje.semantic.ast.member.Property;
import apex.jorje.semantic.ast.modifier.Annotation;
import apex.jorje.semantic.ast.statement.BlockStatement;
import apex.jorje.semantic.ast.statement.BreakStatement;
import apex.jorje.semantic.ast.statement.ContinueStatement;
import apex.jorje.semantic.ast.statement.DmlDeleteStatement;
import apex.jorje.semantic.ast.statement.DmlInsertStatement;
import apex.jorje.semantic.ast.statement.DmlMergeStatement;
import apex.jorje.semantic.ast.statement.DmlUndeleteStatement;
import apex.jorje.semantic.ast.statement.DmlUpdateStatement;
import apex.jorje.semantic.ast.statement.DmlUpsertStatement;
import apex.jorje.semantic.ast.statement.DoLoopStatement;
import apex.jorje.semantic.ast.statement.ExpressionStatement;
import apex.jorje.semantic.ast.statement.FieldDeclarationStatements;
import apex.jorje.semantic.ast.statement.ForEachStatement;
import apex.jorje.semantic.ast.statement.ForLoopStatement;
import apex.jorje.semantic.ast.statement.IfElseBlockStatement;
import apex.jorje.semantic.ast.statement.ReturnStatement;
import apex.jorje.semantic.ast.statement.RunAsBlockStatement;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.statement.StatementExecuted;
import apex.jorje.semantic.ast.statement.ThrowStatement;
import apex.jorje.semantic.ast.statement.TryCatchFinallyBlockStatement;
import apex.jorje.semantic.ast.statement.VariableDeclarationStatements;
import apex.jorje.semantic.ast.statement.WhileLoopStatement;
import apex.jorje.semantic.common.iterable.MoreIterables;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.exception.Errors;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public final class AstNodeFactory {
    public static final Predicate<VariableDecl> VARIABLE_DECLS_FILTER = variable -> variable != null && variable.name != null;

    private AstNodeFactory() {
    }

    public static Statement create(final AstNode definingNode, Stmnt stmnt) {
        return stmnt == null ? Statement.INVALID : stmnt.match(new Stmnt.MatchBlock<Statement>(){

            @Override
            public Statement _case(Stmnt.BlockStmnt x) {
                return new BlockStatement(definingNode, x);
            }

            @Override
            public Statement _case(Stmnt.ExpressionStmnt x) {
                return new ExpressionStatement(definingNode, x);
            }

            @Override
            public Statement _case(Stmnt.ReturnStmnt x) {
                return new ReturnStatement(definingNode, x);
            }

            @Override
            public Statement _case(Stmnt.ThrowStmnt x) {
                return new ThrowStatement(definingNode, x);
            }

            @Override
            public Statement _case(Stmnt.BreakStmnt x) {
                return new BreakStatement(definingNode, x);
            }

            @Override
            public Statement _case(Stmnt.ContinueStmnt x) {
                return new ContinueStatement(definingNode, x);
            }

            @Override
            public Statement _case(Stmnt.DmlInsertStmnt x) {
                return new DmlInsertStatement(definingNode, x);
            }

            @Override
            public Statement _case(Stmnt.DmlUpdateStmnt x) {
                return new DmlUpdateStatement(definingNode, x);
            }

            @Override
            public Statement _case(Stmnt.DmlUpsertStmnt x) {
                return new DmlUpsertStatement(definingNode, x);
            }

            @Override
            public Statement _case(Stmnt.DmlDeleteStmnt x) {
                return new DmlDeleteStatement(definingNode, x);
            }

            @Override
            public Statement _case(Stmnt.DmlUndeleteStmnt x) {
                return new DmlUndeleteStatement(definingNode, x);
            }

            @Override
            public Statement _case(Stmnt.DmlMergeStmnt x) {
                return new DmlMergeStatement(definingNode, x);
            }

            @Override
            public Statement _case(Stmnt.WhileLoop x) {
                return new WhileLoopStatement(definingNode, x);
            }

            @Override
            public Statement _case(Stmnt.DoLoop x) {
                return new DoLoopStatement(definingNode, x);
            }

            @Override
            public Statement _case(Stmnt.IfElseBlock x) {
                return new IfElseBlockStatement(definingNode, x);
            }

            @Override
            public Statement _case(Stmnt.RunAsBlock x) {
                return new RunAsBlockStatement(definingNode, x);
            }

            @Override
            public Statement _case(Stmnt.TryCatchFinallyBlock x) {
                return new TryCatchFinallyBlockStatement(definingNode, x);
            }

            @Override
            public Statement _case(Stmnt.VariableDeclStmnt x) {
                return new VariableDeclarationStatements(definingNode, x);
            }

            @Override
            public Statement _case(final Stmnt.ForLoop loop) {
                return loop.forControl == null ? Statement.INVALID : loop.forControl.match(new ForControl.MatchBlock<Statement>(){

                    @Override
                    public Statement _case(ForControl.EnhancedForControl x) {
                        return new ForEachStatement(definingNode, loop, x);
                    }

                    @Override
                    public Statement _case(ForControl.CStyleForControl x) {
                        return new ForLoopStatement(definingNode, loop, x);
                    }
                });
            }

            @Override
            public Statement _case(Stmnt.SwitchStatement x) {
                return Statement.INVALID;
            }
        });
    }

    public static Expression create(final AstNode definingNode, Expr expr) {
        return expr == null ? Expression.INVALID : expr.match(new Expr.MatchBlock<Expression>(){

            @Override
            public Expression _case(Expr.AssignmentExpr x) {
                return new AssignmentExpression(definingNode, x);
            }

            @Override
            public Expression _case(Expr.TernaryExpr x) {
                return new TernaryExpression(definingNode, x);
            }

            @Override
            public Expression _case(Expr.PrefixExpr x) {
                return new PrefixExpression(definingNode, x);
            }

            @Override
            public Expression _case(Expr.BinaryExpr x) {
                return new BinaryExpression(definingNode, x);
            }

            @Override
            public Expression _case(Expr.InstanceOf x) {
                return new InstanceOfExpression(definingNode, x);
            }

            @Override
            public Expression _case(Expr.BooleanExpr x) {
                return new BooleanExpression(definingNode, x);
            }

            @Override
            public Expression _case(Expr.TriggerVariableExpr x) {
                return new TriggerVariableExpression(definingNode, x);
            }

            @Override
            public Expression _case(Expr.PackageVersionExpr x) {
                return new PackageVersionExpression(definingNode, x);
            }

            @Override
            public Expression _case(Expr.PostfixExpr x) {
                return new PostfixExpression(definingNode, x);
            }

            @Override
            public Expression _case(Expr.ArrayExpr x) {
                return new ArrayLoadExpression(definingNode, x);
            }

            @Override
            public Expression _case(Expr.VariableExpr x) {
                return VariableExpression.createLoad(definingNode, x);
            }

            @Override
            public Expression _case(Expr.MethodCallExpr x) {
                return new MethodCallExpression(definingNode, x);
            }

            @Override
            public Expression _case(Expr.JavaMethodCallExpr x) {
                return new JavaMethodCallExpression(definingNode, x);
            }

            @Override
            public Expression _case(Expr.JavaVariableExpr x) {
                return new JavaVariableExpression(definingNode, x);
            }

            @Override
            public Expression _case(Expr.SuperMethodCallExpr x) {
                return new SuperMethodCallExpression(definingNode, x);
            }

            @Override
            public Expression _case(Expr.SuperVariableExpr x) {
                return new SuperVariableExpression(definingNode, x);
            }

            @Override
            public Expression _case(Expr.ThisMethodCallExpr x) {
                return new ThisMethodCallExpression(definingNode, x);
            }

            @Override
            public Expression _case(Expr.ThisVariableExpr x) {
                return new ThisVariableExpression(definingNode, x);
            }

            @Override
            public Expression _case(Expr.ClassRefExpr x) {
                return new ClassRefExpression(definingNode, x);
            }

            @Override
            public Expression _case(Expr.LiteralExpr x) {
                return new LiteralExpression(definingNode, x);
            }

            @Override
            public Expression _case(final Expr.NewExpr expr) {
                return expr.creator == null ? Expression.INVALID : expr.creator.match(new ObjectCreator.MatchBlock<Expression>(){

                    @Override
                    public Expression _case(ObjectCreator.ListInitCreator x) {
                        return new NewListInitExpression(definingNode, expr, x);
                    }

                    @Override
                    public Expression _case(ObjectCreator.ListLiteralCreator x) {
                        return new NewListLiteralExpression(definingNode, expr, x);
                    }

                    @Override
                    public Expression _case(ObjectCreator.SetInitCreator x) {
                        return new NewSetInitExpression(definingNode, expr, x);
                    }

                    @Override
                    public Expression _case(ObjectCreator.SetLiteralCreator x) {
                        return new NewSetLiteralExpression(definingNode, expr, x);
                    }

                    @Override
                    public Expression _case(ObjectCreator.MapInitCreator x) {
                        return new NewMapInitExpression(definingNode, expr, x);
                    }

                    @Override
                    public Expression _case(ObjectCreator.MapLiteralCreator x) {
                        return new NewMapLiteralExpression(definingNode, expr, x);
                    }

                    @Override
                    public Expression _case(ObjectCreator.NameValueCreator x) {
                        return new NewNameValueObjectExpression(definingNode, expr, x);
                    }

                    @Override
                    public Expression _case(ObjectCreator.NormalObjectCreator x) {
                        return new NewObjectExpression(definingNode, expr, x);
                    }
                });
            }

            @Override
            public Expression _case(Expr.NestedExpr x) {
                return new NestedExpression(definingNode, x);
            }

            @Override
            public Expression _case(Expr.SoqlExpr x) {
                return new SoqlExpression(definingNode, x);
            }

            @Override
            public Expression _case(Expr.SoslExpr x) {
                return new SoslExpression(definingNode, x);
            }
        });
    }

    public static Compilation create(final Errors errors, final SourceFile source, final AstNode definingType, CompilationUnit unit) {
        return unit == null ? Compilation.INVALID : unit.match(new CompilationUnit.MatchBlock<Compilation>(){

            @Override
            public Compilation _case(CompilationUnit.TriggerDeclUnit x) {
                return new UserTrigger(errors, source, x);
            }

            @Override
            public Compilation _case(CompilationUnit.AnonymousBlockUnit x) {
                return new AnonymousClass(errors, source, x);
            }

            @Override
            public Compilation _case(CompilationUnit.EnumDeclUnit x) {
                return new UserEnum(source, definingType, x);
            }

            @Override
            public Compilation _case(CompilationUnit.ClassDeclUnit x) {
                return new UserClass(errors, source, definingType, x);
            }

            @Override
            public Compilation _case(CompilationUnit.InterfaceDeclUnit x) {
                return new UserInterface(errors, source, definingType, x);
            }

            @Override
            public Compilation _case(CompilationUnit.InvalidDeclUnit x) {
                return Compilation.INVALID;
            }
        });
    }

    public static Property create(Errors errors, AstNode definingNode, PropertyDecl propertyDecl) {
        return new Property(errors, definingNode, propertyDecl);
    }

    public static FieldDeclarationStatements create(AstNode definingNode, VariableDecls variableDecls) {
        return new FieldDeclarationStatements(definingNode, new Stmnt.VariableDeclStmnt(variableDecls));
    }

    public static FieldDeclarationStatements create(AstNode definingNode, BlockMember.PropertyMember property) {
        PropertyDecl propertyDecl = property.propertyDecl;
        return AstNodeFactory.create(definingNode, VariableDecls._VariableDecls(propertyDecl.modifiers, propertyDecl.type, Lists.newArrayList(VariableDecl._VariableDecl(propertyDecl.name, Optional.empty()))));
    }

    public static <T> Collection<T> filterNotNull(Collection<T> collection) {
        return collection == null ? Collections.emptyList() : Collections2.filter(collection, Predicates.notNull());
    }

    public static Annotation create(Modifier.Annotation x) {
        return new Annotation(x);
    }

    public static List<Expression> createExpressions(AstNode definingNode, GroupedList<Expr> x) {
        return x.values.stream().map(expr -> AstNodeFactory.create(definingNode, expr)).collect(MoreIterables.toUnmodifiableList(x.values.size()));
    }

    public static List<Statement> createStatements(AstNode definingNode, GroupedList<Stmnt> x) {
        return x.values.stream().map(stmnt -> AstNodeFactory.create(definingNode, stmnt)).collect(MoreIterables.toUnmodifiableList(x.values.size()));
    }

    public static Statement createLoopStatement(AstNode definingNode, Optional<Stmnt> x) {
        return x == null ? Statement.INVALID : x.map(value -> AstNodeFactory.create(definingNode, value)).orElse(StatementExecuted.createReal(definingNode, definingNode.getLoc(), true, false));
    }

    public static Expression createStore(final AstNode definingNode, Expr expr) {
        return expr == null ? Expression.INVALID : expr.match(new Expr.MatchBlockWithDefault<Expression>(){

            @Override
            public Expression _case(Expr.ArrayExpr x) {
                return new ArrayStoreExpression(definingNode, x);
            }

            @Override
            public Expression _case(Expr.VariableExpr x) {
                return VariableExpression.createStore(definingNode, x);
            }

            @Override
            public Expression _case(Expr.NestedExpr x) {
                return new NestedStoreExpression(definingNode, x);
            }

            @Override
            protected Expression _default(Expr x) {
                return new IllegalStoreExpression(definingNode, x);
            }
        });
    }
}

