/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.parser.impl;

import apex.jorje.parser.impl.BaseApexLexer;
import apex.jorje.services.datetimes.DateTimeFormats;
import com.google.common.collect.ImmutableMap;
import java.time.temporal.Temporal;
import java.util.Map;
import java.util.function.Function;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.RecognizerSharedState;

public class DateTimeToken
extends CommonToken {
    static final Map<Integer, Function<String, Temporal>> TYPE_TO_FORMAT = ImmutableMap.builder().put(41, DateTimeFormats::fromDate).put(179, DateTimeFormats::fromTime).put(43, DateTimeFormats::fromDateTime).build();
    private final Temporal temporal;

    private DateTimeToken(CharStream input, int type, RecognizerSharedState state, int tokenEndCharIndex) {
        super(input, type, 0, state.tokenStartCharIndex, tokenEndCharIndex);
        this.setLine(state.tokenStartLine);
        this.setCharPositionInLine(state.tokenStartCharPositionInLine);
        String rawDateTime = input.substring(state.tokenStartCharIndex, tokenEndCharIndex);
        this.temporal = TYPE_TO_FORMAT.get(type).apply(rawDateTime);
    }

    public static DateTimeToken create(BaseApexLexer.Lexing lexing, CharStream input, RecognizerSharedState state, int tokenEndCharIndex) {
        switch (lexing) {
            case DATE: {
                return new DateTimeToken(input, 41, state, tokenEndCharIndex);
            }
            case DATE_TIME: {
                return new DateTimeToken(input, 43, state, tokenEndCharIndex);
            }
            case TIME: {
                return new DateTimeToken(input, 179, state, tokenEndCharIndex);
            }
        }
        throw new IllegalArgumentException("Invalid type.");
    }

    public Temporal getTemporal() {
        return this.temporal;
    }
}

