/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.parser.impl;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.GroupedList;
import apex.jorje.data.ast.Identifier;
import apex.jorje.data.ast.Literal;
import apex.jorje.data.ast.Stmnt;
import apex.jorje.data.errors.SyntaxError;
import apex.jorje.data.errors.UserError;
import apex.jorje.parser.impl.CustomRecognitionException;
import apex.jorje.parser.impl.ErrorLogger;
import apex.jorje.services.Location;
import apex.jorje.services.Version;
import apex.jorje.services.exception.InternalException;
import apex.jorje.services.exception.ParseException;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.NoViableAltException;
import org.antlr.runtime.Parser;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.RecognizerSharedState;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;

public abstract class BaseApexParser
extends Parser
implements ErrorLogger {
    private List<ParseException> syntaxErrorReporter = Lists.newArrayList();
    private List<InternalException> internalErrorReporter = Lists.newArrayList();
    private Version version = Version.CURRENT;

    public BaseApexParser(TokenStream tokens, RecognizerSharedState state) {
        super(tokens, state);
    }

    protected static <T> TokenPair<T> tokenPair(Token token, T value) {
        return new TokenPair<T>(token, value);
    }

    protected Identifier getIdentifier(Token token) {
        return Identifier._Identifier(this.tokenLoc(token), token.getText());
    }

    protected Token getToken(TokenPair pair) {
        return pair == null ? this.input.LT(1) : pair.token;
    }

    protected <T> T getValue(TokenPair<T> pair) {
        return pair == null ? null : (T)pair.value;
    }

    protected Loc getLoc(GroupedList list) {
        return list == null ? this.tokenLoc(this.input.LT(1)) : list.loc;
    }

    protected <T> List<T> getValue(GroupedList<T> list) {
        return list == null ? Collections.emptyList() : list.values;
    }

    @Override
    public void setSyntaxErrorReporter(List<ParseException> errorReporter) {
        this.syntaxErrorReporter = errorReporter;
    }

    @Override
    public void setInternalErrorReporter(List<InternalException> errorReporter) {
        this.internalErrorReporter = errorReporter;
    }

    @Override
    public List<ParseException> getParseErrors() {
        return this.syntaxErrorReporter;
    }

    @Override
    public List<InternalException> getInternalErrors() {
        return this.internalErrorReporter;
    }

    protected Loc tokenLoc(Token token) {
        return this.tokenLoc(token, token);
    }

    protected Loc tokenLoc(Stmnt stmnt) {
        return stmnt == null ? this.tokenLoc(this.input.LT(1)) : Location.from(stmnt);
    }

    protected Loc tokenLoc(Expr expr, Token endToken) {
        return expr == null ? this.tokenLoc(endToken) : Location.from(Location.from(expr), this.tokenLoc(endToken));
    }

    protected Loc tokenLoc(Token startToken, Token endToken) {
        return this.tokenLoc(startToken, endToken, 0);
    }

    public String toString(Token start, Token stop) {
        Token t;
        if (start == null || stop == null) {
            throw new IllegalArgumentException("Start/stop was null.");
        }
        StringBuilder buf = new StringBuilder();
        for (int i = start.getTokenIndex(); i <= stop.getTokenIndex() && (t = this.input.get(i)).getType() != -1; ++i) {
            if (t.getType() == 168) {
                buf.append("'").append(t.getText()).append("'");
                continue;
            }
            buf.append(t.getText());
        }
        return buf.toString();
    }

    protected Loc tokenLoc(Token startToken, Token endToken, int lengthOffset) {
        int startRow = startToken.getLine();
        int startColumn = startToken.getCharPositionInLine() + 1;
        int startIndex = this.getStartIndex(startToken);
        int endIndex = this.getEndIndex(endToken) + 1 + lengthOffset;
        return Loc._RealLoc(startIndex, endIndex, startRow, startColumn);
    }

    private int getStartIndex(Token startToken) {
        if (startToken instanceof CommonToken) {
            CommonToken ct = (CommonToken)startToken;
            return ct.getStartIndex();
        }
        String message = "Non CommonToken " + this.getTokenName(startToken.getType()) + " with content '" + startToken.getText() + "' on channel " + startToken.getChannel();
        this.internalErrorReporter.add(InternalException.create("unrecognized token on hidden channel", message));
        return -1;
    }

    private int getEndIndex(Token endToken) {
        if (endToken instanceof CommonToken) {
            CommonToken ct = (CommonToken)endToken;
            return ct.getStopIndex();
        }
        String message = "Non CommonToken " + this.getTokenName(endToken.getType()) + " with content '" + endToken.getText() + "' on channel " + endToken.getChannel();
        this.internalErrorReporter.add(InternalException.create("unrecognized token on hidden channel", message));
        return -1;
    }

    private String getTokenName(int tokenType) {
        return tokenType == -1 ? "<EOF>" : this.getTokenNames()[tokenType];
    }

    public void displayRecognitionError(String[] tokenNames, RecognitionException exception) {
        if (exception instanceof CustomRecognitionException) {
            CustomRecognitionException ex = (CustomRecognitionException)exception;
            this.reportUserError(ex.getError(), ex);
        } else {
            String text = exception.token.getText() == null ? "" : exception.token.getText();
            Loc loc = Loc._RealLoc(exception.index, exception.index + text.length(), exception.line, exception.charPositionInLine + 1);
            if (exception instanceof NoViableAltException) {
                if (exception.token.getType() == -1) {
                    this.reportSyntaxError(SyntaxError._UnexpectedEOF(loc), exception);
                } else {
                    this.reportSyntaxError(SyntaxError._UnexpectedToken(loc, exception.token.getText()), exception);
                }
            } else {
                String message = this.getErrorMessage(exception, tokenNames);
                this.reportSyntaxError(SyntaxError._UnexpectedSyntaxError(loc, message), exception);
            }
        }
    }

    protected Integer parseInteger(Token t) throws CustomRecognitionException {
        try {
            return Integer.valueOf(t.getText());
        }
        catch (NumberFormatException x) {
            throw new CustomRecognitionException(UserError._Syntax(SyntaxError._IllegalIntegerLiteral(this.tokenLoc(t))));
        }
    }

    protected Long parseLong(Token t) throws CustomRecognitionException {
        try {
            return Long.valueOf(t.getText().substring(0, t.getText().length() - 1));
        }
        catch (NumberFormatException x) {
            throw new CustomRecognitionException(UserError._Syntax(SyntaxError._IllegalLongLiteral(this.tokenLoc(t))));
        }
    }

    protected Double parseDouble(Token t) throws CustomRecognitionException {
        try {
            return Double.valueOf(t.getText().substring(0, t.getText().length() - 1));
        }
        catch (NumberFormatException x) {
            throw new CustomRecognitionException(UserError._Syntax(SyntaxError._IllegalDoubleLiteral(this.tokenLoc(t))));
        }
    }

    protected TokenPair<Literal> createDecimal(Token t) throws RecognitionException {
        try {
            Literal literal = this.getVersion().isGreaterThanOrEqual(Version.V162) ? Literal._DecimalLiteral(this.tokenLoc(t), this.parseDecimal(t)) : Literal._DoubleLiteral(this.tokenLoc(t), Double.valueOf(t.getText()));
            return BaseApexParser.tokenPair(t, literal);
        }
        catch (NumberFormatException x) {
            throw new CustomRecognitionException(UserError._Syntax(SyntaxError._IllegalDecimalLiteral(this.tokenLoc(t))));
        }
    }

    protected BigDecimal parseDecimal(Token t) throws CustomRecognitionException {
        try {
            if (t.getText().length() > 50) {
                throw new CustomRecognitionException(UserError._Syntax(SyntaxError._IllegalDecimalLiteral(this.tokenLoc(t))));
            }
            return new BigDecimal(t.getText());
        }
        catch (NumberFormatException x) {
            throw new CustomRecognitionException(UserError._Syntax(SyntaxError._IllegalDecimalLiteral(this.tokenLoc(t))));
        }
    }

    private void reportUserError(UserError error, RecognitionException cause) {
        this.syntaxErrorReporter.add(ParseException.create(error, cause));
    }

    private void reportSyntaxError(SyntaxError error, RecognitionException cause) {
        this.reportUserError(UserError._Syntax(error), cause);
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    protected static class TokenPair<T> {
        public final Token token;
        public final T value;

        public TokenPair(Token token, T value) {
            this.token = token;
            this.value = value;
        }
    }
}

