/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.ide.db.impl.serialization;

import apex.jorje.ide.db.api.exception.MissingSerializerException;
import apex.jorje.ide.db.api.operation.GraphOperations;
import apex.jorje.ide.db.impl.serialization.GenericInterfaceMapper;
import apex.jorje.ide.db.impl.serialization.ObjectMapper;
import apex.jorje.ide.db.impl.serialization.SourceFileMapper;
import apex.jorje.ide.db.impl.serialization.TypeInfoMapper;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.naming.TypeNameProvider;
import com.google.common.collect.ImmutableMap;
import com.tinkerpop.blueprints.Vertex;
import java.util.Optional;

public class StandardObjectMapper
implements ObjectMapper {
    private static final ImmutableMap<Class<?>, ObjectMapper.Mapper<?>> DEFAULT_MAPPERS = ImmutableMap.builder().put(TypeNameProvider.class, new GenericInterfaceMapper()).put((Class<TypeNameProvider>)TypeInfo.class, new TypeInfoMapper()).put(SourceFile.class, (TypeInfoMapper)((Object)new SourceFileMapper())).build();
    public static final ObjectMapper INSTANCE = new StandardObjectMapper(DEFAULT_MAPPERS);
    private final ImmutableMap<Class<?>, ObjectMapper.Mapper<?>> mappers;

    StandardObjectMapper(ImmutableMap<Class<?>, ObjectMapper.Mapper<?>> mappers) {
        this.mappers = mappers;
    }

    @Override
    public <T> T deserialize(GraphOperations graph, Class<T> klass, Vertex vertex) {
        return this.mappers.get(klass).deserialize(graph, vertex);
    }

    @Override
    public <T> Vertex serialize(GraphOperations graph, Class<? extends T> klass, T object) {
        return Optional.ofNullable(this.mappers.get(klass)).map(mapper -> mapper.serialize(graph, object)).orElseThrow(() -> new MissingSerializerException(klass));
    }
}

