/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.ide.db.impl.serialization;

import apex.jorje.ide.db.api.operation.GraphOperations;
import apex.jorje.ide.db.impl.serialization.ObjectMapper;
import apex.jorje.semantic.compiler.SourceFile;
import com.tinkerpop.blueprints.Vertex;

public class SourceFileMapper
implements ObjectMapper.Mapper<SourceFile> {
    @Override
    public SourceFile deserialize(GraphOperations graph, Vertex vertex) {
        return SourceFile.builder().setKnownName((String)vertex.getProperty("knownName")).build();
    }

    @Override
    public Vertex serialize(GraphOperations graph, SourceFile sourceFile) {
        String key = SourceFile.class.getSimpleName() + "." + "knownName";
        return graph.findOne(key, sourceFile.getKnownName()).orElseGet(() -> this.serializeInternal(graph, sourceFile));
    }

    private Vertex serializeInternal(GraphOperations graph, SourceFile sourceFile) {
        Vertex vertex = graph.addVertex("class:" + SourceFile.class.getSimpleName());
        vertex.setProperty("knownName", sourceFile.getKnownName());
        return vertex;
    }
}

