/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.ide.db.impl.serialization;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;

class Reflections {
    public static final Reflections INSTANCE = new Reflections();
    private static final String GETTER_PREFIX = "get";
    private static final Logger LOGGER = Logger.getLogger(Reflections.class.getSimpleName());

    private Reflections() {
    }

    public List<Method> retrieveRelevantGetters(Object object) {
        Class<?> klass = object.getClass();
        return Arrays.stream(klass.getMethods()).filter(m -> m.getName().startsWith(GETTER_PREFIX)).filter(m -> m.getParameterCount() == 0).filter(m -> this.isSerializablePrimitive(m.getReturnType())).collect(Collectors.toList());
    }

    private boolean isSerializablePrimitive(Class<?> type) {
        return type.isPrimitive() && type != Void.TYPE || type == Double.class || type == Float.class || type == Long.class || type == Integer.class || type == Short.class || type == Character.class || type == Byte.class || type == Boolean.class || type == String.class;
    }

    public Object getValue(Method method, Object object) {
        try {
            return method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOGGER.severe("Failed to reflectively invoke method: " + method);
            return null;
        }
    }

    public String getKey(Method method) {
        String strippedName = method.getName().replace(GETTER_PREFIX, "");
        return Character.toLowerCase(strippedName.charAt(0)) + strippedName.substring(1);
    }

    public String getSimpleName(Object object) {
        return object.getClass().getSimpleName();
    }
}

