/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.ide.db.api.repository;

import apex.jorje.ide.db.api.operation.GraphOperations;
import apex.jorje.ide.db.api.repository.CrudRepository;
import apex.jorje.ide.db.impl.serialization.TypeInfoMapper;
import apex.jorje.semantic.symbol.type.TypeInfo;
import com.google.common.collect.Iterables;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Vertex;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public final class TypeInfoRepository
implements CrudRepository<TypeInfo> {
    private final GraphOperations graph;

    public TypeInfoRepository(GraphOperations graph) {
        this.graph = graph;
    }

    @Override
    public void save(TypeInfo entity) {
        this.graph.save(entity, TypeInfo.class);
    }

    @Override
    public Optional<TypeInfo> load(Object id) {
        return Optional.ofNullable(this.graph.getVertex(id)).map(v -> Optional.of(this.graph.load((Vertex)v, TypeInfo.class))).orElse(Optional.empty());
    }

    @Override
    public boolean exists(Object id) {
        return this.graph.getVertex(id) != null;
    }

    @Override
    public Iterable<TypeInfo> loadAll() {
        Iterable<Vertex> verticesOfClass = this.graph.getVerticesOfClass(TypeInfoMapper.TYPE_INFO_SIMPLE_NAME);
        return this.createVirtualTypeInfos(verticesOfClass);
    }

    @Override
    public long count() {
        return this.graph.countVertices(TypeInfoMapper.TYPE_INFO_SIMPLE_NAME);
    }

    private Collection<TypeInfo> createVirtualTypeInfos(Iterable<Vertex> verticesOfClass) {
        return StreamSupport.stream(verticesOfClass.spliterator(), false).map(v -> this.graph.load((Vertex)v, TypeInfo.class)).collect(Collectors.toList());
    }

    public Collection<TypeInfo> findByApexName(String apexName) {
        return this.createVirtualTypeInfos(this.graph.getVertices(TypeInfoMapper.APEX_NAME_KEY, apexName));
    }

    public Collection<TypeInfo> loadSubclasses(String apexName) {
        Vertex superClass = Iterables.getOnlyElement(this.graph.getVertices(TypeInfoMapper.APEX_NAME_KEY, apexName));
        return this.createVirtualTypeInfos(superClass.getVertices(Direction.IN, "SuperType"));
    }

    public Collection<TypeInfo> loadImplementors(String apexName) {
        Vertex superClass = Iterables.getOnlyElement(this.graph.getVertices(TypeInfoMapper.APEX_NAME_KEY, apexName));
        return this.createVirtualTypeInfos(superClass.getVertices(Direction.IN, "ImmediateInterfaces"));
    }

    public Collection<TypeInfo> loadSuperclass(String apexName) {
        Vertex subClass = Iterables.getOnlyElement(this.graph.getVertices(TypeInfoMapper.APEX_NAME_KEY, apexName));
        return this.createVirtualTypeInfos(subClass.getVertices(Direction.OUT, "SuperType"));
    }

    public Collection<TypeInfo> loadSuperInterfaces(String apexName) {
        Vertex implementor = Iterables.getOnlyElement(this.graph.getVertices(TypeInfoMapper.APEX_NAME_KEY, apexName));
        return this.createVirtualTypeInfos(implementor.getVertices(Direction.OUT, "ImmediateInterfaces"));
    }
}

