/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.ide.db.api.entities;

import apex.jorje.ide.db.api.operation.GraphOperations;
import apex.jorje.semantic.common.iterable.MoreIterables;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.parent.ParentTable;
import com.google.common.collect.Iterables;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Vertex;
import java.util.Set;
import java.util.stream.StreamSupport;

public final class VirtualParentTable
implements ParentTable {
    private final GraphOperations graph;
    private final Vertex vertex;
    private Set<TypeInfo> immediateInterfaces;
    private Set<TypeInfo> allInterfaces;

    public VirtualParentTable(GraphOperations graph, Vertex vertex) {
        this.graph = graph;
        this.vertex = vertex;
    }

    @Override
    public TypeInfo superType() {
        Vertex superType = Iterables.getOnlyElement(this.vertex.getVertices(Direction.OUT, "SuperType"));
        return this.graph.load(superType, TypeInfo.class);
    }

    @Override
    public Set<TypeInfo> immediateInterfaces() {
        if (this.immediateInterfaces == null) {
            Iterable<Vertex> vertices = this.vertex.getVertices(Direction.OUT, "ImmediateInterfaces");
            this.immediateInterfaces = StreamSupport.stream(vertices.spliterator(), false).map(v -> this.graph.load((Vertex)v, TypeInfo.class)).collect(MoreIterables.toUnmodifiableSet());
        }
        return this.immediateInterfaces;
    }

    @Override
    public Set<TypeInfo> allInterfaces() {
        if (this.allInterfaces == null) {
            Iterable<Vertex> vertices = this.vertex.getVertices(Direction.OUT, "AllInterfaces");
            this.allInterfaces = StreamSupport.stream(vertices.spliterator(), false).map(v -> this.graph.load((Vertex)v, TypeInfo.class)).collect(MoreIterables.toUnmodifiableSet());
        }
        return this.allInterfaces;
    }

    @Override
    public void resolve(TypeInfo superType, Set<TypeInfo> interfaces, boolean checkSuperVisibility) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isResolved() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean checkSuperVisibility() {
        throw new UnsupportedOperationException();
    }
}

