/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.ide.db.api.entities;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.ide.db.api.operation.GraphOperations;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.symbol.type.CodeUnitDetails;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.reference.TypeReference;
import apex.jorje.services.Version;
import com.google.common.collect.Iterables;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Vertex;
import java.util.List;
import java.util.Optional;

public final class VirtualCodeUnitDetails
implements CodeUnitDetails {
    private final GraphOperations graph;
    private final Vertex vertex;
    private final Loc loc;
    private SourceFile sourceFile;

    public VirtualCodeUnitDetails(GraphOperations graph, Vertex vertex) {
        this.graph = graph;
        this.vertex = vertex;
        this.loc = this.constructLoc();
    }

    private Loc constructLoc() {
        Integer startIndex = (Integer)this.vertex.getProperty("startIndex");
        Integer endIndex = (Integer)this.vertex.getProperty("endIndex");
        Integer line = (Integer)this.vertex.getProperty("line");
        Integer column = (Integer)this.vertex.getProperty("column");
        return startIndex == null || endIndex == null || line == null || column == null ? Loc._SyntheticLoc() : Loc._RealLoc(startIndex, endIndex, line, column);
    }

    @Override
    public boolean isApexSourceBased() {
        return (Boolean)this.vertex.getProperty("isApexSourceBased");
    }

    @Override
    public SourceFile getSource() {
        if (this.sourceFile == null) {
            Vertex source = Iterables.getOnlyElement(this.vertex.getVertices(Direction.OUT, "Source"));
            this.sourceFile = this.graph.load(source, SourceFile.class);
        }
        return this.sourceFile;
    }

    @Override
    public String getName() {
        return (String)this.vertex.getProperty("name");
    }

    @Override
    public Version getVersion() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TypeInfo getType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TypeReference getTriggerType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Optional<TypeRef> getSuperTypeRef() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<TypeRef> getInterfaceTypeRefs() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Loc getLoc() {
        return this.loc;
    }

    @Override
    public boolean isTrusted() {
        return (Boolean)this.vertex.getProperty("isTrusted");
    }

    @Override
    public boolean isFileBased() {
        return (Boolean)this.vertex.getProperty("isFileBased");
    }
}

