/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.data.ast;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.Identifier;
import apex.jorje.data.ast.JavaRef;
import java.util.List;
import java.util.Optional;

public abstract class TypeRef {
    private TypeRef() {
    }

    public static final TypeRef _ClassTypeRef(Optional<JavaRef> javaRef, List<Identifier> className, Optional<List<TypeRef>> typeArguments) {
        return new ClassTypeRef(javaRef, className, typeArguments);
    }

    public static final TypeRef _ArrayTypeRef(Loc loc, TypeRef heldType) {
        return new ArrayTypeRef(loc, heldType);
    }

    public abstract <ResultType> ResultType match(MatchBlock<ResultType> var1);

    public abstract void _switch(SwitchBlock var1);

    public static final class ArrayTypeRef
    extends TypeRef {
        public Loc loc;
        public TypeRef heldType;

        public ArrayTypeRef(Loc loc, TypeRef heldType) {
            this.loc = loc;
            this.heldType = heldType;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.heldType == null ? 0 : this.heldType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ArrayTypeRef other = (ArrayTypeRef)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            return !(this.heldType == null ? other.heldType != null : !this.heldType.equals(other.heldType));
        }

        public String toString() {
            return "ArrayTypeRef(loc = " + this.loc + ", heldType = " + this.heldType + ")";
        }
    }

    public static final class ClassTypeRef
    extends TypeRef {
        public Optional<JavaRef> javaRef;
        public List<Identifier> className;
        public Optional<List<TypeRef>> typeArguments;

        public ClassTypeRef(Optional<JavaRef> javaRef, List<Identifier> className, Optional<List<TypeRef>> typeArguments) {
            this.javaRef = javaRef;
            this.className = className;
            this.typeArguments = typeArguments;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.javaRef == null ? 0 : this.javaRef.hashCode());
            result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
            result = 31 * result + (this.typeArguments == null ? 0 : this.typeArguments.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClassTypeRef other = (ClassTypeRef)obj;
            if (this.javaRef == null ? other.javaRef != null : !this.javaRef.equals(other.javaRef)) {
                return false;
            }
            if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
                return false;
            }
            return !(this.typeArguments == null ? other.typeArguments != null : !this.typeArguments.equals(other.typeArguments));
        }

        public String toString() {
            return "ClassTypeRef(javaRef = " + this.javaRef + ", className = " + this.className + ", typeArguments = " + this.typeArguments + ")";
        }
    }

    public static abstract class SwitchBlockWithDefault
    implements SwitchBlock {
        @Override
        public void _case(ClassTypeRef x) {
            this._default(x);
        }

        @Override
        public void _case(ArrayTypeRef x) {
            this._default(x);
        }

        protected abstract void _default(TypeRef var1);
    }

    public static interface SwitchBlock {
        public void _case(ClassTypeRef var1);

        public void _case(ArrayTypeRef var1);
    }

    public static abstract class MatchBlockWithDefault<ResultType>
    implements MatchBlock<ResultType> {
        @Override
        public ResultType _case(ClassTypeRef x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(ArrayTypeRef x) {
            return this._default(x);
        }

        protected abstract ResultType _default(TypeRef var1);
    }

    public static interface MatchBlock<ResultType> {
        public ResultType _case(ClassTypeRef var1);

        public ResultType _case(ArrayTypeRef var1);
    }
}

