/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.data.ast;

import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.GroupedList;
import apex.jorje.data.ast.MapLiteralKeyValue;
import apex.jorje.data.ast.NameValueParameter;
import apex.jorje.data.ast.TypeRef;
import java.util.List;
import java.util.Optional;

public abstract class ObjectCreator {
    private ObjectCreator() {
    }

    public static final ObjectCreator _ListInitCreator(List<TypeRef> types, Optional<Expr> expr) {
        return new ListInitCreator(types, expr);
    }

    public static final ObjectCreator _ListLiteralCreator(List<TypeRef> types, GroupedList<Expr> values) {
        return new ListLiteralCreator(types, values);
    }

    public static final ObjectCreator _SetInitCreator(List<TypeRef> types, Optional<Expr> expr) {
        return new SetInitCreator(types, expr);
    }

    public static final ObjectCreator _SetLiteralCreator(List<TypeRef> types, GroupedList<Expr> values) {
        return new SetLiteralCreator(types, values);
    }

    public static final ObjectCreator _MapInitCreator(List<TypeRef> types, Optional<Expr> expr) {
        return new MapInitCreator(types, expr);
    }

    public static final ObjectCreator _MapLiteralCreator(List<TypeRef> types, GroupedList<MapLiteralKeyValue> pairs) {
        return new MapLiteralCreator(types, pairs);
    }

    public static final ObjectCreator _NameValueCreator(TypeRef type, GroupedList<NameValueParameter> keyValues) {
        return new NameValueCreator(type, keyValues);
    }

    public static final ObjectCreator _NormalObjectCreator(TypeRef type, GroupedList<Expr> inputParameters) {
        return new NormalObjectCreator(type, inputParameters);
    }

    public abstract <ResultType> ResultType match(MatchBlock<ResultType> var1);

    public abstract void _switch(SwitchBlock var1);

    public static final class NormalObjectCreator
    extends ObjectCreator {
        public TypeRef type;
        public GroupedList<Expr> inputParameters;

        public NormalObjectCreator(TypeRef type, GroupedList<Expr> inputParameters) {
            this.type = type;
            this.inputParameters = inputParameters;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            result = 31 * result + (this.inputParameters == null ? 0 : this.inputParameters.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NormalObjectCreator other = (NormalObjectCreator)obj;
            if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
                return false;
            }
            return !(this.inputParameters == null ? other.inputParameters != null : !this.inputParameters.equals(other.inputParameters));
        }

        public String toString() {
            return "NormalObjectCreator(type = " + this.type + ", inputParameters = " + this.inputParameters + ")";
        }
    }

    public static final class NameValueCreator
    extends ObjectCreator {
        public TypeRef type;
        public GroupedList<NameValueParameter> keyValues;

        public NameValueCreator(TypeRef type, GroupedList<NameValueParameter> keyValues) {
            this.type = type;
            this.keyValues = keyValues;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            result = 31 * result + (this.keyValues == null ? 0 : this.keyValues.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NameValueCreator other = (NameValueCreator)obj;
            if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
                return false;
            }
            return !(this.keyValues == null ? other.keyValues != null : !this.keyValues.equals(other.keyValues));
        }

        public String toString() {
            return "NameValueCreator(type = " + this.type + ", keyValues = " + this.keyValues + ")";
        }
    }

    public static final class MapLiteralCreator
    extends ObjectCreator {
        public List<TypeRef> types;
        public GroupedList<MapLiteralKeyValue> pairs;

        public MapLiteralCreator(List<TypeRef> types, GroupedList<MapLiteralKeyValue> pairs) {
            this.types = types;
            this.pairs = pairs;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.types == null ? 0 : this.types.hashCode());
            result = 31 * result + (this.pairs == null ? 0 : this.pairs.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MapLiteralCreator other = (MapLiteralCreator)obj;
            if (this.types == null ? other.types != null : !this.types.equals(other.types)) {
                return false;
            }
            return !(this.pairs == null ? other.pairs != null : !this.pairs.equals(other.pairs));
        }

        public String toString() {
            return "MapLiteralCreator(types = " + this.types + ", pairs = " + this.pairs + ")";
        }
    }

    public static final class MapInitCreator
    extends ObjectCreator {
        public List<TypeRef> types;
        public Optional<Expr> expr;

        public MapInitCreator(List<TypeRef> types, Optional<Expr> expr) {
            this.types = types;
            this.expr = expr;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.types == null ? 0 : this.types.hashCode());
            result = 31 * result + (this.expr == null ? 0 : this.expr.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MapInitCreator other = (MapInitCreator)obj;
            if (this.types == null ? other.types != null : !this.types.equals(other.types)) {
                return false;
            }
            return !(this.expr == null ? other.expr != null : !this.expr.equals(other.expr));
        }

        public String toString() {
            return "MapInitCreator(types = " + this.types + ", expr = " + this.expr + ")";
        }
    }

    public static final class SetLiteralCreator
    extends ObjectCreator {
        public List<TypeRef> types;
        public GroupedList<Expr> values;

        public SetLiteralCreator(List<TypeRef> types, GroupedList<Expr> values) {
            this.types = types;
            this.values = values;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.types == null ? 0 : this.types.hashCode());
            result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SetLiteralCreator other = (SetLiteralCreator)obj;
            if (this.types == null ? other.types != null : !this.types.equals(other.types)) {
                return false;
            }
            return !(this.values == null ? other.values != null : !this.values.equals(other.values));
        }

        public String toString() {
            return "SetLiteralCreator(types = " + this.types + ", values = " + this.values + ")";
        }
    }

    public static final class SetInitCreator
    extends ObjectCreator {
        public List<TypeRef> types;
        public Optional<Expr> expr;

        public SetInitCreator(List<TypeRef> types, Optional<Expr> expr) {
            this.types = types;
            this.expr = expr;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.types == null ? 0 : this.types.hashCode());
            result = 31 * result + (this.expr == null ? 0 : this.expr.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SetInitCreator other = (SetInitCreator)obj;
            if (this.types == null ? other.types != null : !this.types.equals(other.types)) {
                return false;
            }
            return !(this.expr == null ? other.expr != null : !this.expr.equals(other.expr));
        }

        public String toString() {
            return "SetInitCreator(types = " + this.types + ", expr = " + this.expr + ")";
        }
    }

    public static final class ListLiteralCreator
    extends ObjectCreator {
        public List<TypeRef> types;
        public GroupedList<Expr> values;

        public ListLiteralCreator(List<TypeRef> types, GroupedList<Expr> values) {
            this.types = types;
            this.values = values;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.types == null ? 0 : this.types.hashCode());
            result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ListLiteralCreator other = (ListLiteralCreator)obj;
            if (this.types == null ? other.types != null : !this.types.equals(other.types)) {
                return false;
            }
            return !(this.values == null ? other.values != null : !this.values.equals(other.values));
        }

        public String toString() {
            return "ListLiteralCreator(types = " + this.types + ", values = " + this.values + ")";
        }
    }

    public static final class ListInitCreator
    extends ObjectCreator {
        public List<TypeRef> types;
        public Optional<Expr> expr;

        public ListInitCreator(List<TypeRef> types, Optional<Expr> expr) {
            this.types = types;
            this.expr = expr;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.types == null ? 0 : this.types.hashCode());
            result = 31 * result + (this.expr == null ? 0 : this.expr.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ListInitCreator other = (ListInitCreator)obj;
            if (this.types == null ? other.types != null : !this.types.equals(other.types)) {
                return false;
            }
            return !(this.expr == null ? other.expr != null : !this.expr.equals(other.expr));
        }

        public String toString() {
            return "ListInitCreator(types = " + this.types + ", expr = " + this.expr + ")";
        }
    }

    public static abstract class SwitchBlockWithDefault
    implements SwitchBlock {
        @Override
        public void _case(ListInitCreator x) {
            this._default(x);
        }

        @Override
        public void _case(ListLiteralCreator x) {
            this._default(x);
        }

        @Override
        public void _case(SetInitCreator x) {
            this._default(x);
        }

        @Override
        public void _case(SetLiteralCreator x) {
            this._default(x);
        }

        @Override
        public void _case(MapInitCreator x) {
            this._default(x);
        }

        @Override
        public void _case(MapLiteralCreator x) {
            this._default(x);
        }

        @Override
        public void _case(NameValueCreator x) {
            this._default(x);
        }

        @Override
        public void _case(NormalObjectCreator x) {
            this._default(x);
        }

        protected abstract void _default(ObjectCreator var1);
    }

    public static interface SwitchBlock {
        public void _case(ListInitCreator var1);

        public void _case(ListLiteralCreator var1);

        public void _case(SetInitCreator var1);

        public void _case(SetLiteralCreator var1);

        public void _case(MapInitCreator var1);

        public void _case(MapLiteralCreator var1);

        public void _case(NameValueCreator var1);

        public void _case(NormalObjectCreator var1);
    }

    public static abstract class MatchBlockWithDefault<ResultType>
    implements MatchBlock<ResultType> {
        @Override
        public ResultType _case(ListInitCreator x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(ListLiteralCreator x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(SetInitCreator x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(SetLiteralCreator x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(MapInitCreator x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(MapLiteralCreator x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(NameValueCreator x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(NormalObjectCreator x) {
            return this._default(x);
        }

        protected abstract ResultType _default(ObjectCreator var1);
    }

    public static interface MatchBlock<ResultType> {
        public ResultType _case(ListInitCreator var1);

        public ResultType _case(ListLiteralCreator var1);

        public ResultType _case(SetInitCreator var1);

        public ResultType _case(SetLiteralCreator var1);

        public ResultType _case(MapInitCreator var1);

        public ResultType _case(MapLiteralCreator var1);

        public ResultType _case(NameValueCreator var1);

        public ResultType _case(NormalObjectCreator var1);
    }
}

