/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.data.ast;

import apex.jorje.data.Loc;

public abstract class Literal {
    private Literal() {
    }

    public static final Literal _StringLiteral(Loc loc, String literal) {
        return new StringLiteral(loc, literal);
    }

    public static final Literal _IntegerLiteral(Loc loc, Integer literal) {
        return new IntegerLiteral(loc, literal);
    }

    public static final Literal _LongLiteral(Loc loc, Long literal) {
        return new LongLiteral(loc, literal);
    }

    public static final Literal _DoubleLiteral(Loc loc, Double literal) {
        return new DoubleLiteral(loc, literal);
    }

    public static final Literal _DecimalLiteral(Loc loc, Number literal) {
        return new DecimalLiteral(loc, literal);
    }

    public static final Literal _NullLiteral(Loc loc) {
        return new NullLiteral(loc);
    }

    public static final Literal _TrueLiteral(Loc loc) {
        return new TrueLiteral(loc);
    }

    public static final Literal _FalseLiteral(Loc loc) {
        return new FalseLiteral(loc);
    }

    public abstract <ResultType> ResultType match(MatchBlock<ResultType> var1);

    public abstract void _switch(SwitchBlock var1);

    public static final class FalseLiteral
    extends Literal {
        public Loc loc;

        public FalseLiteral(Loc loc) {
            this.loc = loc;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FalseLiteral other = (FalseLiteral)obj;
            return !(this.loc == null ? other.loc != null : !this.loc.equals(other.loc));
        }

        public String toString() {
            return "FalseLiteral(loc = " + this.loc + ")";
        }
    }

    public static final class TrueLiteral
    extends Literal {
        public Loc loc;

        public TrueLiteral(Loc loc) {
            this.loc = loc;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TrueLiteral other = (TrueLiteral)obj;
            return !(this.loc == null ? other.loc != null : !this.loc.equals(other.loc));
        }

        public String toString() {
            return "TrueLiteral(loc = " + this.loc + ")";
        }
    }

    public static final class NullLiteral
    extends Literal {
        public Loc loc;

        public NullLiteral(Loc loc) {
            this.loc = loc;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NullLiteral other = (NullLiteral)obj;
            return !(this.loc == null ? other.loc != null : !this.loc.equals(other.loc));
        }

        public String toString() {
            return "NullLiteral(loc = " + this.loc + ")";
        }
    }

    public static final class DecimalLiteral
    extends Literal {
        public Loc loc;
        public Number literal;

        public DecimalLiteral(Loc loc, Number literal) {
            this.loc = loc;
            this.literal = literal;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.literal == null ? 0 : this.literal.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DecimalLiteral other = (DecimalLiteral)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            return !(this.literal == null ? other.literal != null : !this.literal.equals(other.literal));
        }

        public String toString() {
            return "DecimalLiteral(loc = " + this.loc + ", literal = " + this.literal + ")";
        }
    }

    public static final class DoubleLiteral
    extends Literal {
        public Loc loc;
        public Double literal;

        public DoubleLiteral(Loc loc, Double literal) {
            this.loc = loc;
            this.literal = literal;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.literal == null ? 0 : this.literal.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DoubleLiteral other = (DoubleLiteral)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            return !(this.literal == null ? other.literal != null : !this.literal.equals(other.literal));
        }

        public String toString() {
            return "DoubleLiteral(loc = " + this.loc + ", literal = " + this.literal + ")";
        }
    }

    public static final class LongLiteral
    extends Literal {
        public Loc loc;
        public Long literal;

        public LongLiteral(Loc loc, Long literal) {
            this.loc = loc;
            this.literal = literal;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.literal == null ? 0 : this.literal.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LongLiteral other = (LongLiteral)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            return !(this.literal == null ? other.literal != null : !this.literal.equals(other.literal));
        }

        public String toString() {
            return "LongLiteral(loc = " + this.loc + ", literal = " + this.literal + ")";
        }
    }

    public static final class IntegerLiteral
    extends Literal {
        public Loc loc;
        public Integer literal;

        public IntegerLiteral(Loc loc, Integer literal) {
            this.loc = loc;
            this.literal = literal;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.literal == null ? 0 : this.literal.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IntegerLiteral other = (IntegerLiteral)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            return !(this.literal == null ? other.literal != null : !this.literal.equals(other.literal));
        }

        public String toString() {
            return "IntegerLiteral(loc = " + this.loc + ", literal = " + this.literal + ")";
        }
    }

    public static final class StringLiteral
    extends Literal {
        public Loc loc;
        public String literal;

        public StringLiteral(Loc loc, String literal) {
            this.loc = loc;
            this.literal = literal;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.literal == null ? 0 : this.literal.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StringLiteral other = (StringLiteral)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            return !(this.literal == null ? other.literal != null : !this.literal.equals(other.literal));
        }

        public String toString() {
            return "StringLiteral(loc = " + this.loc + ", literal = " + this.literal + ")";
        }
    }

    public static abstract class SwitchBlockWithDefault
    implements SwitchBlock {
        @Override
        public void _case(StringLiteral x) {
            this._default(x);
        }

        @Override
        public void _case(IntegerLiteral x) {
            this._default(x);
        }

        @Override
        public void _case(LongLiteral x) {
            this._default(x);
        }

        @Override
        public void _case(DoubleLiteral x) {
            this._default(x);
        }

        @Override
        public void _case(DecimalLiteral x) {
            this._default(x);
        }

        @Override
        public void _case(NullLiteral x) {
            this._default(x);
        }

        @Override
        public void _case(TrueLiteral x) {
            this._default(x);
        }

        @Override
        public void _case(FalseLiteral x) {
            this._default(x);
        }

        protected abstract void _default(Literal var1);
    }

    public static interface SwitchBlock {
        public void _case(StringLiteral var1);

        public void _case(IntegerLiteral var1);

        public void _case(LongLiteral var1);

        public void _case(DoubleLiteral var1);

        public void _case(DecimalLiteral var1);

        public void _case(NullLiteral var1);

        public void _case(TrueLiteral var1);

        public void _case(FalseLiteral var1);
    }

    public static abstract class MatchBlockWithDefault<ResultType>
    implements MatchBlock<ResultType> {
        @Override
        public ResultType _case(StringLiteral x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(IntegerLiteral x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(LongLiteral x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(DoubleLiteral x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(DecimalLiteral x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(NullLiteral x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(TrueLiteral x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(FalseLiteral x) {
            return this._default(x);
        }

        protected abstract ResultType _default(Literal var1);
    }

    public static interface MatchBlock<ResultType> {
        public ResultType _case(StringLiteral var1);

        public ResultType _case(IntegerLiteral var1);

        public ResultType _case(LongLiteral var1);

        public ResultType _case(DoubleLiteral var1);

        public ResultType _case(DecimalLiteral var1);

        public ResultType _case(NullLiteral var1);

        public ResultType _case(TrueLiteral var1);

        public ResultType _case(FalseLiteral var1);
    }
}

