/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.data.ast;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.Stmnt;
import java.util.List;

public abstract class Case {
    private Case() {
    }

    public static final Case _NormalCase(Loc loc, Expr expr, List<Stmnt> statements) {
        return new NormalCase(loc, expr, statements);
    }

    public static final Case _DefaultCase(Loc loc, List<Stmnt> statements) {
        return new DefaultCase(loc, statements);
    }

    public abstract <ResultType> ResultType match(MatchBlock<ResultType> var1);

    public abstract void _switch(SwitchBlock var1);

    public static final class DefaultCase
    extends Case {
        public Loc loc;
        public List<Stmnt> statements;

        public DefaultCase(Loc loc, List<Stmnt> statements) {
            this.loc = loc;
            this.statements = statements;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.statements == null ? 0 : this.statements.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DefaultCase other = (DefaultCase)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            return !(this.statements == null ? other.statements != null : !this.statements.equals(other.statements));
        }

        public String toString() {
            return "DefaultCase(loc = " + this.loc + ", statements = " + this.statements + ")";
        }
    }

    public static final class NormalCase
    extends Case {
        public Loc loc;
        public Expr expr;
        public List<Stmnt> statements;

        public NormalCase(Loc loc, Expr expr, List<Stmnt> statements) {
            this.loc = loc;
            this.expr = expr;
            this.statements = statements;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.expr == null ? 0 : this.expr.hashCode());
            result = 31 * result + (this.statements == null ? 0 : this.statements.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NormalCase other = (NormalCase)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            if (this.expr == null ? other.expr != null : !this.expr.equals(other.expr)) {
                return false;
            }
            return !(this.statements == null ? other.statements != null : !this.statements.equals(other.statements));
        }

        public String toString() {
            return "NormalCase(loc = " + this.loc + ", expr = " + this.expr + ", statements = " + this.statements + ")";
        }
    }

    public static abstract class SwitchBlockWithDefault
    implements SwitchBlock {
        @Override
        public void _case(NormalCase x) {
            this._default(x);
        }

        @Override
        public void _case(DefaultCase x) {
            this._default(x);
        }

        protected abstract void _default(Case var1);
    }

    public static interface SwitchBlock {
        public void _case(NormalCase var1);

        public void _case(DefaultCase var1);
    }

    public static abstract class MatchBlockWithDefault<ResultType>
    implements MatchBlock<ResultType> {
        @Override
        public ResultType _case(NormalCase x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(DefaultCase x) {
            return this._default(x);
        }

        protected abstract ResultType _default(Case var1);
    }

    public static interface MatchBlock<ResultType> {
        public ResultType _case(NormalCase var1);

        public ResultType _case(DefaultCase var1);
    }
}

