/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pldoc.mojo;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import net.sourceforge.pldoc.ant.PLDocTask;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.plexus.components.cipher.DefaultPlexusCipher;
import org.sonatype.plexus.components.cipher.PlexusCipher;
import org.sonatype.plexus.components.cipher.PlexusCipherException;
import org.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;
import org.sonatype.plexus.components.sec.dispatcher.SecUtil;
import org.sonatype.plexus.components.sec.dispatcher.model.SettingsSecurity;

public class PLDoc
extends AbstractMojo
implements MavenReport {
    private String applicationTitle;
    private String destDir;
    protected File overviewFile;
    private String stylesheet;
    protected File outputDirectory;
    private File reportOutputDirectory;
    private File sourceDirectory;
    private String includes;
    private String inputEncoding = System.getProperty("file.encoding");
    private String namesCase = "default";
    private String dbUrl;
    private String dbUser;
    private String dbPassword;
    private String inputTypes;
    private String inputObjects;
    private boolean showSkippedPackages;
    private String driverName;
    private String getMetadataStatement;
    private Integer getMetadataStatementReturnType;
    private boolean ignoreInformalComments;
    private boolean plscope;
    private boolean savesourcecode;
    private String sourcestylesheet;
    private MavenProject project;
    private String name;
    private String description;
    private List<FileSet> fileSets;
    private MavenSession mavenSession;
    private PlexusCipher cipher;
    private SettingsSecurity securitySettings;
    private File securitySettingsPath;

    public void execute() throws MojoExecutionException {
        try {
            Sink sink = null;
            Locale locale = Locale.getDefault();
            this.generate(sink, locale);
        }
        catch (MavenReportException ex) {
            throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation", (Exception)((Object)ex));
        }
        catch (RuntimeException ex) {
            throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation", (Exception)ex);
        }
    }

    public void generate(Sink sink, Locale locale) throws MavenReportException {
        this.outputDirectory = this.getReportOutputDirectory();
        this.getLog().debug((CharSequence)("outputDirectory=" + this.outputDirectory));
        this.getLog().debug((CharSequence)("destDir=" + this.destDir));
        this.getLog().debug((CharSequence)("reportOutputDirectory=" + this.reportOutputDirectory));
        this.getLog().debug((CharSequence)("applicationTitle=" + this.applicationTitle));
        this.getLog().debug((CharSequence)("sourceDirectory=" + this.sourceDirectory));
        this.getLog().debug((CharSequence)("includes=" + this.includes));
        this.getLog().debug((CharSequence)("inputEncoding=" + this.inputEncoding));
        this.getLog().debug((CharSequence)("overviewFile=" + this.overviewFile));
        this.getLog().debug((CharSequence)("stylesheet=" + this.stylesheet));
        this.getLog().debug((CharSequence)("sourcestylesheet=" + this.sourcestylesheet));
        this.getLog().debug((CharSequence)("namesCase=" + this.namesCase));
        this.getLog().debug((CharSequence)("dbUrl=" + this.dbUrl));
        this.getLog().debug((CharSequence)("dbUser=" + this.dbUser));
        this.getLog().debug((CharSequence)("dbPassword=" + (null == this.dbPassword ? "undefined" : "defined")));
        this.getLog().debug((CharSequence)("inputObjects=" + this.inputObjects));
        this.getLog().debug((CharSequence)("inputTypes=" + this.inputTypes));
        this.getLog().debug((CharSequence)("showSkippedPackages=" + this.showSkippedPackages));
        this.getLog().debug((CharSequence)("ignoreInformalComments=" + this.ignoreInformalComments));
        this.getLog().debug((CharSequence)("plscope=" + this.plscope));
        this.getLog().debug((CharSequence)("savesourcecode=" + this.savesourcecode));
        this.getLog().debug((CharSequence)("driverName=" + this.driverName));
        this.getLog().debug((CharSequence)("getMetadataStatement=" + this.getMetadataStatement));
        this.getLog().debug((CharSequence)("getMetadataStatementReturnType=" + this.getMetadataStatementReturnType));
        try {
            if (!this.outputDirectory.exists()) {
                this.getLog().info((CharSequence)("Creating directory " + this.outputDirectory.toString()));
                this.outputDirectory.mkdirs();
            }
            PLDocTask task = new PLDocTask();
            task.init();
            task.setDestdir(this.outputDirectory);
            task.setDoctitle(this.applicationTitle);
            if (null == this.dbUser || "".equals(this.dbUser) || null == this.dbPassword || "".equals(this.dbPassword)) {
                this.getLog().info((CharSequence)"Some credentials are missing: setting credentials from Server credentials");
                this.setServerCredentials(this.dbUrl);
                this.getLog().debug((CharSequence)("Server dbUser=" + this.dbUser));
                this.getLog().debug((CharSequence)("Server dbPassword=" + (null == this.dbPassword ? "undefined" : "defined")));
            }
            this.dbPassword = this.getDecryptedPassword(this.dbPassword);
            task.setDbUrl(this.dbUrl);
            task.setDbUser(this.dbUser);
            task.setDbPassword(this.dbPassword);
            task.setInputObjects(this.inputObjects);
            task.setInputTypes(this.inputTypes);
            task.setInputEncoding(this.inputEncoding);
            task.setShowSkippedPackages(this.showSkippedPackages);
            task.setIgnoreInformalComments(this.ignoreInformalComments);
            task.setPlscope(this.plscope);
            task.setSaveSourceCode(this.savesourcecode);
            PLDocTask.NamesCase antNamesCase = new PLDocTask.NamesCase();
            antNamesCase.setValue(this.namesCase);
            task.setNamesCase(antNamesCase);
            if (null != this.overviewFile) {
                task.setOverview(this.overviewFile);
            }
            if (null != this.stylesheet) {
                task.setStylesheet(this.stylesheet);
            }
            if (null != this.sourcestylesheet) {
                task.setSourceStylesheet(this.sourcestylesheet);
            }
            if (null != this.driverName) {
                task.setDriverName(this.driverName);
            }
            if (null != this.getMetadataStatement) {
                task.setGetMetadataStatement(this.getMetadataStatement);
            }
            if (null != this.getMetadataStatementReturnType) {
                task.setReturnType(this.getMetadataStatementReturnType);
            }
            if (null != this.sourceDirectory && null != this.includes) {
                org.apache.tools.ant.types.FileSet fset = new org.apache.tools.ant.types.FileSet();
                fset.setDir(this.sourceDirectory);
                fset.setIncludes(this.includes);
                task.addFileset(fset);
            }
            FileSetManager fileSetManager = new FileSetManager(this.getLog());
            for (FileSet fileSet : this.fileSets) {
                org.apache.tools.ant.types.FileSet fset = new org.apache.tools.ant.types.FileSet();
                fset.setDir(new File(fileSet.getDirectory()));
                StringBuilder includesString = new StringBuilder();
                for (String include : fileSet.getIncludesArray()) {
                    includesString.append(" ");
                    includesString.append(include);
                }
                fset.setIncludes(includesString.toString().trim());
                StringBuilder excludesString = new StringBuilder();
                for (String exclude : fileSet.getExcludesArray()) {
                    excludesString.append(" ");
                    excludesString.append(exclude);
                }
                fset.setExcludes(excludesString.toString().trim());
                task.addFileset(fset);
            }
            Project proj = new Project();
            proj.setBaseDir(this.outputDirectory);
            proj.setName(this.applicationTitle);
            task.setProject(proj);
            task.execute();
        }
        catch (BuildException ex) {
            throw new MavenReportException("Failed generating pldoc report", (Exception)((Object)ex));
        }
        catch (RuntimeException ex) {
            throw new MavenReportException("Failed generating pldoc report", (Exception)ex);
        }
    }

    public String getOutputName() {
        return this.destDir + "/index";
    }

    public String getName(Locale locale) {
        if (StringUtils.isEmpty((String)this.name)) {
            return this.getBundle(locale).getString("report.pldoc.name");
        }
        return this.name;
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    public String getDescription(Locale locale) {
        if (StringUtils.isEmpty((String)this.description)) {
            return this.getBundle(locale).getString("report.pldoc.description");
        }
        return this.description;
    }

    public void setDestDir(String destDir) {
        this.destDir = destDir;
        this.getLog().debug((CharSequence)("setDestDir: param destDir=" + destDir));
        this.getLog().debug((CharSequence)("setDestDir: outputDirectory=" + this.outputDirectory));
        this.getLog().debug((CharSequence)("setDestDir: destDir=" + this.destDir));
        this.getLog().debug((CharSequence)("setDestDir: reportOutputDirectory=" + this.reportOutputDirectory));
        this.updateReportOutputDirectory(this.reportOutputDirectory, destDir);
    }

    public void setReportOutputDirectory(File reportOutputDirectory) {
        this.getLog().debug((CharSequence)("setReportOutPutDirectory: param reportOutputDirectory=" + reportOutputDirectory));
        this.getLog().debug((CharSequence)("setReportOutPutDirectory: outputDirectory=" + this.outputDirectory));
        this.getLog().debug((CharSequence)("setReportOutPutDirectory: destDir=" + this.destDir));
        this.getLog().debug((CharSequence)("setReportOutPutDirectory: reportOutputDirectory=" + this.reportOutputDirectory));
        this.updateReportOutputDirectory(reportOutputDirectory, this.destDir);
    }

    private void updateReportOutputDirectory(File reportOutputDirectory, String destDir) {
        this.reportOutputDirectory = reportOutputDirectory != null && destDir != null && !reportOutputDirectory.getAbsolutePath().endsWith(destDir) ? new File(reportOutputDirectory, destDir) : reportOutputDirectory;
        this.getLog().debug((CharSequence)("updateReportOutPutDirectory: reportOutputDirectory=" + this.reportOutputDirectory));
    }

    public File getReportOutputDirectory() {
        if (this.reportOutputDirectory == null) {
            return this.outputDirectory;
        }
        return this.reportOutputDirectory;
    }

    public boolean isExternalReport() {
        return true;
    }

    public boolean canGenerateReport() {
        return true;
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("pldoc-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    private String getDecryptedPassword(String password) throws MavenReportException {
        DefaultSecDispatcher securityDispatcher = new DefaultSecDispatcher();
        String configurationFilePath = securityDispatcher.getConfigurationFile();
        this.getLog().debug((CharSequence)("configurationFilePath \"" + configurationFilePath + "\""));
        try {
            this.getLog().debug((CharSequence)("settings.security property \"" + System.getProperty("settings.security") + "\""));
            File configurationFile = new File(configurationFilePath);
            if (configurationFilePath.startsWith("~")) {
                configurationFilePath = System.getProperty("user.home") + configurationFilePath.substring(1);
                configurationFile = new File(configurationFilePath);
                this.getLog().debug((CharSequence)(" Amended configurationFilePath \"" + configurationFilePath + "\""));
            }
            if (!configurationFile.exists() || !configurationFile.canRead()) {
                configurationFile = new File(System.getProperty("user.home") + "/.m2/settings-security.xml");
                this.getLog().debug((CharSequence)("configurationFilePath \"" + configurationFilePath + "\""));
                if (configurationFile.exists() && configurationFile.canRead()) {
                    configurationFilePath = configurationFile.getCanonicalPath().replace("\\", "\\\\");
                    this.getLog().debug((CharSequence)(" Fallback Maven configurationFilePath \"" + configurationFilePath + "\""));
                    securityDispatcher.setConfigurationFile(configurationFilePath);
                }
            }
        }
        catch (IOException ex) {
            throw new MavenReportException("Failed to decrypt password: " + password, (Exception)ex);
        }
        this.getLog().debug((CharSequence)"DefaultSecDispatcher.SYSTEM_PROPERTY_SEC_LOCATION=\"settings.security\"");
        String file = System.getProperty("settings.security", configurationFilePath);
        this.getLog().debug((CharSequence)("file=\"" + file + "\""));
        String master = null;
        try {
            DefaultPlexusCipher cipher = new DefaultPlexusCipher();
            if (!cipher.isEncryptedString(password)) {
                this.getLog().debug((CharSequence)("Unencrypted password \"" + (null == password ? "undefined" : "defined") + "\""));
                return password;
            }
            SettingsSecurity sec = SecUtil.read((String)file, (boolean)true);
            if (sec != null) {
                master = sec.getMaster();
                this.getLog().debug((CharSequence)"SettingsSecurity exists ");
            }
            if (master == null) {
                throw new IllegalStateException("Master password is not set in the setting security file: " + file);
            }
            this.getLog().debug((CharSequence)"Master exists ");
            String masterPassword = cipher.decryptDecorated(master, "settings.security");
            this.getLog().debug((CharSequence)("Master password \"" + (null == masterPassword ? "undefined" : "defined") + "\""));
            String result = cipher.decryptDecorated(password, masterPassword);
            this.getLog().debug((CharSequence)("Decrypted password \"" + (null == result ? "undefined" : "defined") + "\""));
            return result;
        }
        catch (PlexusCipherException ex) {
            throw new MavenReportException("Failed to decrypt password: " + password, (Exception)((Object)ex));
        }
        catch (SecDispatcherException ex) {
            throw new MavenReportException("Failed to decrypt password: " + password, (Exception)((Object)ex));
        }
    }

    private void setServerCredentials(String dbUrl) throws MavenReportException {
        try {
            Settings mavenSettings = this.mavenSession.getSettings();
            URI uri = this.getURI(dbUrl);
            uri.parseServerAuthority();
            this.dump("After parseServerAuthority", uri);
            this.getLog().debug((CharSequence)("dbUrl \"" + dbUrl + "\" ..."));
            this.getLog().debug((CharSequence)("Scheme \"" + uri.getScheme() + "\" "));
            this.getLog().debug((CharSequence)("Authority \"" + uri.getAuthority() + "\" "));
            this.getLog().debug((CharSequence)("UserInfo \"" + uri.getUserInfo() + "\" "));
            this.getLog().debug((CharSequence)("Host \"" + uri.getHost() + "\" "));
            this.getLog().debug((CharSequence)("Port \"" + uri.getPort() + "\" "));
            String[] idCandidates = new String[]{dbUrl, "jdbc:" + uri.getSchemeSpecificPart(), "jdbc:" + uri.getAuthority(), "jdbc:" + uri.getUserInfo() + "@" + uri.getHost() + ":" + Integer.toString(uri.getPort()), "jdbc:" + uri.getHost() + ":" + Integer.toString(uri.getPort()), "jdbc:" + uri.getHost(), uri.getHost() + ":" + Integer.toString(uri.getPort()), uri.getHost()};
            for (int id = 0; id < idCandidates.length; ++id) {
                Server server = mavenSettings.getServer(idCandidates[id]);
                if (null != server) {
                    String serverUser = server.getUsername();
                    String serverPassword = server.getPassword();
                    this.getLog().debug((CharSequence)("Server credentials for " + dbUrl + " from Server (" + id + "/" + idCandidates[id] + ") : username=\"" + serverUser + "\"; password=\"" + (null == serverPassword ? "undefined" : "defined") + "\""));
                    this.getLog().debug((CharSequence)("Project credentials for " + dbUrl + " : username=\"" + this.dbUser + "\"; password=\"" + (null == this.dbPassword ? "undefined" : "defined") + "\""));
                    if (null != serverUser && !"".equals(serverUser) && null != serverPassword && !"".equals(serverPassword)) {
                        if (!(null == serverUser || null == this.dbUser || "".equals(serverUser) || "".equals(this.dbUser) || serverUser.equals(this.dbUser))) {
                            throw new MavenReportException("Mismatched Server credentials for dbUrl: " + dbUrl + " - usernames do not match (project DBUser=\"" + this.dbUser + "\" != Server.username =\"" + serverUser + "\"");
                        }
                        this.getLog().debug((CharSequence)("Assigning plugin credentials from Server (" + id + "/" + idCandidates[id] + ")"));
                        this.dbUser = serverUser;
                        this.dbPassword = serverPassword;
                    }
                    return;
                }
                this.getLog().debug((CharSequence)("Server (" + id + "/" + idCandidates[id] + ") is null"));
            }
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace();
            throw new MavenReportException("Failed to identify credentials for dbUrl: " + dbUrl, (Exception)ex);
        }
    }

    private URI getURI(String url) throws URISyntaxException {
        if (url.startsWith("jdbc:")) {
            String[] uriParts;
            URI jdbcURI = new URI(url);
            this.getLog().debug((CharSequence)("setFields - URL=" + url));
            this.dump("jdbcURL", jdbcURI);
            jdbcURI = new URI(url.substring(5));
            this.getLog().debug((CharSequence)("setFields - substr(jdbcURL,5)=" + url.substring(5)));
            this.dump("substr(jdbcURL,5)", jdbcURI);
            jdbcURI = new URI(jdbcURI.getSchemeSpecificPart().replace("@//", "@"));
            this.dump("jdbcURI.getSchemeSpecificPart.replace(1)", jdbcURI);
            jdbcURI = new URI("http://" + jdbcURI.getSchemeSpecificPart().replace("@//", "@"));
            this.dump("jdbcURI.getSchemeSpecificPart.replace(2)", jdbcURI);
            for (String part : uriParts = url.split(":")) {
                this.getLog().debug((CharSequence)("JDBCpart=" + part));
            }
            if (3 == uriParts.length) {
                this.getLog().debug((CharSequence)("subprotocol = " + uriParts[1]));
            } else if (4 <= uriParts.length) {
                this.getLog().debug((CharSequence)("subprotocol =" + uriParts[1]));
                this.getLog().debug((CharSequence)("subnamePrefix =" + uriParts[2]));
            } else {
                throw new URISyntaxException(url, "Could not understand JDBC URL", 1);
            }
            return jdbcURI;
        }
        throw new URISyntaxException(url, "This is not a JDBC URL", 1);
    }

    void dump(String description, URI dburi) {
        String dumpString = String.format("dump (%s)\n: isOpaque=%s, isAbsolute=%s Scheme=%s,\n SchemeSpecificPart=%s,\n Authority=%s,\n UserInfo=%s,\n Host=%s,\n Port=%s,\n Path=%s,\n Fragment=%s,\n Query=%s\n", description, dburi.isOpaque(), dburi.isAbsolute(), dburi.getScheme(), dburi.getSchemeSpecificPart(), dburi.getAuthority(), dburi.getUserInfo(), dburi.getHost(), dburi.getPort(), dburi.getPath(), dburi.getFragment(), dburi.getQuery());
        this.getLog().debug((CharSequence)dumpString);
        String query = dburi.getQuery();
        if (null != query && !"".equals(query)) {
            String[] params;
            for (String param : params = query.split("&")) {
                String[] splits = param.split("=");
                String name = splits[0];
                String value = null;
                if (splits.length > 1) {
                    value = splits[1];
                }
                this.getLog().debug((CharSequence)String.format("name=%s,value=%s\n", name, value));
            }
        }
    }
}

