/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantumldependency.cli.plantumldiagram.classes.relation;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.plantumldependency.cli.plantumldiagram.classes.element.PlantUMLClassesDiagramElement;
import net.sourceforge.plantumldependency.cli.plantumldiagram.classes.relation.PlantUMLClassesDiagramRelation;
import net.sourceforge.plantumldependency.cli.plantumldiagram.classes.relation.PlantUMLClassesDiagramRelationType;
import net.sourceforge.plantumldependency.common.utils.comparable.ComparableResult;

public abstract class AbstractPlantUMLClassesDiagramRelation
implements PlantUMLClassesDiagramRelation {
    private static final long serialVersionUID = 2549425584926638370L;
    private static final transient Logger LOGGER = Logger.getLogger(AbstractPlantUMLClassesDiagramRelation.class.getName());
    private final PlantUMLClassesDiagramElement firstElement;
    private final PlantUMLClassesDiagramElement secondElement;
    private final PlantUMLClassesDiagramRelationType type;

    protected AbstractPlantUMLClassesDiagramRelation(PlantUMLClassesDiagramElement firstElt, PlantUMLClassesDiagramElement secondElt, PlantUMLClassesDiagramRelationType relationType) {
        this.firstElement = firstElt;
        this.secondElement = secondElt;
        this.type = relationType;
    }

    @Override
    public int compareTo(PlantUMLClassesDiagramRelation o) {
        int comparison;
        if (this == o) {
            comparison = ComparableResult.EQUAL.getResult();
        } else {
            comparison = this.getFirstElement().compareTo(o.getFirstElement());
            if (comparison == 0 && (comparison = this.getSecondElement().compareTo(o.getSecondElement())) == 0) {
                comparison = this.getType().compareTo(this.getType());
            }
        }
        return comparison;
    }

    public PlantUMLClassesDiagramRelation deepClone() {
        AbstractPlantUMLClassesDiagramRelation a = null;
        try {
            a = (AbstractPlantUMLClassesDiagramRelation)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            LOGGER.log(Level.SEVERE, "[error-plantuml-dependency-common-006] : A severe and unexpected error has occurred", cnse);
        }
        return a;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractPlantUMLClassesDiagramRelation other = (AbstractPlantUMLClassesDiagramRelation)obj;
        if (this.firstElement == null ? other.firstElement != null : !this.firstElement.equals(other.firstElement)) {
            return false;
        }
        if (this.secondElement == null ? other.secondElement != null : !this.secondElement.equals(other.secondElement)) {
            return false;
        }
        return this.type == other.type;
    }

    @Override
    public PlantUMLClassesDiagramElement getFirstElement() {
        return this.firstElement;
    }

    @Override
    public String getPlantUMLTextDescription() {
        return this.getFirstElement().getName() + this.getType().getRightRelationSymbol() + this.getSecondElement().getName();
    }

    @Override
    public PlantUMLClassesDiagramElement getSecondElement() {
        return this.secondElement;
    }

    @Override
    public PlantUMLClassesDiagramRelationType getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.firstElement == null ? 0 : this.firstElement.hashCode());
        result = 31 * result + (this.secondElement == null ? 0 : this.secondElement.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [firstElementName=" + this.firstElement + ", secondElement=" + this.secondElement + ", type=" + (Object)((Object)this.type) + "]";
    }
}

