/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantumldependency.cli.plantumldiagram.classes.impl;

import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.plantumldependency.cli.plantumldiagram.PlantUMLDiagram;
import net.sourceforge.plantumldependency.cli.plantumldiagram.WithDescription;
import net.sourceforge.plantumldependency.cli.plantumldiagram.classes.PlantUMLClassesDiagram;
import net.sourceforge.plantumldependency.cli.plantumldiagram.classes.element.PlantUMLClassesDiagramElement;
import net.sourceforge.plantumldependency.cli.plantumldiagram.classes.relation.PlantUMLClassesDiagramRelation;
import net.sourceforge.plantumldependency.common.constants.CommonConstants;

public class PlantUMLClassesDiagramImpl
implements PlantUMLClassesDiagram {
    private static final long serialVersionUID = -5603953525431054169L;
    private static final transient Logger LOGGER = Logger.getLogger(PlantUMLClassesDiagramImpl.class.getName());
    private Set<PlantUMLClassesDiagramElement> plantUMLClassesDiagramElements;
    private Set<PlantUMLClassesDiagramRelation> plantUMLClassesDiagramRelations;

    public PlantUMLClassesDiagramImpl() {
        this(new TreeSet<PlantUMLClassesDiagramElement>(), new TreeSet<PlantUMLClassesDiagramRelation>());
    }

    public PlantUMLClassesDiagramImpl(Set<PlantUMLClassesDiagramElement> classesDiagramElements, Set<PlantUMLClassesDiagramRelation> classesDiagramRelations) {
        this.plantUMLClassesDiagramElements = new TreeSet<PlantUMLClassesDiagramElement>(classesDiagramElements);
        this.plantUMLClassesDiagramRelations = new TreeSet<PlantUMLClassesDiagramRelation>(classesDiagramRelations);
    }

    public PlantUMLDiagram deepClone() {
        PlantUMLClassesDiagramImpl p = null;
        try {
            p = (PlantUMLClassesDiagramImpl)super.clone();
            p.plantUMLClassesDiagramElements = new TreeSet<PlantUMLClassesDiagramElement>();
            for (PlantUMLClassesDiagramElement element : this.getPlantUMLClassesDiagramElements()) {
                p.plantUMLClassesDiagramElements.add((PlantUMLClassesDiagramElement)element.deepClone());
            }
            p.plantUMLClassesDiagramRelations = new TreeSet<PlantUMLClassesDiagramRelation>();
            for (PlantUMLClassesDiagramRelation relation : this.getPlantUMLClassesDiagramRelations()) {
                p.plantUMLClassesDiagramRelations.add((PlantUMLClassesDiagramRelation)relation.deepClone());
            }
        }
        catch (CloneNotSupportedException cnse) {
            LOGGER.log(Level.SEVERE, "[error-plantuml-dependency-common-006] : A severe and unexpected error has occurred", cnse);
        }
        return p;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlantUMLClassesDiagramImpl other = (PlantUMLClassesDiagramImpl)obj;
        if (this.plantUMLClassesDiagramElements == null ? other.plantUMLClassesDiagramElements != null : !this.plantUMLClassesDiagramElements.equals(other.plantUMLClassesDiagramElements)) {
            return false;
        }
        return !(this.plantUMLClassesDiagramRelations == null ? other.plantUMLClassesDiagramRelations != null : !this.plantUMLClassesDiagramRelations.equals(other.plantUMLClassesDiagramRelations));
    }

    @Override
    public Set<PlantUMLClassesDiagramElement> getPlantUMLClassesDiagramElements() {
        return new TreeSet<PlantUMLClassesDiagramElement>(this.plantUMLClassesDiagramElements);
    }

    @Override
    public Set<PlantUMLClassesDiagramRelation> getPlantUMLClassesDiagramRelations() {
        return new TreeSet<PlantUMLClassesDiagramRelation>(this.plantUMLClassesDiagramRelations);
    }

    @Override
    public String getPlantUMLTextDescription() {
        StringBuilder plantUMLDeclaractionBuffer = new StringBuilder("@startuml");
        for (WithDescription withDescription : this.getPlantUMLClassesDiagramElements()) {
            plantUMLDeclaractionBuffer.append(CommonConstants.LINE_SEPARATOR);
            plantUMLDeclaractionBuffer.append(withDescription.getPlantUMLTextDescription());
        }
        for (WithDescription withDescription : this.getPlantUMLClassesDiagramRelations()) {
            plantUMLDeclaractionBuffer.append(CommonConstants.LINE_SEPARATOR);
            plantUMLDeclaractionBuffer.append(withDescription.getPlantUMLTextDescription());
        }
        plantUMLDeclaractionBuffer.append(CommonConstants.LINE_SEPARATOR);
        plantUMLDeclaractionBuffer.append("@enduml");
        return plantUMLDeclaractionBuffer.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.plantUMLClassesDiagramElements == null ? 0 : this.plantUMLClassesDiagramElements.hashCode());
        result = 31 * result + (this.plantUMLClassesDiagramRelations == null ? 0 : this.plantUMLClassesDiagramRelations.hashCode());
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [plantUMLClassesDiagramElements=" + this.plantUMLClassesDiagramElements + ", plantUMLClassesDiagramRelations=" + this.plantUMLClassesDiagramRelations + "]";
    }
}

