/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantumldependency.cli.plantumldiagram.classes.element.stereotype.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.plantumldependency.cli.plantumldiagram.classes.element.stereotype.PlantUMLSpottedCharacter;
import net.sourceforge.plantumldependency.common.color.HTMLColor;
import net.sourceforge.plantumldependency.common.utils.comparable.ComparableResult;

public class PlantUMLSpottedCharacterImpl
implements PlantUMLSpottedCharacter {
    private static final long serialVersionUID = 881922222125914220L;
    private static final transient Logger LOGGER = Logger.getLogger(PlantUMLSpottedCharacterImpl.class.getName());
    private final char character;
    private final HTMLColor color;

    public PlantUMLSpottedCharacterImpl(char charact, HTMLColor col) {
        this.character = charact;
        this.color = col;
    }

    @Override
    public int compareTo(PlantUMLSpottedCharacter o) {
        int comparison;
        if (this == o) {
            comparison = ComparableResult.EQUAL.getResult();
        } else {
            comparison = Character.valueOf(this.getCharacter()).compareTo(Character.valueOf(o.getCharacter()));
            if (comparison == ComparableResult.EQUAL.getResult()) {
                comparison = this.getColor().toString().compareTo(o.getColor().toString());
            }
        }
        return comparison;
    }

    public PlantUMLSpottedCharacter deepClone() {
        PlantUMLSpottedCharacterImpl p = null;
        try {
            p = (PlantUMLSpottedCharacterImpl)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            LOGGER.log(Level.SEVERE, "[error-plantuml-dependency-common-006] : A severe and unexpected error has occurred", cnse);
        }
        return p;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlantUMLSpottedCharacterImpl other = (PlantUMLSpottedCharacterImpl)obj;
        if (this.character != other.character) {
            return false;
        }
        return !(this.color == null ? other.color != null : !this.color.equals((Object)other.color));
    }

    @Override
    public char getCharacter() {
        return this.character;
    }

    @Override
    public HTMLColor getColor() {
        return this.color;
    }

    @Override
    public String getPlantUMLTextDescription() {
        return "(" + this.getCharacter() + "," + this.getColor().toHTMLHexString() + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.character;
        result = 31 * result + (this.color == null ? 0 : this.color.hashCode());
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [character=" + this.character + ", color=" + this.color + "]";
    }
}

