/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantumldependency.cli.main.option.programminglanguage.argument.java.type;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.plantumldependency.cli.exception.PlantUMLDependencyException;
import net.sourceforge.plantumldependency.cli.generic.GenericDependency;
import net.sourceforge.plantumldependency.cli.generic.type.DependencyType;
import net.sourceforge.plantumldependency.cli.generic.type.ImportDependenciesCollection;
import net.sourceforge.plantumldependency.cli.main.option.programminglanguage.argument.java.type.AnnotationJavaType;
import net.sourceforge.plantumldependency.cli.main.option.programminglanguage.argument.java.type.ClassJavaType;
import net.sourceforge.plantumldependency.cli.main.option.programminglanguage.argument.java.type.EnumJavaType;
import net.sourceforge.plantumldependency.cli.main.option.programminglanguage.argument.java.type.InterfaceJavaType;
import net.sourceforge.plantumldependency.cli.main.option.programminglanguage.argument.java.type.JavaParentType;
import net.sourceforge.plantumldependency.common.utils.check.ParameterCheckerUtils;
import net.sourceforge.plantumldependency.common.utils.comparable.ComparableResult;
import net.sourceforge.plantumldependency.common.utils.log.LogUtils;
import net.sourceforge.plantumldependency.common.utils.string.StringUtils;

public abstract class JavaType
implements Comparable<JavaType>,
Serializable {
    private static final long serialVersionUID = 13586383951181146L;
    private static final transient Logger LOGGER = Logger.getLogger(JavaType.class.getName());
    public static final JavaType ANNOTATION = new AnnotationJavaType("@interface");
    public static final JavaType CLASS = new ClassJavaType("class");
    public static final JavaType ENUM = new EnumJavaType("enum");
    public static final JavaType INTERFACE = new InterfaceJavaType("interface");
    private static final Map<String, JavaType> JAVA_TYPE_MAP = JavaType.createJavaTypeMap();
    private String languageKeyword;

    private static Map<String, JavaType> createJavaTypeMap() {
        TreeMap<String, JavaType> javaTypeMap = new TreeMap<String, JavaType>();
        javaTypeMap.put(ANNOTATION.getLanguageKeyword(), ANNOTATION);
        javaTypeMap.put(CLASS.getLanguageKeyword(), CLASS);
        javaTypeMap.put(ENUM.getLanguageKeyword(), ENUM);
        javaTypeMap.put(INTERFACE.getLanguageKeyword(), INTERFACE);
        return Collections.unmodifiableMap(javaTypeMap);
    }

    public static Collection<JavaType> getJavaTypeCollection() {
        return JAVA_TYPE_MAP.values();
    }

    public static JavaType valueOfIgnoringCase(String javaTypeKeyword) {
        ParameterCheckerUtils.checkNullOrEmpty((String)javaTypeKeyword, (String)"[error-plantuml-dependency-cli-025] : The java type language keyword is null");
        JavaType javaType = JAVA_TYPE_MAP.get(javaTypeKeyword.toLowerCase());
        if (javaType == null) {
            throw new IllegalArgumentException(LogUtils.buildLogString((String)"[error-plantuml-dependency-cli-034] : The java type \"{0}\" is unknown", (String)javaTypeKeyword));
        }
        LOGGER.log(Level.FINE, LogUtils.buildLogString((String)"[fine-plantuml-dependency-cli-009] : Java type \"{0}\" has been found", (String)javaTypeKeyword));
        return javaType;
    }

    protected JavaType(String programmingLanguageKeyword) {
        this.setLanguageKeyword(programmingLanguageKeyword);
    }

    @Override
    public int compareTo(JavaType o) {
        if (this == o) {
            return ComparableResult.EQUAL.getResult();
        }
        return this.getLanguageKeyword().compareTo(o.getLanguageKeyword());
    }

    public abstract DependencyType createAnnotationDependencyType(String var1, String var2) throws PlantUMLDependencyException;

    public abstract DependencyType createDependencyType(String var1, String var2, boolean var3, ImportDependenciesCollection var4, Set<GenericDependency> var5, Set<GenericDependency> var6, Set<GenericDependency> var7);

    public abstract DependencyType createParentDependencyType(JavaParentType var1, String var2, String var3) throws PlantUMLDependencyException;

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JavaType other = (JavaType)obj;
        return !(this.languageKeyword == null ? other.languageKeyword != null : !this.languageKeyword.equals(other.languageKeyword));
    }

    public abstract boolean extractNativeMethods(String var1);

    public abstract Set<String> extractParentExtensions(String var1) throws PlantUMLDependencyException;

    public abstract Set<String> extractParentImplementations(String var1) throws PlantUMLDependencyException;

    protected Set<String> extractParents(String parentsString) {
        TreeSet<String> parents = new TreeSet<String>();
        if (StringUtils.isEmpty((String)parentsString)) {
            LOGGER.log(Level.FINE, "[fine-plantuml-dependency-cli-008] : The java parent type string to parse is empty, no parent to extract");
        } else {
            StringTokenizer tokenizer = new StringTokenizer(parentsString, ",");
            while (tokenizer.hasMoreTokens()) {
                String interfaceName = tokenizer.nextToken().replace(" ", "");
                parents.add(interfaceName);
            }
        }
        return parents;
    }

    public String getLanguageKeyword() {
        return this.languageKeyword;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.languageKeyword == null ? 0 : this.languageKeyword.hashCode());
        return result;
    }

    private void setLanguageKeyword(String value) {
        ParameterCheckerUtils.checkNullOrEmpty((String)value, (String)"[error-plantuml-dependency-cli-025] : The java type language keyword is null");
        this.languageKeyword = value;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [languageKeyword=" + this.languageKeyword + "]";
    }
}

