/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantumldependency.cli.main.option.programminglanguage.argument.java.type;

import java.util.Set;
import java.util.TreeSet;
import net.sourceforge.plantumldependency.cli.exception.PlantUMLDependencyException;
import net.sourceforge.plantumldependency.cli.generic.GenericDependency;
import net.sourceforge.plantumldependency.cli.generic.type.DependencyType;
import net.sourceforge.plantumldependency.cli.generic.type.ImportDependenciesCollection;
import net.sourceforge.plantumldependency.cli.generic.type.impl.annotationimpl.AnnotationDependencyTypeImpl;
import net.sourceforge.plantumldependency.cli.generic.type.impl.interfaceimpl.InterfaceDependencyTypeImpl;
import net.sourceforge.plantumldependency.cli.main.option.programminglanguage.argument.java.type.JavaParentType;
import net.sourceforge.plantumldependency.cli.main.option.programminglanguage.argument.java.type.JavaType;
import net.sourceforge.plantumldependency.common.utils.check.ParameterCheckerUtils;
import net.sourceforge.plantumldependency.common.utils.log.LogUtils;
import net.sourceforge.plantumldependency.common.utils.string.StringUtils;

class InterfaceJavaType
extends JavaType {
    private static final long serialVersionUID = -5405937103390368720L;

    protected InterfaceJavaType(String programmingLanguageKeyword) {
        super(programmingLanguageKeyword);
    }

    @Override
    public DependencyType createAnnotationDependencyType(String annotationName, String annotationPackageName) throws PlantUMLDependencyException {
        ParameterCheckerUtils.checkNull((Object)annotationName, (String)"[error-plantuml-dependency-cli-012] : The java annotation type name is null");
        ParameterCheckerUtils.checkNull((Object)annotationPackageName, (String)"[error-plantuml-dependency-cli-013] :  The java annotation type package name is null");
        return new AnnotationDependencyTypeImpl(annotationName, annotationPackageName);
    }

    @Override
    public DependencyType createDependencyType(String dependencyName, String dependencyPackageName, boolean isAbstract, ImportDependenciesCollection importDependencies, Set<GenericDependency> parentExtensionsDependencies, Set<GenericDependency> parentImplementationsDependencies, Set<GenericDependency> annotationDependencies) {
        ParameterCheckerUtils.checkNull((Object)dependencyName, (String)"[error-plantuml-dependency-cli-026] : The java type name is null");
        ParameterCheckerUtils.checkNull((Object)dependencyPackageName, (String)"[error-plantuml-dependency-cli-027] : The java type package name is null");
        ParameterCheckerUtils.checkNull((Object)importDependencies, (String)"[error-plantuml-dependency-cli-024] : The java type import dependencies is null");
        ParameterCheckerUtils.checkNull(parentImplementationsDependencies, (String)"[error-plantuml-dependency-cli-023] : The java type implementations dependencies is null");
        ParameterCheckerUtils.checkNull(parentExtensionsDependencies, (String)"[error-plantuml-dependency-cli-021] : The java type extensions dependencies is null");
        ParameterCheckerUtils.checkNull(annotationDependencies, (String)"[error-plantuml-dependency-cli-019] : The java type annotations dependencies is null");
        return new InterfaceDependencyTypeImpl(dependencyName, dependencyPackageName, importDependencies, parentExtensionsDependencies, annotationDependencies);
    }

    @Override
    public DependencyType createParentDependencyType(JavaParentType parentType, String parentName, String parentPackageName) throws PlantUMLDependencyException {
        ParameterCheckerUtils.checkNull((Object)((Object)parentType), (String)"[error-plantuml-dependency-cli-015] : The java parent type is null");
        ParameterCheckerUtils.checkNull((Object)parentName, (String)"[error-plantuml-dependency-cli-014] : The java parent type name is null");
        ParameterCheckerUtils.checkNull((Object)parentPackageName, (String)"[error-plantuml-dependency-cli-016] : The java parent type package name is null");
        InterfaceDependencyTypeImpl dependencyType = null;
        if (JavaParentType.EXTENSION != parentType) {
            if (JavaParentType.IMPLEMENTATION == parentType) {
                throw new PlantUMLDependencyException(LogUtils.buildLogString((String)"[error-plantuml-dependency-cli-010] : The java parent type \"{0}\" is not available for this java type \"{1}\"", (Object[])new Object[]{parentType, this.getLanguageKeyword()}));
            }
            throw new PlantUMLDependencyException(LogUtils.buildLogString((String)"[error-plantuml-dependency-cli-018] : The java parent type \"{0}\" is unknown", (Object)((Object)parentType)));
        }
        dependencyType = new InterfaceDependencyTypeImpl(parentName, parentPackageName);
        return dependencyType;
    }

    @Override
    public boolean extractNativeMethods(String javaSourceFileContent) {
        return false;
    }

    @Override
    public Set<String> extractParentExtensions(String extendsString) throws PlantUMLDependencyException {
        return this.extractParents(extendsString);
    }

    @Override
    public Set<String> extractParentImplementations(String implementsString) throws PlantUMLDependencyException {
        if (StringUtils.isEmpty((String)implementsString)) {
            return new TreeSet<String>();
        }
        throw new PlantUMLDependencyException(LogUtils.buildLogString((String)"[error-plantuml-dependency-cli-017] : The java parent type string \"{0}\" should be null for this java type \"{1}\"", (Object[])new Object[]{implementsString, this.getLanguageKeyword()}));
    }
}

