/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantumldependency.cli.main.option.programminglanguage.argument.java.type;

import java.util.Set;
import net.sourceforge.plantumldependency.cli.constants.RegularExpressionConstants;
import net.sourceforge.plantumldependency.cli.exception.PlantUMLDependencyException;
import net.sourceforge.plantumldependency.cli.generic.GenericDependency;
import net.sourceforge.plantumldependency.cli.generic.type.DependencyType;
import net.sourceforge.plantumldependency.cli.generic.type.ImportDependenciesCollection;
import net.sourceforge.plantumldependency.cli.generic.type.impl.DependencyTypeImpl;
import net.sourceforge.plantumldependency.cli.generic.type.impl.annotationimpl.AnnotationDependencyTypeImpl;
import net.sourceforge.plantumldependency.cli.generic.type.impl.classimpl.ClassAbstractDependencyTypeImpl;
import net.sourceforge.plantumldependency.cli.generic.type.impl.classimpl.ClassDependencyTypeImpl;
import net.sourceforge.plantumldependency.cli.generic.type.impl.interfaceimpl.InterfaceDependencyTypeImpl;
import net.sourceforge.plantumldependency.cli.main.option.programminglanguage.argument.java.type.JavaParentType;
import net.sourceforge.plantumldependency.cli.main.option.programminglanguage.argument.java.type.JavaType;
import net.sourceforge.plantumldependency.common.utils.check.ParameterCheckerUtils;
import net.sourceforge.plantumldependency.common.utils.collection.CollectionUtils;
import net.sourceforge.plantumldependency.common.utils.log.LogUtils;

class ClassJavaType
extends JavaType {
    private static final long serialVersionUID = -2531946270649532504L;

    protected ClassJavaType(String programmingLanguageKeyword) {
        super(programmingLanguageKeyword);
    }

    @Override
    public DependencyType createAnnotationDependencyType(String annotationName, String annotationPackageName) throws PlantUMLDependencyException {
        ParameterCheckerUtils.checkNull((Object)annotationName, (String)"[error-plantuml-dependency-cli-012] : The java annotation type name is null");
        ParameterCheckerUtils.checkNull((Object)annotationPackageName, (String)"[error-plantuml-dependency-cli-013] :  The java annotation type package name is null");
        return new AnnotationDependencyTypeImpl(annotationName, annotationPackageName);
    }

    @Override
    public DependencyType createDependencyType(String dependencyName, String dependencyPackageName, boolean isAbstract, ImportDependenciesCollection importDependencies, Set<GenericDependency> parentExtensionsDependencies, Set<GenericDependency> parentImplementationsDependencies, Set<GenericDependency> annotationDependencies) {
        ParameterCheckerUtils.checkNull((Object)dependencyName, (String)"[error-plantuml-dependency-cli-026] : The java type name is null");
        ParameterCheckerUtils.checkNull((Object)dependencyPackageName, (String)"[error-plantuml-dependency-cli-027] : The java type package name is null");
        ParameterCheckerUtils.checkNull((Object)importDependencies, (String)"[error-plantuml-dependency-cli-024] : The java type import dependencies is null");
        ParameterCheckerUtils.checkNull(parentImplementationsDependencies, (String)"[error-plantuml-dependency-cli-023] : The java type implementations dependencies is null");
        ParameterCheckerUtils.checkNull(parentExtensionsDependencies, (String)"[error-plantuml-dependency-cli-021] : The java type extensions dependencies is null");
        ParameterCheckerUtils.checkNumberOfElementsInCollection(parentExtensionsDependencies, (int)1, (String)"[error-plantuml-dependency-cli-022] : The java type extensions dependencies has too many elements");
        ParameterCheckerUtils.checkNull(annotationDependencies, (String)"[error-plantuml-dependency-cli-019] : The java type annotations dependencies is null");
        ClassDependencyTypeImpl dependencyType = null;
        GenericDependency parentExtensionDependency = (GenericDependency)CollectionUtils.getCollectionFirstElement(parentExtensionsDependencies);
        dependencyType = isAbstract ? new ClassAbstractDependencyTypeImpl(dependencyName, dependencyPackageName, importDependencies, parentExtensionDependency, parentImplementationsDependencies, annotationDependencies) : new ClassDependencyTypeImpl(dependencyName, dependencyPackageName, importDependencies, parentExtensionDependency, parentImplementationsDependencies, annotationDependencies);
        return dependencyType;
    }

    @Override
    public DependencyType createParentDependencyType(JavaParentType parentType, String parentName, String parentPackageName) throws PlantUMLDependencyException {
        ParameterCheckerUtils.checkNull((Object)((Object)parentType), (String)"[error-plantuml-dependency-cli-015] : The java parent type is null");
        ParameterCheckerUtils.checkNull((Object)parentName, (String)"[error-plantuml-dependency-cli-014] : The java parent type name is null");
        ParameterCheckerUtils.checkNull((Object)parentPackageName, (String)"[error-plantuml-dependency-cli-016] : The java parent type package name is null");
        DependencyTypeImpl dependencyType = null;
        if (JavaParentType.EXTENSION == parentType) {
            dependencyType = new ClassDependencyTypeImpl(parentName, parentPackageName);
        } else if (JavaParentType.IMPLEMENTATION == parentType) {
            dependencyType = new InterfaceDependencyTypeImpl(parentName, parentPackageName);
        } else {
            throw new PlantUMLDependencyException(LogUtils.buildLogString((String)"[error-plantuml-dependency-cli-018] : The java parent type \"{0}\" is unknown", (Object)((Object)parentType)));
        }
        return dependencyType;
    }

    @Override
    public boolean extractNativeMethods(String javaSourceFileContent) {
        return RegularExpressionConstants.NATIVE_METHODS_REGEXP.matcher(javaSourceFileContent).find();
    }

    @Override
    public Set<String> extractParentExtensions(String extendsString) throws PlantUMLDependencyException {
        return this.extractParents(extendsString);
    }

    @Override
    public Set<String> extractParentImplementations(String implementsString) throws PlantUMLDependencyException {
        return this.extractParents(implementsString);
    }
}

