/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantumldependency.cli.main.option.programminglanguage.argument.java;

import java.io.Serializable;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.plantumldependency.cli.generic.type.impl.DependencyTypeImpl;
import net.sourceforge.plantumldependency.cli.main.option.programminglanguage.argument.java.type.JavaType;
import net.sourceforge.plantumldependency.common.clone.DeepCloneable;
import net.sourceforge.plantumldependency.common.utils.comparable.ComparableResult;

public class JavaRawDependency
implements Comparable<JavaRawDependency>,
Serializable,
DeepCloneable<JavaRawDependency> {
    private static final long serialVersionUID = -8047630217535429852L;
    private static final transient Logger LOGGER = Logger.getLogger(JavaRawDependency.class.getName());
    private boolean isAbstract;
    private String packageName;
    private JavaType type;
    private String name;
    private boolean nativeMethods;
    private Set<String> parentExtensions;
    private Set<String> parentImplementations;

    public JavaRawDependency() {
    }

    public JavaRawDependency(boolean isAbs, String dependencyPackageName, JavaType javaType, String dependencyName, Set<String> extensions, Set<String> implementations, boolean nativeMth) {
        this.setAbstract(isAbs);
        this.setPackageName(dependencyPackageName);
        this.setType(javaType);
        this.setName(dependencyName);
        this.setParentExtensions(extensions);
        this.setParentImplementations(implementations);
        this.setNativeMethods(nativeMth);
    }

    @Override
    public int compareTo(JavaRawDependency j) {
        int comparison = ComparableResult.EQUAL.getResult();
        if (this != j && (comparison = this.packageName.compareTo(j.packageName)) == ComparableResult.EQUAL.getResult()) {
            comparison = this.name.compareTo(j.name);
        }
        return comparison;
    }

    public JavaRawDependency deepClone() {
        JavaRawDependency j = null;
        try {
            j = (JavaRawDependency)super.clone();
            j.parentExtensions = new TreeSet<String>(this.getParentExtensions());
            j.parentImplementations = new TreeSet<String>(this.getParentImplementations());
        }
        catch (CloneNotSupportedException cnse) {
            LOGGER.log(Level.SEVERE, "[error-plantuml-dependency-common-006] : A severe and unexpected error has occurred", cnse);
        }
        return j;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JavaRawDependency other = (JavaRawDependency)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.packageName == null ? other.packageName != null : !this.packageName.equals(other.packageName));
    }

    public String getFullName() {
        return DependencyTypeImpl.generateDependencyFullName(this.getPackageName(), this.getName());
    }

    public String getName() {
        return this.name;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public Set<String> getParentExtensions() {
        return this.parentExtensions;
    }

    public Set<String> getParentImplementations() {
        return this.parentImplementations;
    }

    public JavaType getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.packageName == null ? 0 : this.packageName.hashCode());
        return result;
    }

    public boolean hasNativeMethods() {
        return this.nativeMethods;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(boolean value) {
        this.isAbstract = value;
    }

    public void setName(String value) {
        this.name = value;
    }

    public void setNativeMethods(boolean value) {
        this.nativeMethods = value;
    }

    public void setPackageName(String value) {
        this.packageName = value;
    }

    public void setParentExtensions(Set<String> value) {
        this.parentExtensions = value;
    }

    public void setParentImplementations(Set<String> value) {
        this.parentImplementations = value;
    }

    public void setType(JavaType value) {
        this.type = value;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [isAbstract=" + this.isAbstract + ", packageName=" + this.packageName + ", type=" + this.type + ", name=" + this.name + ", nativeMethods=" + this.nativeMethods + ", parentExtensions=" + this.parentExtensions + ", parentImplementations=" + this.parentImplementations + "]";
    }
}

