/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantumldependency.cli.main.option.programminglanguage.argument;

import net.sourceforge.plantumldependency.cli.main.option.programminglanguage.argument.ProgrammingLanguage;
import net.sourceforge.plantumldependency.common.utils.string.StringUtils;
import net.sourceforge.plantumldependency.commoncli.exception.CommandLineException;
import net.sourceforge.plantumldependency.commoncli.option.argument.AbstractOptionArgument;

public class PlantUMLDependencyProgrammingLanguageOptionArgument
extends AbstractOptionArgument<ProgrammingLanguage> {
    private static final long serialVersionUID = -151684884591596960L;
    private static final String MAIN_USAGE = "PROGRAMMING_LANGUAGE";
    private static final String USAGE_DESCRIPTION = "PROGRAMMING_LANGUAGE specifies the programming language contains in the source files to analyse. Possible values : " + ProgrammingLanguage.getProgrammingLanguageNamesSet() + ".";

    public PlantUMLDependencyProgrammingLanguageOptionArgument(boolean optionArgumentIsMandatory) {
        super(optionArgumentIsMandatory, new StringBuilder(USAGE_DESCRIPTION));
    }

    protected String getMainUsageDescription() {
        return MAIN_USAGE;
    }

    public ProgrammingLanguage parseArgument(String argument) throws CommandLineException {
        ProgrammingLanguage language = null;
        if (StringUtils.isNotEmpty((String)argument)) {
            try {
                language = ProgrammingLanguage.valueOfIgnoringCase(argument.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new CommandLineException(e.getMessage(), (Throwable)e);
            }
        } else {
            throw new CommandLineException("[error-plantuml-dependency-cli-030] : The programming language name is null");
        }
        return language;
    }
}

